#include "dCalWidget.h"

#include <QDate>
#include <QTimer>
#include <QTime>
#include <QSettings>

#include "settingsdlg.h"

void clearLayout(QLayout *l)
{
  int x = l->count();
  if (x == 0) return;

  QLayoutItem *item;

  while ((x > 0) && ((item = l->takeAt(0)) != 0))
  {
    if (item->layout())
    {
      clearLayout((QLayout *)item->layout());
    }

    if (item->widget() != 0)
    {
      l->removeWidget(item->widget());
      delete item->widget();
    }

    x--;
  }

  if (l->count() > 0) clearLayout(l);
}


dCalWidget::dCalWidget() : QWidget()
{
  layout = 0;

  setAttribute(Qt::WA_TranslucentBackground);

  renewCalendar();
}

void dCalWidget::renewCalendar()
{
  QSettings settings;

  names.setNamedColor(settings.value("color.names", "#FF0").toString());
  days.setNamedColor(settings.value("color.days", "#AAA").toString());
  weekends.setNamedColor(settings.value("color.weekends", "#F00").toString());
  weeks.setNamedColor(settings.value("color.weeks", "#00F").toString());
  cday.setNamedColor(settings.value("color.cday", "#000").toString());
  cdayback.setNamedColor(settings.value("color.cdayback", "#FF0").toString());

  if (layout) clearLayout(layout);
  else layout = new QGridLayout(this);

  QLabel *tmp;

  layout->addWidget(tmp = new QLabel(""), 0, 0, Qt::AlignCenter);
  tmp->setAttribute(Qt::WA_TranslucentBackground);

  QString slang = settings.value("lang", "System").toString();
  QStringList rusNames;
  rusNames << QString::fromUtf8(",пн,вт,ср,чт,пт,сб,вс").split(",");

  for (int i = 1; i < 8; i++)
  {
    layout->addWidget(tmp = new QLabel(QString("<FONT COLOR='%2'>%1</FONT>").arg((slang == "Russian") ? rusNames.at(i) : QDate::shortDayName(i)).arg(names.name())), 0, i, Qt::AlignCenter);
    tmp->setAttribute(Qt::WA_TranslucentBackground);
  }

  int year, month, day;
  QDate date = QDate::currentDate();
  date.getDate(&year, &month, &day);

  int firstWeek = QDate(year, month, 1).weekNumber();
  int lastWeek = QDate(year, month, date.daysInMonth()).weekNumber();

  for (int i = 0; i <= lastWeek - firstWeek; i++)
  {
    layout->addWidget(tmp = new QLabel(QString("<FONT COLOR='%2'>%1</FONT>").arg(QString::number(firstWeek+i)).arg(weeks.name())), i+1, 0, Qt::AlignCenter);
    tmp->setAttribute(Qt::WA_TranslucentBackground);
  }

  for (int i = 1; i <= date.daysInMonth(); i++)
  {
    QDate curr(year, month, i);
    if (i == day)
      layout->addWidget(tmp = new QLabel(QString("<DIV STYLE='background-color:%3;'><FONT COLOR='%2'>%1</FONT></DIV>").arg(QString::number(i)).arg(cday.name()).arg(cdayback.name())), curr.weekNumber()-firstWeek+1, curr.dayOfWeek(), Qt::AlignCenter);
    else if (curr.dayOfWeek() < 6)
      layout->addWidget(tmp = new QLabel(QString("<FONT COLOR='%2'>%1</FONT>").arg(QString::number(i)).arg(days.name())), curr.weekNumber()-firstWeek+1, curr.dayOfWeek(), Qt::AlignCenter);
    else
      layout->addWidget(tmp = new QLabel(QString("<FONT COLOR='%2'>%1</FONT>").arg(QString::number(i)).arg(weekends.name())), curr.weekNumber()-firstWeek+1, curr.dayOfWeek(), Qt::AlignCenter);
    tmp->setAttribute(Qt::WA_TranslucentBackground);
  }

  QTime currentTime, endOfDay(23,59,59);
  QTimer::singleShot((currentTime.secsTo(endOfDay)+2)*1000, this, SLOT(renewCalendar()));
}

void dCalWidget::mousePressEvent(QMouseEvent *event)
{
  renewCalendar();
}

void dCalWidget::showSettingsDialog()
{
  SettingsDialog sdlg;
  sdlg.exec();
  renewCalendar();

//  QMessageBox::warning(this, "hwrd1", "settings dialog");
}
