#include "dCalWidget.h"

#include <QDate>
#include <QTimer>
#include <QTime>
#include <QSettings>
#include <QPainter>

#include <QtCore/QDebug>

#include "settingsdlg.h"

void clearLayout(QLayout *l)
{
  int x = l->count();
  if (x == 0) return;

  QLayoutItem *item;

  while ((x > 0) && ((item = l->takeAt(0)) != 0))
  {
    if (item->layout())
    {
      clearLayout((QLayout *)item->layout());
    }

    if (item->widget() != 0)
    {
      l->removeWidget(item->widget());
      delete item->widget();
    }

    x--;
  }

  if (l->count() > 0) clearLayout(l);
}


dCalWidget::dCalWidget() : QWidget()
{
  layout = 0;

  setAttribute(Qt::WA_TranslucentBackground);

  renewCalendar();
}

void dCalWidget::renewCalendar()
{
  update();

  QSettings settings;

  names = QColor(settings.value("color.names", "#FF0").toString());
  days = QColor(settings.value("color.days", "#AAA").toString());
  weekends = QColor(settings.value("color.weekends", "#F00").toString());
  weeks = QColor(settings.value("color.weeks", "#00F").toString());
  cday = QColor(settings.value("color.cday", "#000").toString());
  cdayback = QColor(settings.value("color.cdayback", "#FF0").toString());

  if (layout) clearLayout(layout);
  else layout = new QGridLayout(this);

  QLabel *tmp;

  layout->addWidget(tmp = new QLabel(""), 0, 0, Qt::AlignCenter);
  tmp->setAttribute(Qt::WA_TranslucentBackground);

  QString slang = settings.value("lang", "System").toString();
  QStringList rusNames;
  rusNames << QString::fromUtf8(",пн,вт,ср,чт,пт,сб,вс").split(",");

  for (int i = 1; i < 8; i++)
  {
    layout->addWidget(tmp = new QLabel(QString("<FONT COLOR='%2'>%1</FONT>").arg((slang == "Russian") ? rusNames.at(i) : QDate::shortDayName(i)).arg(names.name())), 0, i, Qt::AlignCenter);
    tmp->setAttribute(Qt::WA_TranslucentBackground);
  }

  int year, month, day;
  QDate date = QDate::currentDate();
  date.getDate(&year, &month, &day);

  int firstWeek = QDate(year, month, 1).weekNumber();
  int lastWeek = QDate(year, month, date.daysInMonth()).weekNumber();

  if (lastWeek > firstWeek)
  {
    for (int i = 0; i <= lastWeek - firstWeek; i++)
    {
      layout->addWidget(tmp = new QLabel(QString("<FONT COLOR='%2'>%1</FONT>").arg(QString::number(firstWeek+i)).arg(weeks.name())), i+1, 0, Qt::AlignCenter);
      tmp->setAttribute(Qt::WA_TranslucentBackground);
    }
  } else {

    layout->addWidget(tmp = new QLabel(QString("<FONT COLOR='%2'>%1</FONT>").arg(QString::number(firstWeek)).arg(weeks.name())), 1, 0, Qt::AlignCenter);
    tmp->setAttribute(Qt::WA_TranslucentBackground);

    for (int i = 1; i <= lastWeek; i++)
    {
      layout->addWidget(tmp = new QLabel(QString("<FONT COLOR='%2'>%1</FONT>").arg(QString::number(i)).arg(weeks.name())), i+1, 0, Qt::AlignCenter);
      tmp->setAttribute(Qt::WA_TranslucentBackground);
    }
  }

  for (int i = 1; i <= date.daysInMonth(); i++)
  {
    QDate curr(year, month, i);
    int row = curr.weekNumber()-firstWeek+1;
    int col = curr.dayOfWeek();
    if (row < 1) row += firstWeek;

    if (i == day)
      layout->addWidget(tmp = new QLabel(QString("<DIV STYLE='background-color:%3;'><FONT COLOR='%2'>%1</FONT></DIV>").arg(QString::number(i)).arg(cday.name()).arg(cdayback.name())), row, col, Qt::AlignCenter);
    else if (curr.dayOfWeek() < 6)
      layout->addWidget(tmp = new QLabel(QString("<FONT COLOR='%2'>%1</FONT>").arg(QString::number(i)).arg(days.name())), row, col, Qt::AlignCenter);
    else
      layout->addWidget(tmp = new QLabel(QString("<FONT COLOR='%2'>%1</FONT>").arg(QString::number(i)).arg(weekends.name())), row, col, Qt::AlignCenter);
    tmp->setAttribute(Qt::WA_TranslucentBackground);
  }



  QTime currentTime, endOfDay(23,59,59);
  QTimer::singleShot((currentTime.secsTo(endOfDay)+2)*1000, this, SLOT(renewCalendar()));
}

void dCalWidget::mousePressEvent(QMouseEvent *event)
{
  renewCalendar();
}

void dCalWidget::showSettingsDialog()
{
  SettingsDialog sdlg;
  sdlg.exec();
  renewCalendar();
}

void dCalWidget::paintEvent(QPaintEvent *event)
{
  QWidget::paintEvent(event);

  QSettings settings;

  QColor back = QColor(settings.value("color.widgetback", "#000").toString());
  back.setAlpha(settings.value("back.transparence", "100").toInt());

  QPainter p(this);
  p.setBrush(back);
  p.setPen(Qt::NoPen);
  p.drawRoundedRect(rect(), 25, 25);
  p.end();
}
