#include <QFormLayout>
#include <QSettings>
#include <QPushButton>
#include <QComboBox>
#include <QTabWidget>
#include <QVBoxLayout>
#include <QHBoxLayout>

#include "settingsdlg.h"

SettingsDialog::SettingsDialog(QWidget *parent) : QDialog(parent)
{
  QSettings settings;

  setWindowTitle(tr("simplecal settings..."));
  setModal(true);

  QVBoxLayout *vb = new QVBoxLayout;
  setLayout(vb);

  QTabWidget *tabs = new QTabWidget(this);
  QHBoxLayout *hb = new QHBoxLayout;

  vb->addWidget(tabs);
  vb->addLayout(hb);

  QWidget *first = new QWidget(), *second = new QWidget();
  tabs->addTab(first, "Labels");
  tabs->addTab(second, "Other");

  QHBoxLayout *hb2 = new QHBoxLayout(first);;

  QFormLayout *layout1 = new QFormLayout;
  QFormLayout *layout2 = new QFormLayout;

  hb2->addLayout(layout1);
  hb2->addLayout(layout2);

  QFormLayout *layout3 = new QFormLayout(second);

  names = new ColorButton(QColor(settings.value("color.names", "#FF0").toString()));
  days = new ColorButton(QColor(settings.value("color.days", "#AAA").toString()));
  weekends = new ColorButton(QColor(settings.value("color.weekends", "#F00").toString()));
  weeks = new ColorButton(QColor(settings.value("color.weeks", "#00F").toString()));
  cday = new ColorButton(QColor(settings.value("color.cday", "#000").toString()));
  cdayback = new ColorButton(QColor(settings.value("color.cdayback", "#FF0").toString()));

  lang = new QComboBox();
  lang->addItem("System");
  lang->addItem("Russian");

  transparence = new QSlider(Qt::Horizontal);
  transparence->setRange(0, 255);
  transparence->setValue(settings.value("back.transparence", "100").toInt());
  widgetback = new ColorButton(QColor(settings.value("color.widgetback", "#000").toString()));

  QString slang = settings.value("lang", "System").toString();
  for (int i = 0; i < lang->count(); i++)
    if (lang->itemText(i) == slang) lang->setCurrentIndex(i);

  layout1->addRow(tr("Day names:"), names);
  layout1->addRow(tr("Dates:"), days);
  layout1->addRow(tr("Weekends:"), weekends);

  layout2->addRow(tr("Week numbers:"), weeks);
  layout2->addRow(tr("Current day:"), cday);
  layout2->addRow(tr("Current day back:"), cdayback);

  layout3->addRow(tr("Widget background:"), widgetback);
  layout3->addRow(tr("Transparence:"), transparence);
  layout3->addRow(tr("Day names language:"), lang);

  QPushButton *save = new QPushButton("&Save");
  QPushButton *cancel = new QPushButton("&Cancel");

  save->setDefault(true);

  connect(cancel, SIGNAL(clicked()), this, SLOT(close()));
  connect(save, SIGNAL(clicked()), this, SLOT(saveSettings()));

  hb->addWidget(save);
  hb->addWidget(cancel);
}

SettingsDialog::~SettingsDialog() {}

void SettingsDialog::saveSettings()
{
  QSettings settings;
  settings.setValue("color.names", names->getColorName());
  settings.setValue("color.days", days->getColorName());
  settings.setValue("color.weekends", weekends->getColorName());
  settings.setValue("color.weeks", weeks->getColorName());
  settings.setValue("color.cday", cday->getColorName());
  settings.setValue("color.cdayback", cdayback->getColorName());
  settings.setValue("color.widgetback", widgetback->getColorName());
  settings.setValue("back.transparence", transparence->value());
  settings.setValue("lang", lang->currentText());
  close();
}
