#include <QColorDialog>
#include "colorButton.h"

ColorButton::ColorButton(QColor color, QWidget *parent) : QPushButton(parent)
{
  current = color;
  connect(this, SIGNAL(clicked()), this, SLOT(changeColor()));
  updateColor();
}

ColorButton::~ColorButton() {}

void ColorButton::changeColor()
{
  current = QColorDialog::getColor(current, this);
  updateColor();
}

QString ColorButton::getColorName()
{
  return current.name();
}

void ColorButton::updateColor()
{
  QPixmap pix(32,32);
  pix.fill(current);
//  QIcon ico(iconPixmap);
  setIcon(pix);
  setText(current.name());
}
