#include <QFormLayout>
#include <QSettings>
#include <QPushButton>
#include <QComboBox>

#include "settingsdlg.h"

SettingsDialog::SettingsDialog(QWidget *parent) : QDialog(parent)
{
  QSettings settings;

  setWindowTitle(tr("simplecal settings..."));
  setModal(true);
  QFormLayout *layout = new QFormLayout(this);

  names = new WidgetColorPicker();
  days = new WidgetColorPicker();
  weekends = new WidgetColorPicker();
  weeks = new WidgetColorPicker();
  cday = new WidgetColorPicker();
  cdayback = new WidgetColorPicker();

  lang = new QComboBox();
  lang->addItem("System");
  lang->addItem("Russian");

  names->setColor(QColor(settings.value("color.names", "#FF0").toString()));
  days->setColor(QColor(settings.value("color.days", "#AAA").toString()));
  weekends->setColor(QColor(settings.value("color.weekends", "#F00").toString()));
  weeks->setColor(QColor(settings.value("color.weeks", "#00F").toString()));
  cday->setColor(QColor(settings.value("color.cday", "#000").toString()));
  cdayback->setColor(QColor(settings.value("color.cdayback", "#FF0").toString()));

  QString slang = settings.value("lang", "System").toString();
  for (int i = 0; i < lang->count(); i++)
    if (lang->itemText(i) == slang) lang->setCurrentIndex(i);

  layout->addRow(tr("Day names:"), names);
  layout->addRow(tr("Dates:"), days);
  layout->addRow(tr("Weekends:"), weekends);
  layout->addRow(tr("Week numbers:"), weeks);
  layout->addRow(tr("Current day:"), cday);
  layout->addRow(tr("Current day back:"), cdayback);
  layout->addRow(tr("Day names language:"), lang);

  QPushButton *save = new QPushButton("&Save");
  QPushButton *cancel = new QPushButton("&Cancel");

  save->setDefault(true);

  connect(cancel, SIGNAL(clicked()), this, SLOT(close()));
  connect(save, SIGNAL(clicked()), this, SLOT(saveSettings()));

  layout->addRow(save, cancel);
}

SettingsDialog::~SettingsDialog() {}

void SettingsDialog::saveSettings()
{
  QSettings settings;
  settings.setValue("color.names", names->getColorName());
  settings.setValue("color.days", days->getColorName());
  settings.setValue("color.weekends", weekends->getColorName());
  settings.setValue("color.weeks", weeks->getColorName());
  settings.setValue("color.cday", cday->getColorName());
  settings.setValue("color.cdayback", cdayback->getColorName());
  settings.setValue("lang", lang->currentText());
  close();
}
