#ifndef CALWIDGET_H
#define CALWIDGET_H

#include <QtGui/qcalendarwidget.h>

class dCalWidget : public QCalendarWidget
{
    Q_OBJECT

public:
    dCalWidget() : QCalendarWidget()
    {
      setNavigationBarVisible(false);
      setSelectionMode(QCalendarWidget::NoSelection);
      setDateEditEnabled(false);
      setAttribute(Qt::WA_TranslucentBackground);
      setStyleSheet("QAbstractItemView {selection-background-color: rgb(255, 174, 0);background-color: rgb(127, 127, 127,50%);alternate-background-color : rgb(127, 127, 127,50%);}");
    }

public slots:

    void homescreenChanged(bool isOnCurrentHomescreen)
    {
      if (isOnCurrentHomescreen) setSelectedDate(QDate::currentDate());
    }
};

#endif
