/*
 * simple-brightness-applet - simple statusarea applet that allows the user to select the brightness from a range of 1-5
 *
 * Copyright (c) 2009 Faheem Pervez <trippin1@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *      
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *      
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 */

/* #ifdef HAVE_CONFIG_H
#include <config.h>
#endif */ /* unused */

#ifdef HILDON_DISABLE_DEPRECATED
#undef HILDON_DISABLE_DEPRECATED
#endif

#include "simple-brightness-applet.h"

#include <gtk/gtk.h>
#include <hildon/hildon.h>
#include <gconf/gconf-client.h>

HD_DEFINE_PLUGIN_MODULE (SimpleBrightnessApplet, simple_brightness_applet, HD_TYPE_STATUS_MENU_ITEM)

static void simple_brightness_applet_on_gconf_value_changed (GConfClient *gconf_client G_GNUC_UNUSED, guint cnxn_id G_GNUC_UNUSED, GConfEntry *entry G_GNUC_UNUSED, SimpleBrightnessApplet *plugin);
static void simple_brightness_applet_on_value_changed (HildonControlbar *ctrlbar, SimpleBrightnessApplet *plugin);
static void simple_brightness_applet_setup (SimpleBrightnessApplet *plugin);
static void simple_brightness_applet_class_init (SimpleBrightnessAppletClass *class);
static void simple_brightness_applet_class_finalize (SimpleBrightnessAppletClass *class G_GNUC_UNUSED);
static void simple_brightness_applet_init (SimpleBrightnessApplet *plugin);
static void simple_brightness_applet_finalize (GObject *object);

#define SIMPLE_BRIGHTNESS_GCONF_PATH "/system/osso/dsm/display"
#define BRIGHTNESS_KEY SIMPLE_BRIGHTNESS_GCONF_PATH "/display_brightness"

#define SIMPLE_BRIGHTNESS_APPLET_GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE ((obj), \
                        SIMPLE_TYPE_BRIGHTNESS_APPLET, SimpleBrightnessAppletPrivate))

typedef struct _SimpleBrightnessAppletPrivate SimpleBrightnessAppletPrivate;

struct _SimpleBrightnessAppletPrivate
{
    GtkHBox *contents;
    HildonControlbar *ctrlbar;
    guint ctrlbar_valchanged_id;
    GConfClient *gconf_client;
    guint gconfnotify_id;
};

static void simple_brightness_applet_on_gconf_value_changed (GConfClient *gconf_client G_GNUC_UNUSED, guint cnxn_id G_GNUC_UNUSED, GConfEntry *entry G_GNUC_UNUSED, SimpleBrightnessApplet *plugin)
{
   SimpleBrightnessAppletPrivate *priv = SIMPLE_BRIGHTNESS_APPLET_GET_PRIVATE (plugin);

   g_signal_handler_block (priv->ctrlbar, priv->ctrlbar_valchanged_id);
   hildon_controlbar_set_value (priv->ctrlbar, gconf_client_get_int(priv->gconf_client, BRIGHTNESS_KEY, NULL));
   g_signal_handler_unblock (priv->ctrlbar, priv->ctrlbar_valchanged_id);
}

static void simple_brightness_applet_on_value_changed (HildonControlbar *ctrlbar G_GNUC_UNUSED, SimpleBrightnessApplet *plugin)
{
   SimpleBrightnessAppletPrivate *priv = SIMPLE_BRIGHTNESS_APPLET_GET_PRIVATE (plugin);

   gconf_client_set_int (priv->gconf_client, BRIGHTNESS_KEY, hildon_controlbar_get_value (priv->ctrlbar), NULL);
}

static void simple_brightness_applet_setup (SimpleBrightnessApplet *plugin)
{
   GtkWidget *image;
   GdkPixbuf *pixbuf;
   SimpleBrightnessAppletPrivate *priv = SIMPLE_BRIGHTNESS_APPLET_GET_PRIVATE (plugin);

   priv->contents = GTK_HBOX (gtk_hbox_new (0, FALSE));

   pixbuf = gtk_icon_theme_load_icon (gtk_icon_theme_get_default(), "general_brightness", 64, 0, NULL);
   if (pixbuf != NULL)
   {
   	image = gtk_image_new_from_pixbuf (pixbuf);
   	g_object_unref (pixbuf);
	pixbuf = NULL;
   	gtk_box_pack_start (GTK_BOX (priv->contents), image, FALSE, FALSE, 0);
   }

   priv->ctrlbar = HILDON_CONTROLBAR (hildon_controlbar_new ()); /* Yes, I know: I'm very naughty for using a depreciated widget. But let me know, Nokia, when you actually stop using it too. */
   hildon_controlbar_set_range (priv->ctrlbar, gconf_client_get_int(priv->gconf_client, "/system/osso/dsm/display/display_brightness_level_step", NULL), gconf_client_get_int(priv->gconf_client, "/system/osso/dsm/display/max_display_brightness_levels", NULL));
   hildon_controlbar_set_value (priv->ctrlbar, gconf_client_get_int(priv->gconf_client, BRIGHTNESS_KEY, NULL));
   priv->ctrlbar_valchanged_id = g_signal_connect (priv->ctrlbar, "value-changed", G_CALLBACK(simple_brightness_applet_on_value_changed), plugin);
   gtk_box_pack_start (GTK_BOX (priv->contents), GTK_WIDGET (priv->ctrlbar), TRUE, TRUE, 0);

   gconf_client_add_dir (priv->gconf_client, SIMPLE_BRIGHTNESS_GCONF_PATH, GCONF_CLIENT_PRELOAD_NONE, NULL);
   priv->gconfnotify_id = gconf_client_notify_add (priv->gconf_client, BRIGHTNESS_KEY, (GConfClientNotifyFunc)simple_brightness_applet_on_gconf_value_changed, plugin, NULL, NULL);
}

static void simple_brightness_applet_class_init (SimpleBrightnessAppletClass *class)
{
   GObjectClass *object_class = G_OBJECT_CLASS (class);

   object_class->finalize = simple_brightness_applet_finalize;

   g_type_class_add_private (class, sizeof (SimpleBrightnessAppletPrivate));
}

static void simple_brightness_applet_class_finalize (SimpleBrightnessAppletClass *class G_GNUC_UNUSED)
{
}

static void simple_brightness_applet_init (SimpleBrightnessApplet *plugin)
{
   SimpleBrightnessAppletPrivate *priv = SIMPLE_BRIGHTNESS_APPLET_GET_PRIVATE (plugin);

   priv->gconf_client = gconf_client_get_default ();
   simple_brightness_applet_setup (plugin);
   gtk_container_add (GTK_CONTAINER (plugin), GTK_WIDGET(priv->contents));
   gtk_widget_show_all (GTK_WIDGET(plugin));
}

static void simple_brightness_applet_finalize (GObject *object)
{
   SimpleBrightnessApplet *plugin = SIMPLE_BRIGHTNESS_APPLET (object);
   SimpleBrightnessAppletPrivate *priv = SIMPLE_BRIGHTNESS_APPLET_GET_PRIVATE (plugin);

   g_signal_handler_disconnect (priv->ctrlbar, priv->ctrlbar_valchanged_id);

   gconf_client_notify_remove (priv->gconf_client, priv->gconfnotify_id);
   gconf_client_remove_dir (priv->gconf_client, SIMPLE_BRIGHTNESS_GCONF_PATH, NULL);
   gconf_client_clear_cache (priv->gconf_client);
   g_object_unref (priv->gconf_client);
   priv->gconf_client = NULL;

   G_OBJECT_CLASS (simple_brightness_applet_parent_class)->finalize (object);
}

SimpleBrightnessApplet* simple_brightness_applet_new (void)
{
  return g_object_new (SIMPLE_TYPE_BRIGHTNESS_APPLET, NULL);
}
