'''
Created on 26/09/2012


    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
    THE SOFTWARE.

Clase que gestiona la base de datos de los logros

@author: Andros Fenollosa
@contact: correoandros@gmail.com
'''
from threading import Thread
import sqlite3 as lite
import time

class Logros_class(Thread):
    
    # Constantes #
    iLogro1 = 0
    iLogro2 = 0
    iLogro3 = 0
    iLogro4 = 0
    iLogro5 = 0
    iLogro6 = 0
    iLogro7 = 0
    iLogro8 = 0
    iLogro9 = 0
    tarjLoNueAv = False
    __con = None
    __sNomBD = "Logros.sqlite"
    __sSQLConsulta = "SELECT * FROM logros;"
    __iTiempCompro = 5
    iBotonAnti = 0
    iBotonAnti1 = 0
    iBotonAnti2 = 0
    iBotonAnti3 = 0
    iBotonAnti4 = 0

    def __init__(self):
        Thread.__init__(self)
        self.__con = lite.connect(self.__sNomBD) 
        cur = self.__con.cursor()    
        cur.execute(self.__sSQLConsulta)
        rows = cur.fetchall()
    
        for row in rows:
            if row[0] == 1:
                self.iLogro1 = row[1]
            if row[0] == 2:
                self.iLogro2 = row[1]
            if row[0] == 3:
                self.iLogro3 = row[1]
            if row[0] == 4:
                self.iLogro4 = row[1]
            if row[0] == 5:
                self.iLogro5 = row[1]
            if row[0] == 6:
                self.iLogro6 = row[1]
            if row[0] == 7:
                self.iLogro7 = row[1]
            if row[0] == 8:
                self.iLogro8 = row[1]
            if row[0] == 9:
                self.iLogro9 = row[1]
                
        
    # Metodo que comprueba si hay cambios entre la base de datos y 
    # los datos recogidos al inicio. Si se produce alguna modificacion
    # se sobreescribe en la base de datos.
    def run(self):
        while True:
            time.sleep(self.__iTiempCompro)
            bCambio = False
            self.__con = lite.connect(self.__sNomBD) 
            cur = self.__con.cursor()    
            cur.execute(self.__sSQLConsulta)
            rows = cur.fetchall()
        
            for row in rows:
                if row[0] == 1:
                    if self.iLogro1 != row[1]:
                        bCambio = True
                if row[0] == 2:
                    if self.iLogro2 != row[1]:
                        bCambio = True
                if row[0] == 3:
                    if self.iLogro3 != row[1]:
                        bCambio = True
                if row[0] == 4:
                    if self.iLogro4 != row[1]:
                        bCambio = True
                if row[0] == 5:
                    if self.iLogro5 != row[1]:
                        bCambio = True
                if row[0] == 6:
                    if self.iLogro6 != row[1]:
                        bCambio = True
                if row[0] == 7:
                    if self.iLogro7 != row[1]:
                        bCambio = True
                if row[0] == 8:
                    if self.iLogro8 != row[1]:
                        bCambio = True
                if row[0] == 9:
                    if self.iLogro9 != row[1]:
                        bCambio = True
            
            if bCambio == True:
                self.__modificarDatos()
                
    # Metodo que modifica los logros de la base de datos  
    def __modificarDatos(self):
        self.__con = lite.connect(self.__sNomBD) 
        cur = self.__con.cursor()    
        cur.execute("UPDATE logros SET estado = '" + str(self.iLogro1) + "' WHERE id = '1'")
        cur.execute("UPDATE logros SET estado = '" + str(self.iLogro2) + "' WHERE id = '2'")
        cur.execute("UPDATE logros SET estado = '" + str(self.iLogro3) + "' WHERE id = '3'")
        cur.execute("UPDATE logros SET estado = '" + str(self.iLogro4) + "' WHERE id = '4'")
        cur.execute("UPDATE logros SET estado = '" + str(self.iLogro5) + "' WHERE id = '5'")
        cur.execute("UPDATE logros SET estado = '" + str(self.iLogro6) + "' WHERE id = '6'")
        cur.execute("UPDATE logros SET estado = '" + str(self.iLogro7) + "' WHERE id = '7'")
        cur.execute("UPDATE logros SET estado = '" + str(self.iLogro8) + "' WHERE id = '8'")
        cur.execute("UPDATE logros SET estado = '" + str(self.iLogro9) + "' WHERE id = '9'")
        self.__con.commit()
        
    #Metodo que comprueba si se ha desbloqueado un logro
    def verificarLogro(self, inaListJug, iniBoton):
        self.iBotonAnti = iniBoton
        
        #Logro juegar una vez  
        if self.iLogro1 != 2 and iniBoton == 5:
            self.iLogro1 = 2
            self.tarjLoNueAv = True
        
        #Logro Record 5 
        if self.iLogro2 != 2 and self.contarBotones(inaListJug) > 5:
            self.iLogro2 = 2
            self.tarjLoNueAv = True
        
        #Logro Record 15 
        if self.iLogro3 != 2 and self.contarBotones(inaListJug) > 15:
            self.iLogro3 = 2
            self.tarjLoNueAv = True
        
        #Logro Record 25 
        if self.iLogro4 != 2 and self.contarBotones(inaListJug) > 25:
            self.iLogro4 = 2
            self.tarjLoNueAv = True
        
        #Logro Record 35   
        if self.iLogro5 != 2 and self.contarBotones(inaListJug) > 35:
            self.iLogro5 = 2
            self.tarjLoNueAv = True
        
        #Logro Record 50 
        if self.iLogro6 != 2 and self.contarBotones(inaListJug) > 50:
            self.iLogro6 = 2
            self.tarjLoNueAv = True
            
        #Logro 'yo soy espanyol'
        if self.iLogro7 != 2:
            for i in range(self.contarBotones(inaListJug) - 3):
                if inaListJug[i] == 3 and inaListJug[i + 1] == 1 and  inaListJug[i + 2] == 3:
                    self.iLogro7 = 2
                    self.tarjLoNueAv = True
                    
        #Logro Simon vs Simon
        if self.iLogro8 != 2 and self.iBotonAnti == 5 and iniBoton == 5:
            self.iLogro8 = 2
            self.tarjLoNueAv = True
            
        #Logro 'Sabes jugar?'
        if self.iBotonAnti == 5:
            self.iBotonAnti1 = 0
            self.iBotonAnti2 = 0
            self.iBotonAnti3 = 0
            self.iBotonAnti4 = 0
        else:
            if self.iBotonAnti1 == 0:
                self.iBotonAnti1 = iniBoton
            else:
                if self.iBotonAnti2 == 0:
                    self.iBotonAnti2 = iniBoton
                else:
                    if self.iBotonAnti3 == 0:
                        self.iBotonAnti3 = iniBoton
                    else:
                        if self.iBotonAnti4 == 0:
                            self.iBotonAnti4 = iniBoton
            
        if self.iLogro9 != 2 and self.iBotonAnti1 != 0 and self.iBotonAnti2 != 0 and self.iBotonAnti3 != 0 and self.iBotonAnti4 != 0:
            self.iLogro9 = 2
            self.tarjLoNueAv = True
                    
    #Metodo que cuenta botones dentro de array
    def contarBotones(self, inaListaJug):
        iNum = 0
        for i in range(len(inaListaJug)):
            if inaListaJug[i] == 1 or inaListaJug[i] == 2 or inaListaJug[i] == 3 or inaListaJug[i] == 4:
                iNum = iNum + 1
        return iNum
        