'''
Created on 23/07/2012


    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
    THE SOFTWARE.

Clase con la logica del juego

@author: Andros Fenollosa
@contact: correoandros@gmail.com
'''
import random, pygame, time
from threading import Thread

class Dominio_class(Thread):
    
    def __init__(self):
        Thread.__init__(self)
        pygame.init()
        pygame.mixer.init()
        pygame.mixer.pre_init(44100, -16, 2, 2048)
        self.numRecord = 0
        self.bJugando = False
        self.limite = 999
        self.listaOrd = list(range(self.limite))
        self.listaJug =  list(range(self.limite))
        self.sUrlRutaMaemo = "/opt/simonKM/"
        self.soundRojo = self.sUrlRutaMaemo + 'sounds/simonSound1.wav'
        self.soundVerde = self.sUrlRutaMaemo + 'sounds/simonSound2.wav'
        self.soundAzul = self.sUrlRutaMaemo + 'sounds/simonSound3.wav'
        self.soundAmarillo = self.sUrlRutaMaemo + 'sounds/simonSound4.wav'
        self.soundStart = self.sUrlRutaMaemo + 'sounds/start.wav'
        self.soundError = self.sUrlRutaMaemo + 'sounds/error.wav'
        self.soundLogros = self.sUrlRutaMaemo + 'sounds/logro.wav'
        self.JugadorPulsa = False
        self.botonEntrante = 0
        self.JugadorNumPulsado = 0
        self.tiempCpuBoton = 0.5
        self.numRecordJugador = 0
        self.numRecordJugadorPart1 = 0
        self.numRecordJugadorPart2 = 0
        self.numRecordJugadorPart3 = 0
        
        self.bAmarillo = False
        self.bAzul = False
        self.bRojo = False
        self.bVerde = False
        self.bStart = False
        self.bLogrosSub = False
        self.bLogrosBaj = False
        self.bLogrosDespl = False
        self.iTimpMilAnim = 0.02
        self.tarjLoPosX = 747
        self.tarjLoTope= self.tarjLoPosX
        self.tarjLoIncr = 10
        
    # Reinicia el juego
    def __PararJuego(self):
        self.numRecord = 0
        self.bJugando = False
        
    # Gestiona la logica del juego
    def __logica(self):
        while True:
            #Despliega o replega la hoja de logros
            if self.bLogrosSub == True:
                if self.tarjLoPosX > 0:
                    time.sleep(self.iTimpMilAnim)
                    self.tarjLoPosX = self.tarjLoPosX - self.tarjLoIncr
                else:
                    self.tarjLoPosX = 0
                    self.bLogrosSub = False
                    self.bLogrosDespl = True
            if self.bLogrosBaj == True:
                if self.tarjLoPosX < self.tarjLoTope:
                    time.sleep(self.iTimpMilAnim)
                    self.tarjLoPosX = self.tarjLoPosX + self.tarjLoIncr
                else:
                    self.tarjLoPosX = self.tarjLoTope
                    self.bLogrosBaj = False
                    self.bLogrosDespl = False
                    
            #Prepara el juego
            if self.bJugando == False and self.botonEntrante == 5:
                self.bJugando = True
                #Genera el ordenador la secuencia de colores: 1 - Amarillo, 2 - Azul, 3 - Rojo, 4 - Verde
                for i in range(self.limite):
                    numNueSecu = random.randint(1, 4)
                    self.listaOrd[i] = numNueSecu
                self.JugadorPulsa = False
                #Empieza juego
                while self.bJugando == True and self.verificarBotonesPulsados() == True :
                    time.sleep(self.tiempCpuBoton)
                    self.numRecord += 1
                    self.pulsarBotones(self.listaOrd, self.numRecord)
                    #Recoge convinacion del jugador
                    while self.numRecord > self.JugadorNumPulsado and self.verificarBotonesPulsados() == True :
                        if self.JugadorPulsa == True:
                            self.listaJug[self.JugadorNumPulsado] = self.botonEntrante
                            self.JugadorPulsa = False
                            self.JugadorNumPulsado += 1
                    if self.verificarBotonesPulsados() == True:
                        self.JugadorNumPulsado = 0
                    else:
                        self.reproducirSonido(self.soundError)
                #Juego terminado
                self.__PararJuego()
                    
    # Metodo que comprueba si el numero de botones pulsados por el usuario se corresponde con los del ordenador    
    def verificarBotonesPulsados(self):
        self.numRecordJugador = 0
        bFinal = True
        if self.bJugando == True and self.numRecord > 1:
            for i in range(self.numRecord - 1):
                self.numRecordJugador = self.numRecordJugador + 1
                if self.listaJug[i] != self.listaOrd[i] :
                    bFinal = False
        if bFinal == False:
            self.numRecordJugador = self.numRecordJugador - 1
            
        self.separarNumRecord(self.numRecordJugador)
        
        return bFinal
                
    # Metodo que separa el numero en tres, y los guarda en sus variables correspondientes            
    def separarNumRecord(self, inNum):
        aNum = list(str(inNum))
        
        if len(aNum) >= 3:
            self.numRecordJugadorPart1 = aNum[0]
            self.numRecordJugadorPart2 = aNum[1]
            self.numRecordJugadorPart3 = aNum[2]
        elif len(aNum) >= 2:
            self.numRecordJugadorPart1 = aNum[0]
            self.numRecordJugadorPart2 = aNum[1]
        else:
            self.numRecordJugadorPart1 = aNum[0]

        
    # Recoge el boton pulsado        
    def recogerBoton(self, inBoton):
        self.botonEntrante = self.averiguarNumBoton(inBoton)
        self.JugadorPulsa = True
        self.reproducirSonidoBoton(self.averiguarNumBoton(inBoton))
    
    #Reproduce un sonido
    def reproducirSonido(self, inFile):
        pygame.mixer.music.load(inFile)
        pygame.mixer.music.play()
    
    # Asigna un numero al boton: 1 - Amarillo, 2 - Azul, 3 - Rojo, 4 - Verde, 5 - Start, 6 - Desplegar logros
    def averiguarNumBoton(self, inBoton):
        if inBoton == "pushAmarillo":
            return 1
        elif inBoton == "pushAzul":
            return 2
        elif inBoton == "pushRojo":
            return 3
        elif inBoton == "pushVerde":
            return 4
        elif inBoton == "pushButton":
            return 5
        elif inBoton == "pushLogroDesplegar" or inBoton == "pushLogroReplegar":
            return 6
        
    # Metodo que pulsa los botones por orden de un array entrante, ignorando tamanyo y usando iniLimit 
    def pulsarBotones(self, inaListB, iniLimit):
        if self.verificarBotonesPulsados() == True :
            for i in range(iniLimit):
                time.sleep(self.tiempCpuBoton)
                self.reproducirSonidoBoton(inaListB[i])
                if inaListB[i] == 1:
                    self.bAmarillo = True
                elif inaListB[i] == 2:
                    self.bAzul = True
                elif inaListB[i] == 3:
                    self.bRojo = True
                elif inaListB[i] == 4:
                    self.bVerde = True
    
    def reproducirSonidoBoton(self, inBoton): 
        if 1 == inBoton :
            self.reproducirSonido(self.soundAmarillo)
        elif 2 == inBoton :
            self.reproducirSonido(self.soundAzul)
        elif 3 == inBoton :
            self.reproducirSonido(self.soundRojo)
        elif 4 == inBoton :
            self.reproducirSonido(self.soundVerde)
        elif 5 == inBoton :
            self.reproducirSonido(self.soundStart)   
        elif 6 == inBoton :
            self.reproducirSonido(self.soundLogros)
    
    def run(self):
        self.__logica()