/* File: defines.h */

/*
 * Copyright (c) 1997 Ben Harrison, James E. Wilson, Robert A. Koeneke
 *
 * This software may be copied and distributed for educational, research,
 * and not for profit purposes provided that this copyright and statement
 * are included in all such copies.  Other copyrights may also apply.
 */



/*
 * Do not edit this file unless you know *exactly* what you are doing.
 *
 * Some of the values in this file were chosen to preserve game balance,
 * while others are hard-coded based on the format of old save-files, the
 * definition of arrays in various places, mathematical properties, fast
 * computation, storage limits, or the format of external text files.
 *
 * Changing some of these values will induce crashes or memory errors or
 * savefile mis-reads.  Most of the comments in this file are meant as
 * reminders, not complete descriptions, and even a complete knowledge
 * of the source may not be sufficient to fully understand the effects
 * of changing certain definitions.
 *
 * Lastly, note that the code does not always use the symbolic constants
 * below, and sometimes uses various hard-coded values that may not even
 * be defined in this file, but which may be related to definitions here.
 * This is of course bad programming practice, but nobody is perfect.
 *
 * For example, there are MANY things that depend on the screen being
 * 80x24, with the top line used for messages, the bottom line being
 * used for status, and exactly 22 lines used to show the dungeon.
 * Just because your screen can hold 46 lines does not mean that the
 * game will work if you try to use 44 lines to show the dungeon.
 *
 * You have been warned.
 */


#define DEPLOYMENT	1	// 1 if the game being built for deployment, 0 for development

/*
 * Name of the version/variant
 */
#define VERSION_NAME "Sil"


/*
 * Current version string
 */
#define VERSION_STRING	"1.0.2"


/*
 * Current version numbers
 */
#define VERSION_MAJOR	1
#define VERSION_MINOR	0
#define VERSION_PATCH	2
#define VERSION_EXTRA	0


/*
 * Oldest version number that can still be imported
 */
#define OLD_VERSION_MAJOR	1
#define OLD_VERSION_MINOR	0
#define OLD_VERSION_PATCH	0


/*
 * Version of random artefact code.
 */
#define RANDART_VERSION	62


/*
 * Number of grids in each block (vertically)
 * Probably hard-coded to 11, see "generate.c"
 */
#define BLOCK_HGT	11

/*
 * Number of grids in each block (horizontally)
 * Probably hard-coded to 11, see "generate.c"
 */
#define BLOCK_WID	11


/*
 * Number of grids in each panel (vertically)
 * Must be a multiple of BLOCK_HGT
 */
#define PANEL_HGT	11

/*since dungeon generation uses PANEL wid to generate dungeons,
 *the width there can't be dependent on bigtile mode.
 */

#define PANEL_WID_FIXED	33
/*
 * Number of grids in each panel (horizontally)
 * Must be a multiple of BLOCK_WID
 */
#define PANEL_WID	(use_bigtile ? 16 : PANEL_WID_FIXED)



#define ROW_MAP			1
#define COL_MAP			13


/*
 * Number of grids in each screen (vertically)
 */
#define SCREEN_HGT	(Term->hgt - ROW_MAP - 1)

/*
 * Number of grids in each screen (horizontally)
 */
#define SCREEN_WID	((Term->wid - COL_MAP - 1) / (use_bigtile ? 2 : 1))


/*
 * Number of grids in each dungeon (horizontally)
 * Must be a multiple of SCREEN_HGT
 * Must be less or equal to 256
 */
#define MAX_DUNGEON_HGT		(5 * 11)

/*
 * Number of grids in each dungeon (vertically)
 * Must be a multiple of SCREEN_WID
 * Must be less or equal to 256
 */
#define MAX_DUNGEON_WID		(5 * 33)

/*
 * Max number of rooms in dungeon.
 */
#define DUN_ROOMS	50

/*
 * Maximum amount of Angband windows.
 */
#define ANGBAND_TERM_MAX 8

/*
 * Maximum number of player "sex" types (see "table.c", etc)
 */
#define MAX_SEXES            2

/*
 * Player sex constants (hard-coded by save-files, arrays, etc)
 */
#define SEX_FEMALE		0
#define SEX_MALE		1
#define SEX_UNDEFINED	2

/*
 * Strange pointer constant for the Player
 * used when I need an m_ptr for the player
 */
#define PLAYER			(monster_type *) 1


/*
 * Maximum amount of starting equipment
 */
#define MAX_START_ITEMS	4


/*
 * Number of tval/min-sval/max-sval slots per ego_item
 */
 
// Sil-y: increaed this from 3 to 4. Should be fine...
#define EGO_TVALS_MAX 4

/*
 * Number of tval/min-sval/max-sval slots per ability
 */
#define ABILITY_TVALS_MAX 5

/*
 * Maximum number of high scores in the high score file
 */
#define MAX_HISCORES	100


/*
 * Maximum dungeon level.  The player can never reach this level
 * in the dungeon, and this value is used for various calculations
 * involving object and monster creation.  It must be at least 100.
 * Setting it below 128 may prevent the creation of some objects.
 *
 * Sil:
 * Since BAD THINGS seem to happen when this is modified to less than 100,
 * I've introduced a separate constant MORGOTH_DEPTH to specify the
 * level that contains Morgoth's throne room and which you cannot go below.
 * The original MAX_DEPTH constant is used in places not relating to this
 * (such as during initialisation)
 */
#define MAX_DEPTH		128
#define MORGOTH_DEPTH	 20


/*
 * Locations of various monsters in the monster.txt file
 */

#define R_IDX_ORC_ARCHER		 51
#define R_IDX_EASTERLING_SPY	 74
#define R_IDX_ORC_CHAMPION		 81
#define R_IDX_ORC_CAPTAIN		 91
#define R_IDX_BARROW_WIGHT		103
#define R_IDX_CAT_WARRIOR		154
#define R_IDX_YOUNG_COLD_DRAKE  164
#define R_IDX_TROLL_GUARD		172
#define R_IDX_CAT_ASSASSIN		175
#define R_IDX_YOUNG_FIRE_DRAKE  181
#define R_IDX_SILENT_WATCHER	203
#define R_IDX_GOTHMOG			241	// the location of Gothmog
#define R_IDX_UNGOLIANT			242	// the location of Ungoliant
#define R_IDX_GLAURUNG			243	// the location of Glaurung
#define R_IDX_GORTHAUR			244	// the location of Gorthaur
#define R_IDX_MORGOTH			251	// the location of Morgoth
#define R_IDX_MORGOTH_UNCROWNED	252	// the location of Morgoth (uncrowned)
#define R_IDX_CARCHAROTH		253 // the location of Carcharoth
#define R_IDX_MORGOTH_HALLU		401	// the location of Morgoth's hallucination image


/*
 * Maximum size of the "view" array (see "cave.c")
 * Note that the "view radius" will NEVER exceed 20, and even if the "view"
 * was octagonal, we would never require more than 1520 entries in the array.
 */
#define VIEW_MAX 1536

/*
 * Maximum size of the "temp" array (see "cave.c")
 * Note that we must be as large as "VIEW_MAX" for proper functioning
 * of the "update_view()" function, and we must also be as large as the
 * largest illuminatable room, but no room is larger than 800 grids.  We
 * must also be large enough to allow "good enough" use as a circular queue,
 * to calculate monster flow, but note that the flow code is "paranoid".
 */
#define TEMP_MAX 1536

#define FLOW_PASS_DOORS	      0
#define FLOW_NO_DOORS	      1
#define FLOW_REAL_NOISE   	  2
#define FLOW_MON_NOISE	      3
#define FLOW_WANDERING_HEAD   4
#define FLOW_WANDERING_TAIL 104
#define MAX_FLOWS		    104

/*
 * Maximum distance from the character to store flow (noise) information
 */
#define NOISE_STRENGTH   80
#define NOISE_MAX_DIST  200

#define BASE_FLOW_CENTER 100

/*
 * Character turns it takes for smell to totally dissipate
 */
#define SMELL_STRENGTH   80


/*
 * Number of combat rolls stored in memory per round
 */
#define MAX_COMBAT_ROLLS		50

// Types of combat roll storage
#define COMBAT_ROLL_NONE   1
#define COMBAT_ROLL_ROLL   1
#define COMBAT_ROLL_AUTO   2

/*
 * Action types (for remembering what the player did)
 */
#define ACTION_MAX		6	// number of actions stored

#define ACTION_NOTHING	0	// the default, showing that no action has yet been written

// then the different movement directions
// then possibly add more action types (such as melee, drink potion etc)
#define ACTION_MISC		10


/*
 * OPTION: Maximum number of macros (see "util.c")
 * Default: assume at most 256 macros are used
 */
#define MACRO_MAX	256

/*
 * OPTION: Maximum number of "quarks" (see "util.c")
 * Default: assume at most 512 different inscriptions are used
 */
#define QUARK_MAX	512

/*
 * OPTION: Maximum number of autoinscriptions(see "object1.c")
 */
#define AUTOINSCRIPTIONS_MAX 216

/*
 * OPTION: Maximum number of messages to remember (see "util.c")
 * Default: assume maximal memorization of 2048 total messages
 */
#define MESSAGE_MAX	2048

/*
 * OPTION: Maximum space for the message text buffer (see "util.c")
 * Default: assume that each of the 2048 messages is repeated an
 * average of three times, and has an average length of 48
 */
#define MESSAGE_BUF	32768


/*
 * Maximum value storable in a "byte" (hard-coded)
 */
#define MAX_UCHAR       255

/*
 * Maximum value storable in a "s16b" (hard-coded)
 */
#define MAX_SHORT       32767

/*
 * Direction constants for aiming up or down
 */

#define DIRECTION_DOWN -1
#define DIRECTION_UP   -2

/*
 * Misc constants
 */
#define GATES_DAWN		10000	/* Number of turns from dawn to dawn XXX */
#define MON_MULT_ADJ	8		/* High value slows multiplication */


/*
 * There is a 1/10 (10%) chance of inflating the requested object_level
 * during the creation of an object (see "get_obj_num()" in "object.c").
 * Lower values yield better objects more often.
 */
#define GREAT_OBJ	10

/*
 * There is a 1/10 (10%) chance that special items with an inflated base-level are
 * generated when an object is turned into an special item (see make_ego_item()
 * in object2.c). As above, lower values yield better special items more often.
 */
#define GREAT_EGO	10


/*
 * Refueling constants
 */
#define FUEL_TORCH	3000	/* Maximum amount of fuel in a torch */
#define FUEL_LAMP	7000    /* Maximum amount of fuel in a lantern */


/*
 * More maximum values
 */
#define MAX_SIGHT	20	/* Maximum view distance */
#define MAX_RANGE	20	/* Maximum range (spells, etc) */



/*
 * There is a 1/160 chance per round of creating a new monster
 */
#define MAX_M_ALLOC_CHANCE	160



/*
 * A monster can only "multiply" (reproduce) if there are fewer than 100
 * monsters on the level capable of such spontaneous reproduction.  This
 * is a hack which prevents the "mon_list[]" array from exploding due to
 * reproducing monsters.  Messy, but necessary.
 */
#define MAX_REPRO	100


/*
 * Player constants
 */
#define PY_START_EXP	5000	/* Starting exp */
#define PY_MAX_EXP	99999999L	/* Maximum exp */
#define PY_MAX_LEVEL	50		/* Maximum level */

/*
 * Player "food" crucial values
 */
 
#define PY_FOOD_MAX		7000	/* Food value (Full) */
#define PY_FOOD_FULL	5000	/* Food value (Normal) */
#define PY_FOOD_ALERT	2000	/* Food value (Hungry) */
#define PY_FOOD_WEAK	1000	/* Food value (Weak) */
#define PY_FOOD_STARVE	   1 	/* Food value (Starving) */

/*
 * Player regeneration constants
 */
#define PY_REGEN_HP_PERIOD		150		/* Number of player turns for complete health regeneration */
#define PY_REGEN_SP_PERIOD		150		/* Number of player turns for complete voice regeneration */

/*
 * Monster regeneration constants
 */
#define MON_REGEN_HP_PERIOD		150		/* Number of speed 2 turns for complete health regeneration */
#define MON_REGEN_SP_PERIOD		10		/* Number of speed 2 turns for complete 'mana' regeneration */

/* 
 * Bonus to stealth in stealth mode
*/
#define STEALTH_MODE_BONUS  5

/*
 * Distance unwary monsters will wander in one stretch
 */
#define MON_WANDER_RANGE	50

/* 
 * Melee abilities 
 */
#define	MEL_POWER					 0
#define	MEL_FINESSE					 1
#define	MEL_THROWING				 2
#define	MEL_POLEARMS				 3
#define	MEL_CHARGE					 4
#define	MEL_FOLLOW_THROUGH			 5
#define	MEL_ZONE_OF_CONTROL			 6
#define	MEL_CONTROL					 7
#define	MEL_STUN					 8
#define	MEL_RAPID_ATTACK			 9
#define	MEL_TWO_WEAPON				10
#define	MEL_KNOCK_BACK				11
#define	MEL_WHIRLWIND_ATTACK		12
#define	MEL_STR						13

/* 
 * Archery abilities 
 */
#define	ARC_CAREFUL					 0
#define	ARC_IMPROVED_CRITICALS		 1
#define	ARC_POINT_BLANK				 2
#define	ARC_VERSATILITY				 3
#define	ARC_CRIPPLING				 4
#define	ARC_FLAMING					 5
#define	ARC_RAPID_FIRE				 6
#define	ARC_DEX						 7

/* 
 * Evasion abilities 
 */
#define	EVN_DODGING					 0
#define	EVN_BLOCKING				 1
#define	EVN_PARRY					 2
#define	EVN_CROWD_FIGHTING			 3
#define	EVN_SPRINTING				 4
#define	EVN_FLANKING				 5
#define	EVN_HEAVY_ARMOUR			 6
#define	EVN_RIPOSTE					 7
#define	EVN_CONTROLLED_RETREAT		 8
#define	EVN_DEX						 9

/* 
 * Stealth abilities 
 */
#define	STL_DISGUISE				 0
#define	STL_ASSASSINATION			 1
#define	STL_CRUEL_BLOW				 2
#define	STL_OPPORTUNIST				 3
#define	STL_EXCHANGE_PLACES			 4
#define	STL_VANISH					 5
#define	STL_DEX						 6

/* 
 * Perception abilities 
 */
#define	PER_EYE_FOR_DETAIL			 0
#define	PER_FOCUSED_ATTACK			 1
#define	PER_KEEN_SENSES				 2
#define	PER_LORE1					 3
#define	PER_CONCENTRATION			 4
#define	PER_BANE					 5
#define	PER_LORE2					 6
#define	PER_LISTEN					 7
#define	PER_MASTER_HUNTER			 8
#define	PER_GRA						 9

/* 
 * Will abilities 
 */
#define	WIL_CHANNELING				 0
#define	WIL_MIND_OVER_BODY			 1
#define	WIL_CURSE_BREAKING			 2
#define	WIL_INNER_LIGHT				 3
#define	WIL_CLARITY					 4
#define	WIL_HARDINESS				 5
#define	WIL_POISON_RESISTANCE		 6
#define	WIL_STRENGTH_IN_ADVERSITY	 7
#define	WIL_CRITICAL_RESISTANCE		 8
#define	WIL_MAJESTY					 9
#define	WIL_CON						10

/* 
 * Smithing abilities 
 */
#define	SMT_WEAPONSMITH				 0
#define	SMT_ARMOURSMITH				 1
#define	SMT_JEWELLER				 2
#define	SMT_ENCHANTMENT				 3
#define	SMT_FINE					 4
#define	SMT_ARTEFACT				 5
#define	SMT_MASTERPIECE				 6
#define	SMT_GRA						 7

/* 
 * Songs 
 */
#define	SNG_ELBERETH				 0
#define	SNG_SLAYING					 1
#define	SNG_SILENCE					 2
#define	SNG_FREEDOM					 3
#define	SNG_TREES					 4
#define	SNG_AULE					 5
#define	SNG_STAYING					 6
#define	SNG_LORIEN					 7
#define	SNG_ESTE					 8
#define	SNG_SHARPNESS				 9
#define	SNG_MASTERY					10
#define	SNG_VOICE					11
#define	SNG_WOVEN_THEMES			12
#define	SNG_GRA						13
#define	SNG_NOTHING				   100
#define	SNG_EXCHANGE_THEMES		   101

/*
 * Attack Types
 */

#define ATT_MAIN				0
#define ATT_FLANKING			1
#define ATT_CONTROLLED_RETREAT	2
#define ATT_ZONE_OF_CONTROL		3
#define ATT_OPPORTUNIST			4
#define ATT_POLEARM  			4
#define ATT_FOLLOW_THROUGH		5
#define ATT_RIPOSTE				6
#define ATT_WHIRLWIND			8
#define ATT_RAGE				9

/*
 * Maximum number of "normal" pack slots, and the index of the "overflow"
 * slot, which can hold an item, but only temporarily, since it causes the
 * pack to "overflow", dropping the "last" item onto the ground.  Since this
 * value is used as an actual slot, it must be less than "INVEN_WIELD" (below).
 * Note that "INVEN_PACK" is probably hard-coded by its use in savefiles, and
 * by the fact that the screen can only show 23 items plus a one-line prompt.
 */
#define INVEN_PACK		23

/*
 * Indexes used for various "equipment" slots (hard-coded by savefiles, etc).
 */
#define INVEN_WIELD		24
#define INVEN_BOW       25
#define INVEN_LEFT      26
#define INVEN_RIGHT     27
#define INVEN_NECK      28
#define INVEN_LITE      29
#define INVEN_BODY      30
#define INVEN_OUTER     31
#define INVEN_ARM       32
#define INVEN_HEAD      33
#define INVEN_HANDS     34
#define INVEN_FEET      35
#define INVEN_QUIVER1   36
#define INVEN_QUIVER2   37

/*
 * Total number of inventory slots (hard-coded).
 */
#define INVEN_TOTAL	38


/*
 * A "stack" of items is limited to less than 100 items (hard-coded).
 */
#define MAX_STACK_SIZE			100


/*
 * Maximum number of objects allowed in a single dungeon grid.
 *
 * The main-screen has a minimum size of 24 rows, so we can always
 * display 23 objects + 1 header line.
 */
#define MAX_FLOOR_STACK			23


/*
 * Indexes of the various "stats" (hard-coded by savefiles, etc).
 */
#define A_STR	0
#define A_DEX	1
#define A_CON	2
#define A_GRA	3

/*
 * Total number of stats.
 */
#define A_MAX	4

/*
 * The internal minimum and  maximum for a given stat.
 */
#define BASE_STAT_MIN -9
#define BASE_STAT_MAX 20

/*
 * Indexes of the various "skills" (hard-coded by savefiles, etc).
 */
#define S_MEL	0
#define S_ARC	1
#define S_EVN	2
#define S_STL	3
#define S_PER	4
#define S_WIL	5
#define S_SMT	6
#define S_SNG	7

/*
 * Total number of skills.
 */
#define S_MAX	8

/*
 * The internal maximum for a given skill (the minimum is 0).
 */
#define BASE_SKILL_MAX 100

/*
 * Total number of abilties per skill (not to be confused with A_MAX)
 */
 #define ABILITIES_MAX 20

/*** Screen Locations ***/

/*
 * Some screen locations for various display routines
 * Currently, row 8 and 15 are the only "blank" rows.
 * That leaves a "border" around the "stat" values.
 */

#define ROW_NAME		1
#define COL_NAME		0	/* <race name> */

#define ROW_STAT		3
#define COL_STAT		0	/* "xxx   xxxxxx" */

#define ROW_EXP			8
#define COL_EXP			0	/* "EXP xxxxxxxx" */

#define ROW_HP			10
#define COL_HP			0	/* "HP xxxxxxxxx" */

#define ROW_SP			11
#define COL_SP			0	/* "SP xxxxxxxxx" */

#define ROW_EQUIPPY		13
#define COL_EQUIPPY		0	/* equippy chars */

#define ROW_MEL			13
#define COL_MEL			0	/* "(+x, xdx)" */

#define ROW_ARC			14
#define COL_ARC			0	/* "(+x, xx)" */

#define ROW_EVN			15
#define COL_EVN			0	/* "[+x, x-x]" */

#define ROW_RESIST		17
#define COL_RESIST		0	/* "Resistances " */

#define ROW_INFO		17
#define COL_INFO		0	/* "  ****----  " monster health bar*/

#define ROW_CUT			20
#define COL_CUT			0	/* "Bleeding XX" */

#define ROW_POISONED	20
#define COL_POISONED	0	/* "Poisoned XX" */

#define ROW_SONG		21
#define COL_SONG		0	/* <song> */

#define ROW_STEALTH		24
#define COL_STEALTH		0	/* <stealth> */

#define ROW_HUNGRY		(Term->hgt - 1)
#define COL_HUNGRY		0	/* "Starving" "Weak" / "Hungry" / "Full" / "Gorged" */

#define ROW_BLIND		(Term->hgt - 1)
#define COL_BLIND		9	/* "Blind" */

#define ROW_CONFUSED	(Term->hgt - 1)
#define COL_CONFUSED	15	/* "Confused" */

#define ROW_STUN		(Term->hgt - 1)
#define COL_STUN		24	/* <stun> */

#define ROW_AFRAID		(Term->hgt - 1)
#define COL_AFRAID		36	/* "Afraid" */

#define ROW_STATE		(Term->hgt - 1)
#define COL_STATE		43	/* <state> */

#define ROW_SPEED		(Term->hgt - 1)
#define COL_SPEED		56	/* "Slow" or "Fast" */

#define ROW_DEPTH		(Term->hgt - 1)
#define COL_DEPTH		73	/* "Lev NNN" / "NNNN ft" */


/*** General index values ***/

/*used as values for the "object_generation_mode variable*/

#define OB_GEN_MODE_NORMAL		0
#define OB_GEN_MODE_CHEST		11
#define OB_GEN_MODE_RANDART		13

#define CHEST_LEVEL			130


/*
 * Legal restrictions for "summon_specific()"
 */
#define SUMMON_ANT	        11
#define SUMMON_SPIDER       12
#define SUMMON_HOUND        13
#define SUMMON_BIRD_BAT     14
#define SUMMON_AINU	        15
#define SUMMON_RAUKO        16
#define SUMMON_UNDEAD       17
#define SUMMON_DRAGON       18
/* xxx */
#define SUMMON_HI_DEMON     26
#define SUMMON_HI_UNDEAD    27
#define SUMMON_HI_DRAGON    28
/* xxx */
#define SUMMON_WRAITH       31
#define SUMMON_UNIQUE       32
#define SUMMON_HI_UNIQUE    33
#define SUMMON_KIN          34

#define SUMMON_ANIMAL      50
#define SUMMON_BERTBILLTOM 51
#define SUMMON_THIEF       53

#define SUMMON_INDEX       60


/*
 * Spell types used by project(), and related functions.
 *
 * p -> affects player using project_p()
 * m -> affects monsters using project_m()
 * o -> affects objects on the ground using project_o()
 * f -> affects features (terrain) using project_f()
 * * -> unused in Sil at the moment
 */

#define GF_NOTHING       0    // no gameplay effect, just visuals                               ( - - - - )
#define GF_HURT			 1    // damage reduced by armour, not used in the project functions    ( - - - - )
#define GF_ARROW         2    // need hit roll, damage (reduced by armour)                      ( p - - - )
#define GF_BOULDER       3    // need hit roll, damage (reduced by armour)                      ( p - - - )
#define GF_ACID          4    // does damage, wrecks objects/inv/equip                          ( p m o - )         
#define GF_ELEC          5    // does damage (reduced by special prot), wrecks objects/inv      ( p m o - ) *
#define GF_FIRE          6    // does damage (reduced by shield+special), wrecks objects/inv    ( p m o - )
#define GF_COLD          7    // does damage (reduced by shield+special), wrecks objects/inv    ( p m o - )
#define GF_POIS          8    // adds (XdY) to the poison counter, damages monsters directly    ( p m - - ) 
#define GF_DARK          9    // darkens squares, does damage (reduced by res / special prot)   ( p m - f )
#define GF_DARK_WEAK	10    // this type darkens squares, but does no damage                  ( - - - f )
#define GF_LIGHT        11    // lights up squares and stuns light-susceptible monsters (XdY)   ( - m - f )
#define GF_SOUND        12    // adds (XdY) to the stun counter and breaks cold vulnerable stuff( p m o - )
#define GF_EARTHQUAKE	13    // smashes cold vulnerable things -- real damage done elsewhere   ( - - o - )
#define GF_SLOW			14    // adds (skill_check+10) points to the slowing counter            ( - m - - )
#define GF_SPEED		15    // adds (XdY) points to the haste counter                         ( - m - - )
#define GF_CONFUSION	16    // adds (skill_check+10) points to the confusion counter          ( - m - - )
#define GF_SLEEP		17    // adds (skill_check+10) points to the sleep counter              ( - m - - )
#define GF_FEAR			18    // adds (skill_check+5-dist) points to the fear counter           ( - m - - )
#define GF_HEAL			19    // heals monsters by (XdY) health                                 ( - m - - ) *
#define GF_KILL_WALL	20    // destroys walls/rubble/doors and does (XdY) to stone creatures  ( - m - f )
#define GF_KILL_DOOR	21    // attempts to unlock or open doors or chests                     ( - - o f )
#define GF_KILL_TRAP	22    // destroys any traps on squares or on chests                     ( - - o f )
#define GF_LOCK_DOOR	23    // adds (skill_check/2) points to the lock level of a door        ( - - - f )
#define GF_AWAY_ALL		24    // teleports monsters (XdY) squares away                          ( - m - - ) *
#define GF_IDENTIFY		25    // identifies objects on the ground                               ( - - o - ) *


/*
 * Some constants for the "learn" code.  These generalized from the
 * old DRS constants.
 */
#define LRN_FREE_SAVE     14
#define LRN_MANA          15
#define LRN_ACID          16
#define LRN_ELEC          17
#define LRN_FIRE          18
#define LRN_COLD          19
#define LRN_POIS          20
#define LRN_FEAR_SAVE     21
#define LRN_LITE          22
#define LRN_DARK          23
#define LRN_BLIND         24
#define LRN_CONFU         25
#define LRN_SOUND         26
#define LRN_SHARD         27
#define LRN_NEXUS         28
#define LRN_NETHR         29
#define LRN_CHAOS         30
#define LRN_DISEN         31
#define LRN_SAVE          39
#define LRN_ARCH          40
#define LRN_PARCH         41
#define LRN_ICE           42
#define LRN_PLAS          43
#define LRN_SOUND2        44 /* attacks which aren't resisted, but res sound prevent stun */
#define LRN_STORM         45
#define LRN_WATER         46
#define LRN_NEXUS_SAVE    47 /* Both resist Nexus and Saves apply */
#define LRN_BLIND_SAVE    48 /* Both resist Blind and Saves apply */
#define LRN_CONFU_SAVE    49 /* Both resist Confusion and Saves apply */
#define LRN_DARKEN_ROOM   50
#define LRN_HOLY_SAVE     51

#define LRN_MAX           60



/*
 * Number of keymap modes
 */
#define KEYMAP_MODES	4

/*
 * Modes
 */
#define KEYMAP_MODE_SIL             0	// The original Sil keyset
#define KEYMAP_MODE_SIL_HJKL        1	// The original Sil keyset with hjkl movement
#define KEYMAP_MODE_ANGBAND         2	// The Angband-like keyset
#define KEYMAP_MODE_ANGBAND_HJKL    3	// The Angband-like keyset with hjkl movement


/*** Feature Indexes (see "lib/edit/feature.txt") ***/

/* Nothing */
#define FEAT_NONE		0x00

/* Various */
#define FEAT_FLOOR		0x01
#define FEAT_GLYPH		0x03
#define FEAT_OPEN		0x04
#define FEAT_BROKEN		0x05
#define FEAT_CLOSED 	0x20  /*door*/

/*stairs moved to make way for adventurers guild*/
#define FEAT_LESS		0x50
#define FEAT_MORE		0x51

#define FEAT_LESS_SHAFT	0x52
#define FEAT_MORE_SHAFT	0x53

/* Stair Head/Tail */
#define FEAT_STAIR_HEAD	0x50
#define FEAT_STAIR_TAIL	0x53

/* Traps */
#define FEAT_TRAP_HEAD       0x10
#define FEAT_TRAP_TAIL       0x1C

#define FEAT_TRAP_FALSE_FLOOR 0x10
#define FEAT_TRAP_PIT	      0x11
#define FEAT_TRAP_SPIKED_PIT  0x12
#define FEAT_TRAP_DART        0x13
#define FEAT_TRAP_GAS_CONF    0x14
#define FEAT_TRAP_GAS_MEMORY  0x15
#define FEAT_TRAP_ALARM	      0x16
#define FEAT_TRAP_FLASH	      0x17
#define FEAT_TRAP_CALTROPS    0x18
#define FEAT_TRAP_ROOST       0x19
#define FEAT_TRAP_WEB         0x1A
#define FEAT_TRAP_DEADFALL    0x1B
#define FEAT_TRAP_ACID        0x1C

/* Doors */
#define FEAT_DOOR_HEAD	0x20
#define FEAT_DOOR_TAIL	0x2F


/* Walls */
#define FEAT_WALL_HEAD	0x30
#define FEAT_WALL_TAIL	0x3F

/* Extra */
#define FEAT_SECRET		0x30
#define FEAT_RUBBLE		0x31

/* Walls */
#define FEAT_QUARTZ		0x33
#define FEAT_WALL_EXTRA	0x38
#define FEAT_WALL_INNER	0x39
#define FEAT_WALL_OUTER	0x3A
#define FEAT_WALL_SOLID	0x3B
#define FEAT_PERM_EXTRA	0x3C
#define FEAT_PERM_INNER	0x3D
#define FEAT_PERM_OUTER	0x3E
#define FEAT_PERM_SOLID	0x3F

// Forges
#define FEAT_FORGE		0x0F

#define FEAT_FORGE_HEAD				0x40
#define FEAT_FORGE_TAIL				0x4F
#define FEAT_FORGE_NORMAL_HEAD		0x40 /*  */
#define FEAT_FORGE_NORMAL_TAIL		0x45 /*  */
#define FEAT_FORGE_GOOD_HEAD		0x46 /*  */
#define FEAT_FORGE_GOOD_TAIL		0x4B /*  */
#define FEAT_FORGE_UNIQUE_HEAD		0x4C /*  */
#define FEAT_FORGE_UNIQUE_TAIL		0x4F /*  */

// Vaults
#define VAULT_FORGE1			 42
#define VAULT_FORGE2			 43
#define VAULT_FORGE3			 86
#define VAULT_FORGE4			 92
#define VAULT_FORGE5			 98
#define VAULT_FORGE6			102

#define MAX_GREATER_VAULTS		  8

/*** Important artefact indexes (see "lib/edit/artefact.txt") ***/

#define ART_MAEGLIN			25
#define ART_GLEND			52
#define ART_DELMERETH		57
#define ART_BOLDOG			60
#define ART_DRAUGLIN		98
#define ART_THURINGWETHIL	99

#define ART_MORGOTH_0		120
#define ART_MORGOTH_1		121
#define ART_MORGOTH_2		122
#define ART_MORGOTH_3		123
#define ART_GROND			124

#define ART_ULTIMATE		125


/*
 * Maximum length of artefact names
 */
#define MAX_LEN_ART_NAME 30

#define S_WORD 26
#define E_WORD S_WORD

/*themed drops*/
#define DROP_TYPE_UNTHEMED				0
#define DROP_TYPE_NOT_USELESS			1
#define DROP_TYPE_POTION				2
#define DROP_TYPE_STAFF					3
#define DROP_TYPE_SHIELD				4
#define DROP_TYPE_WEAPON				5
#define DROP_TYPE_ARMOR					6
#define DROP_TYPE_BOOTS					7
#define DROP_TYPE_BOW					8
#define DROP_TYPE_CLOAK					9
#define DROP_TYPE_GLOVES				10
#define DROP_TYPE_EDGED					11
#define DROP_TYPE_POLEARM				12
#define DROP_TYPE_HEADGEAR				13
#define DROP_TYPE_JEWELRY				14
#define DROP_TYPE_CHEST					15
#define DROP_TYPE_DIGGING				16


/*** Object "tval" and "sval" codes ***/


/*
 * The values for the "tval" field of various objects.
 *
 * This value is the primary means by which items are sorted in the
 * player inventory, followed by "sval" and "cost".
 *
 * Note that a "BOW" with tval = 19 and sval S = 10*N+P takes a missile
 * weapon with tval = 16+N, and does (xP) damage when so combined.  This
 * fact is not actually used in the source, but it kind of interesting.
 *
 * Note that as of 2.7.8, the "item flags" apply to all items, though
 * only armor and weapons and a few other items use any of these flags.
 */

#define TV_NOTE          2	/* ~ Tutorial notes                      */
#define TV_USELESS       3	/* ~ Skeletons, etc                      */
#define TV_METAL		 4	/* ~ Piece of mithril                    */
#define TV_CHEST         7	/* ~ Chests                              */
#define TV_ARROW        17	/* - Arrows								 */
#define TV_BOW          19	/* { Bows                                */
#define TV_DIGGING      20	/* \ Shovels/Picks                       */
#define TV_HAFTED       21	/* \ Blunt weapons                       */
#define TV_POLEARM      22	/* / Axes and Pikes                      */
#define TV_SWORD        23	/* | Edged Weapons                       */
#define TV_BOOTS        30	/* ] Boots                               */
#define TV_GLOVES       31	/* ] Gloves                              */
#define TV_HELM         32	/* ] Helms                               */
#define TV_CROWN        33	/* ] Crowns                              */
#define TV_SHIELD       34	/* ) Shields                             */
#define TV_CLOAK        35	/* ( Cloaks                              */
#define TV_SOFT_ARMOR   36	/* ( Soft Armor                          */
#define TV_MAIL			37	/* [ Mail                                */
#define TV_LIGHT        39	/* ~ Lights (including Specials)         */
#define TV_AMULET       40	/* " Amulets (including Specials)        */
#define TV_RING         45	/* = Rings (including Specials)          */
#define TV_STAFF        55	/* _ Staffs                              */
#define TV_TRUMPET      66  /* ? Trumpets                            */
#define TV_POTION       75  /* ! Potions                             */
#define TV_FLASK        77  /* ! Flasks of Oil                       */
#define TV_FOOD         80  /* , Food                                */
#define TV_EASTER       81  /* , Easter Eggs (replacement for herbs) */


/* The "sval" codes for TV_USELESS */
#define SV_USELESS_ORC_SKEL		0	/*  */
#define SV_USELESS_HUMAN_SKEL	1	/*  */
#define SV_USELESS_ELF_SKEL		2	/*  */

/* The "sval" codes for TV_METAL */
#define SV_METAL_MITHRIL		0	/*  */

/* The "sval" codes for TV_ARROW */
#define SV_NORMAL_ARROW		1	/*  */

/* The "sval" codes for TV_BOW (note information in "sval") */
#define SV_SHORT_BOW		12	/*  */
#define SV_LONG_BOW			13	/*  */
#define SV_DH_LONG_BOW		14	/*  */

/* The "sval" codes for TV_DIGGING */
#define SV_SHOVEL			1
#define SV_MATTOCK			7

/* The "sval" values for TV_HAFTED */
#define SV_QUARTERSTAFF			3	/* 2d4 */
#define SV_WAR_HAMMER			8	/* 3d2 */
#define SV_GROND				50	/* 5d5 */

/* The "sval" values for TV_POLEARM */
#define SV_SPEAR				1	/* 1d11 */
#define SV_GREAT_SPEAR			2	/* 1d14 */
#define SV_TRIDENT				3	/* 1d8 */
#define SV_GLAIVE				4	/* 2d8 */
#define SV_HALBERD				5	/* 2d10 */
#define SV_THROWING_AXE			11	/* 2d4 */
#define SV_BATTLE_AXE			12	/* 3d4 */
#define SV_GREAT_AXE			13	/* 4d4 */

/* The "sval" codes for TV_SWORD */

#define SV_BROKEN_SWORD				2	/* 1d4 */
#define SV_DAGGER					4	/* 1d4 */
#define SV_CURVED_SWORD				7	/* 2d5 */
#define SV_SHORT_SWORD				10	/* 1d8 */
#define SV_DEATHBLADE				15	/* 1d10 */
#define SV_LONG_SWORD				17	/* 2d5 */
#define SV_BASTARD_SWORD			21	/* 3d3 */
#define SV_GREAT_SWORD				25	/* 3d5 */
#define SV_MITHRIL_LONG_SWORD		28	/* 2d5 */
#define SV_MITHRIL_GREAT_SWORD		30	/* 3d5 */


/* The "sval" codes for TV_SHIELD */
#define SV_ROUND_SHIELD			 3
#define SV_KITE_SHIELD			 5
#define SV_MITHRIL_SHIELD		10

/* The "sval" codes for TV_HELM */
#define SV_HELM					5
#define SV_GREAT_HELM			6
#define SV_DWARF_MASK			7
#define SV_MITHRIL_HELM			8
#define SV_GOLDEN_CROWN			11
#define SV_JEWELED_CROWN		12
#define SV_MORGOTH				50

/* The "sval" codes for TV_BOOTS */
#define SV_PAIR_OF_LEATHER_BOOTS		1
#define SV_PAIR_OF_STEEL_GREAVES		2
#define SV_PAIR_OF_MITHRIL_GREAVES		3

/* The "sval" codes for TV_CLOAK */
#define SV_CLOAK					1
#define SV_SHADOW_CLOAK				6

#define SV_WOLF_HAME				20
#define SV_BAT_FELL					21

/* The "sval" codes for TV_GLOVES */
#define SV_SET_OF_LEATHER_GLOVES	1
#define SV_SET_OF_GAUNTLETS			2

/* The "sval" codes for TV_SOFT_ARMOR */
#define SV_FILTHY_RAG				1
#define SV_ROBE						2
#define SV_LEATHER_ARMOR			4
#define SV_STUDDED_LEATHER			7
#define SV_ARMOUR_OF_GALVORN		11

/* The "sval" codes for TV_MAIL */
#define SV_MAIL_CORSLET				4
#define SV_LONG_CORSLET				6
#define SV_MITHRIL_CORSLET			20

/* The sval codes for TV_LIGHT */
#define SV_LIGHT_TORCH			0
#define SV_LIGHT_LANTERN		1
#define SV_LIGHT_LESSER_JEWEL	2
#define SV_LIGHT_FEANORIAN		8
#define SV_LIGHT_SILMARIL		9

/* The "sval" codes for TV_AMULET */
#define SV_AMULET_ADORNMENT			0
#define SV_AMULET_CON				1
#define SV_AMULET_GRA				2
#define SV_AMULET_REGENERATION		3
#define SV_AMULET_PRESERVATION		4
#define SV_AMULET_BLESSED_REALM		5
#define SV_AMULET_DANGER			6

#define SV_AMULET_DWARVES			12
#define SV_AMULET_NIMPHELOS			13
#define SV_AMULET_ELESSAR			16
#define SV_AMULET_SELF_MADE			40


/* The sval codes for TV_RING */
#define SV_RING_PERCEPTION			0
#define SV_RING_SUSTENANCE			1
#define SV_RING_EVASION				2
#define SV_RING_PROTECTION			3
#define SV_RING_STR					4
#define SV_RING_DEX					5
#define SV_RING_FROST				6
#define SV_RING_WARMTH				7
#define SV_RING_ACCURACY			8
#define SV_RING_FREE_ACTION			9
#define SV_RING_DAMAGE				10
#define SV_RING_TRUE_SIGHT			11
#define SV_RING_VENOM				12
#define SV_RING_HUNGER				21
#define SV_RING_ATTENTION			22

#define SV_RING_BARAHIR			32
#define SV_RING_SELF_MADE		40


/* The "sval" codes for TV_STAFF */
#define SV_STAFF_SECRETS		0
#define SV_STAFF_IMPRISONMENT	1
#define SV_STAFF_FREEDOM		2
#define SV_STAFF_LIGHT			3
#define SV_STAFF_SANCTITY		5
#define SV_STAFF_UNDERSTANDING	6
#define SV_STAFF_REVELATIONS	7
#define SV_STAFF_TREASURES		8
#define SV_STAFF_FOES			9
#define SV_STAFF_SLUMBER		10
#define SV_STAFF_MAJESTY		11
#define SV_STAFF_SELF_KNOWLEDGE	12
#define SV_STAFF_WARDING		13
#define SV_STAFF_EARTHQUAKES	14
#define SV_STAFF_RECHARGING		16
#define SV_STAFF_SUMMONING		17
#define SV_STAFF_ENTRAPMENT		18


/* The "sval" codes for TV_TRUMPET */
#define SV_TRUMPET_TERROR   		0
#define SV_TRUMPET_THUNDER		    1
#define SV_TRUMPET_BLASTING			2
#define SV_TRUMPET_WARNING			3


/* The "sval" codes for TV_POTION */
#define SV_POTION_MIRUVOR			0
#define SV_POTION_ORCISH_LIQUOR		2
#define SV_POTION_CLARITY			4
#define SV_POTION_HEALING			5
#define SV_POTION_VOICE				6
#define SV_POTION_TRUE_SIGHT		7
#define SV_POTION_SLOW_POISON		8
#define SV_POTION_QUICKNESS			9
#define SV_POTION_ELEM_RESISTANCE	10
#define SV_POTION_STR				14
#define SV_POTION_DEX				15
#define SV_POTION_CON				16
#define SV_POTION_GRA				17
#define SV_POTION_SLOWNESS			22
#define SV_POTION_POISON			23
#define SV_POTION_BLINDNESS			24
#define SV_POTION_CONFUSION			25
#define SV_POTION_DEC_DEX			27
#define SV_POTION_DEC_GRA			29


/* The "sval" codes for TV_FOOD */
#define SV_FOOD_RAGE			0
#define SV_FOOD_SUSTENANCE		1
#define SV_FOOD_TERROR			2
#define SV_FOOD_HEALING			3
#define SV_FOOD_RESTORATION		4
#define SV_FOOD_HUNGER			5
#define SV_FOOD_VISIONS			6
#define SV_FOOD_PARALYSIS		7
#define SV_FOOD_WEAKNESS		8
#define SV_FOOD_SICKNESS		9

#define SV_FOOD_BREAD			35
#define SV_FOOD_MEAT			36
#define SV_FOOD_LEMBAS			37


/*
 * Special "sval" limit -- first "normal" food
 */
#define SV_FOOD_MIN_FOOD	32

/*
 * Special "sval" limit -- first "large" chest
 */
#define SV_CHEST_MIN_SMALL	1

/*
 * Special "sval" limit -- first "large" chest
 */
#define SV_CHEST_MIN_LARGE	10

/*
 * Special "sval" for different chests
 */
#define SV_CHEST_SMALL_WOODEN	 1
#define SV_CHEST_SMALL_STEEL	 2
#define SV_CHEST_SMALL_JEWELLED	 3
#define SV_CHEST_LARGE_WOODEN	11
#define SV_CHEST_LARGE_STEEL	12
#define SV_CHEST_LARGE_JEWELLED	13

#define SV_CHEST_PRESENT         4


/*Squelch Modes for k_info->squelch*/

#define SQUELCH_NEVER   			0 /*allow pickup, but defer to OPT_always_pickup*/
#define NO_SQUELCH_NEVER_PICKUP		1 /*never pickup, override OPT_always_pickup*/
#define NO_SQUELCH_ALWAYS_PICKUP 	2/*always pickup, override pickup and floor query options*/
#define SQUELCH_ALWAYS  			3 /*destroy when player walks over*/
#define SQUELCH_HEAD				0
#define SQUELCH_TAIL				3


/*
 * These are the various levels of quality squelching supported by the game.
 * Less concisely:
 * 0 ---> No squelching
 * 1 ---> Squelch cursed items
 * 2 ---> Squelch average and worse items
 * 3 ---> Squelch good and worse items
 * 4 ---> squelch all but artefacts
 * 5 ---> squelch open chests
 */

#define SQUELCH_NONE     		0
#define SQUELCH_CURSED   		1
#define SQUELCH_AVERAGE  		2
#define SQUELCH_GOOD_STRONG     3
#define SQUELCH_GOOD_WEAK		4
#define SQUELCH_ALL      		5
#define SQUELCH_OPENED_CHESTS	6 /*chests*/

/*others are defines in squelch.c, static int do_qual_squelch,
 *but this one is used in chest opening. JG*/
#define CHEST_INDEX 	20

/*number of bytes used in squelch sub-quality array*/
#define SQUELCH_BYTES    24


/*
 * Special "sval" value -- unknown "sval"
 */
#define SV_UNKNOWN			255



/*** Function flags ***/

#define PROJECT_NO          0
#define PROJECT_NOT_CLEAR   1
#define PROJECT_CLEAR       2


/*
 * Bit flags for the "project()", the "projectable()", and/or the
 * "project_path()" functions.
 *
 *   BEAM:  Work as a beam weapon (affect every grid passed through)
 *   ARC:   Act as an arc spell (a portion of a caster-centered ball)
 *   STAR:  Act as a starburst - a randomized ball
 *   BOOM:  Explode in some way
 *   WALL:  Affect one layer of any wall, even if not passable
 *   PASS:  Ignore walls entirely
 *   GRID:  Affect each grid in the "blast area" in some way
 *   ITEM:  Affect each object in the "blast area" in some way
 *   KILL:  Affect each monster in the "blast area" in some way
 *   PLAY:  Explicitly affect the player
 *   SAFE:  Hack -- do not affect monsters of caster's type
 *   HIDE:  Hack -- disable graphical effects of projection
 *   STOP:  Stop as soon as we hit a monster
 *   JUMP:  Jump directly to the target location
 *   THRU:  Continue "through" the target (used for projectiles)
 *   CHCK:  Note occupied grids, but do not stop at them
 *   ORTH:  Projection cannot move diagonally (used for wall spells)
 */

/* Projection types */
#define PROJECT_BEAM         0x00000001
#define PROJECT_ARC          0x00000002
#define PROJECT_STAR         0x00000004
#define PROJECT_XXX1         0x00000008
#define PROJECT_XXX2         0x00000010
#define PROJECT_XXX3         0x00000020

/* What projections do */
#define PROJECT_BOOM         0x00000040
#define PROJECT_WALL         0x00000080
#define PROJECT_PASS         0x00000100  /*Ignore walls*/
#define PROJECT_INVISIPASS   0x00000200  /*Ignores invisible walls*/
#define PROJECT_XXX5         0x00000400

/* What projections affect */
#define PROJECT_GRID         0x00000800
#define PROJECT_ITEM         0x00001000
#define PROJECT_KILL         0x00002000
#define PROJECT_PLAY         0x00004000
#define PROJECT_SAFE         0x00008000 /*(unused)*/
#define PROJECT_XXX6         0x00010000
#define PROJECT_XXX7         0x00020000

/* Graphics */
#define PROJECT_HIDE         0x00040000
#define PROJECT_NO_REDRAW    0x00080000
#define PROJECT_XXX9         0x00100000

/* How projections travel */
#define PROJECT_STOP         0x00200000
#define PROJECT_JUMP         0x00400000
#define PROJECT_THRU         0x00800000
#define PROJECT_CHCK         0x01000000
#define PROJECT_ORTH         0x02000000 /*(unused)*/
#define PROJECT_XX10         0x04000000

/*
 * An arc with a width (in degrees) less than this value will lose less
 * power over distance.
 */
#define ARC_STANDARD_WIDTH     90


/*
 * Bit flags for the "enchant()" function
 */
#define ENCH_TOHIT   0x01
#define ENCH_TODAM   0x02
#define ENCH_TOAC    0x04


/*
 * Bit flags for the "target_set" function
 *
 *	KILL: Target monsters
 *	LOOK: Describe grid fully
 *	XTRA: Currently unused flag
 *	GRID: Select from all grids
 */
#define TARGET_KILL		0x01
#define TARGET_LOOK		0x02
#define TARGET_XTRA		0x04
#define TARGET_GRID		0x08
#define TARGET_WIZ		0x10


/*
 * Bit flags for the "monster_desc" function
 */
#define MDESC_OBJE		0x01	/* Objective (or Reflexive) */
#define MDESC_POSS		0x02	/* Possessive (or Reflexive) */
#define MDESC_IND1		0x04	/* Indefinites for hidden monsters */
#define MDESC_IND2		0x08	/* Indefinites for visible monsters */
#define MDESC_PRO1		0x10	/* Pronominalize hidden monsters */
#define MDESC_PRO2		0x20	/* Pronominalize visible monsters */
#define MDESC_HIDE		0x40	/* Assume the monster is hidden */
#define MDESC_SHOW		0x80	/* Assume the monster is visible */


/*
 * Bit flags for the "get_item" function
 */
#define USE_EQUIP		0x01	/* Allow equip items */
#define USE_INVEN		0x02	/* Allow inven items */
#define USE_FLOOR		0x04	/* Allow floor items */



/*** Player flags ***/


/*
 * Bit flags for the "p_ptr->notice" variable
 */
#define PN_COMBINE		0x00000001L	/* Combine the pack */
#define PN_REORDER		0x00000002L	/* Reorder the pack */
#define PN_AUTOINSCRIBE	0x00000004L	/* Autoinscribe items */
/* xxx (many) */


/*
 * Bit flags for the "p_ptr->update" variable
 */
#define PU_BONUS		0x00000001L	/* Calculate bonuses */
/* xxx (many) */
#define PU_HP			0x00000010L	/* Calculate chp and mhp */
#define PU_MANA			0x00000020L	/* Calculate csp and msp */
/* xxx (many) */
#define PU_FORGET_VIEW	0x00010000L	/* Forget field of view */
#define PU_UPDATE_VIEW	0x00020000L	/* Update field of view */
#define PU_NOISE_STRONG	0x00040000L	/* Update flow through doors */
#define PU_NOISE_WEAK	0x00080000L	/* Update flow up to doors */
#define PU_MONSTERS		0x10000000L	/* Update monsters */
#define PU_DISTANCE		0x20000000L	/* Update distances */
/* xxx */
#define PU_PANEL		0x80000000L	/* Update panel */


/*
 * Bit flags for the "p_ptr->redraw" variable
 */
#define PR_MISC			0x00000001L	/* Display Name */
#define PR_MEL			0x00000002L	/* Display Weapon stats */
#define PR_ARC			0x00000004L	/* Display Bow stats */
#define PR_EXP			0x00000008L	/* Display Experience */
#define PR_STATS		0x00000010L	/* Display Stats */
#define PR_ARMOR		0x00000020L	/* Display Armor stats */
#define PR_HP			0x00000040L	/* Display Health */
#define PR_VOICE		0x00000080L	/* Display Voice */
#define PR_SONG			0x00000100L	/* Display Song */
#define PR_DEPTH		0x00000200L	/* Display Depth */
#define PR_EQUIPPY		0x00000400L	/* Display Equippy chars */
#define PR_HEALTHBAR	0x00000800L	/* Display Monster Health Bar */
#define PR_CUT			0x00001000L	/* Display Extra (Cut) */
#define PR_STUN			0x00002000L	/* Display Extra (Stun) */
#define PR_HUNGER		0x00004000L	/* Display Extra (Hunger) */
#define PR_XXX2			0x00008000L	/* Previously: Display Monster Mana Bar */
#define PR_BLIND		0x00010000L	/* Display Extra (Blind) */
#define PR_CONFUSED		0x00020000L	/* Display Extra (Confused) */
#define PR_AFRAID		0x00040000L	/* Display Extra (Afraid) */
#define PR_POISONED		0x00080000L	/* Display Extra (Poisoned) */
#define PR_STATE		0x00100000L	/* Display Extra (State) */
#define PR_SPEED		0x00200000L	/* Display Extra (Speed) */
/* xxx */
#define PR_RESIST		0X00800000L	/* Display Resistances */
#define PR_EXTRA		0x01000000L	/* Display Extra Info */
#define PR_BASIC		0x02000000L	/* Display Basic Info */
/* xxx */
#define PR_MAP			0x08000000L	/* Display Map */
/* xxx (many) */

/*
 * Bit flags for the "p_ptr->window" variable (etc)
 */
#define PW_INVEN            0x00000001L /* Display inven/equip */
#define PW_EQUIP            0x00000002L /* Display equip/inven */
#define PW_PLAYER_0         0x00000004L /* Display player (basic) */
/* xxx */
#define PW_COMBAT_ROLLS     0x00000010L /* Display combat rolls */
#define PW_MONSTER          0x00000020L /* Display monster recall */
#define PW_OBJECT           0x00000040L /* Display object recall */
#define PW_MESSAGE          0x00000080L /* Display messages */
#define PW_OVERHEAD         0x00000100L /* Display overhead view */
#define PW_MONLIST          0x00000200L /* Display monster list */



/*** Cave flags ***/

/*
 * Special cave grid flags
 */
#define CAVE_MARK		0x0001 	/* memorized feature */
#define CAVE_GLOW		0x0002 	/* self-illuminating */
#define CAVE_ICKY		0x0004 	/* part of a special room */
#define CAVE_ROOM		0x0008 	/* part of a room */
#define CAVE_G_VAULT    0x0010  /* part of a greater vault */
#define CAVE_HIDDEN		0x0020 	/* a trap that looks like the normal floor */
#define CAVE_TEMP		0x0040 	/* temporary flag (hard-coded position) */
#define CAVE_WALL		0x0080 	/* wall flag */
#define CAVE_FIRE       0x0100  /* is in line of fire */
#define CAVE_SEEN     	0x0200  /* seen flag */
#define CAVE_VIEW       0x0400  /* view flag */
#define CAVE_OLD_VIEW   0x0800  /* was square in view last update? */
#define CAVE_OLD_LIT    0x1000  /* was square lit last update? */
#define CAVE_OLD_TORCH  0x2000  /* was square in torch radius last update? */
#define CAVE_ATT2       0x4000  /* unused */
#define CAVE_ATT3       0x8000  /* unused */



/*** Object flags ***/


/*
 * Chest trap flags (see "tables.c")
 */
 
#define CHEST_GAS_CONF         0x01
#define CHEST_GAS_STUN         0x02
#define CHEST_GAS_POISON       0x04
#define CHEST_NEEDLE_HALLU     0x08
#define CHEST_NEEDLE_PARALYZE  0x10
#define CHEST_NEEDLE_LOSE_STR  0x20
#define CHEST_FLAME            0x40
 

/*
 * Special object flags
 */
#define IDENT_SENSE     		0x00000001	/* Item has been "sensed" */
#define IDENT_FIXED     		0x00000002	/* Item has been "haggled" */
#define IDENT_EMPTY     		0x00000004	/* Item charges are known */
#define IDENT_KNOWN     		0x00000008	/* Item abilities are known */
#define IDENT_SPOIL				0x00000010	/* Item is being listed in the object knowledge */
#define IDENT_UNUSED_XXXXXX2X   0x00000020	/* Unused */
#define IDENT_CURSED    		0x00000040	/* Item is temporarily cursed */
#define IDENT_BROKEN    		0x00000080	/* Item is permanently worthless */
#define IDENT_UNUSED_XXXXX1XX   0x00000100	/* Unused */
#define IDENT_UNUSED_XXXXX2XX   0x00000200	/* Unused */
#define IDENT_HIDE_CARRY		0x00000400	/* Don't reveal the object is being carried by a creature*/
#define IDENT_UNUSED_XXXXX8XX   0x00000800	/* Unused */
#define IDENT_UNUSED_XXXX1XXX   0x00001000	/* Unused */
#define IDENT_UNUSED_XXXX2XXX   0x00002000	/* Unused */
#define IDENT_UNUSED_XXXX4XXX   0x00004000	/* Unused */
#define IDENT_UNUSED_XXXX8XXX   0x00008000	/* Unused */
#define IDENT_UNUSED_XXX1XXXX   0x00010000	/* Unused */
#define IDENT_UNUSED_XXX2XXXX   0x00020000	/* Unused */
#define IDENT_UNUSED_XXX4XXXX   0x00040000	/* Unused */
#define IDENT_UNUSED_XXX8XXXX   0x00080000	/* Unused */
#define IDENT_UNUSED_XX1XXXXX   0x00100000	/* Unused */
#define IDENT_UNUSED_XX2XXXXX   0x00200000	/* Unused */
#define IDENT_UNUSED_XX4XXXXX   0x00400000	/* Unused */
#define IDENT_UNUSED_XX8XXXXX   0x00800000	/* Unused */
#define IDENT_UNUSED_X1XXXXXX   0x01000000	/* Unused */
#define IDENT_UNUSED_X2XXXXXX   0x02000000	/* Unused */
#define IDENT_UNUSED_X4XXXXXX   0x04000000	/* Unused */
#define IDENT_UNUSED_X8XXXXXX   0x08000000	/* Unused */
#define IDENT_UNUSED_1XXXXXXX   0x10000000	/* Unused */
#define IDENT_UNUSED_2XXXXXXX   0x20000000	/* Unused */
#define IDENT_UNUSED_4XXXXXXX   0x40000000	/* Unused */
#define IDENT_UNUSED_8XXXXXXX   0x80000000	/* Unused */


/*
 * The special inscriptions.
 */
#define INSCRIP_NULL            100
#define INSCRIP_TERRIBLE        100+1
#define INSCRIP_WORTHLESS       100+2
#define INSCRIP_CURSED          100+3
#define INSCRIP_BROKEN          100+4
#define INSCRIP_AVERAGE         100+5
#define INSCRIP_GOOD_STRONG     100+6
#define INSCRIP_GOOD_WEAK		100+7
#define INSCRIP_EXCELLENT       100+8
#define INSCRIP_SPECIAL         100+9
#define INSCRIP_UNCURSED        100+10
#define INSCRIP_INDESTRUCTIBLE  100+11

/*
 * Number of special inscriptions, plus one.
 */
#define MAX_INSCRIP			12


/*
 * Some bit-flags for the "smart" field".
 *
 * Most of these map to the "TR2_xxx" flags.
 */
#define SM_OPP_ACID		0x00000001
#define SM_OPP_ELEC		0x00000002
#define SM_OPP_FIRE		0x00000004
#define SM_OPP_COLD		0x00000008
#define SM_OPP_POIS		0x00000010
#define SM_OPP_XXX1		0x00000020
#define SM_OPP_XXX2		0x00000040
#define SM_GOOD_SAVE	0x00000080
#define SM_PERF_SAVE	0x00000100
#define SM_IMM_FREE		0x00000200
#define SM_IMM_MANA		0x00000400
#define SM_IMM_XXX1		0x00000800
#define SM_IMM_XXX2		0x00001000
#define SM_IMM_XXX3		0x00002000
#define SM_IMM_XXX4		0x00004000
#define SM_IMM_XXX5		0x00008000
#define SM_RES_XXX1		0x00010000
#define SM_RES_ELEC		0x00020000
#define SM_RES_FIRE		0x00040000
#define SM_RES_COLD		0x00080000
#define SM_RES_POIS		0x00100000
#define SM_RES_FEAR		0x00200000
#define SM_RES_XXX2		0x00400000
#define SM_RES_DARK		0x00800000
#define SM_RES_BLIND	0x01000000
#define SM_RES_CONFU	0x02000000
#define SM_RES_STUN 	0x04000000
#define SM_RES_XXX3		0x08000000
#define SM_RES_XXX4		0x10000000
#define SM_RES_XXX5		0x20000000
#define SM_RES_XXX6		0x40000000
#define SM_RES_XXX7		0x80000000


/*
 * As of 2.7.8, the "object flags" are valid for all objects, and as
 * of 2.7.9, these flags are not actually stored with the object, but
 * rather in the object_kind, ego_item, and artefact structures.
 *
 * Note that "flags1" contains all flags dependant on "pval" (including
 * stat bonuses, but NOT stat sustainers), plus all "extra attack damage"
 * flags (SLAY_XXX and BRAND_XXX).
 *
 * Note that "flags2" contains all "resistances" (including "sustain" flags,
 * immunity flags, and resistance flags).  Note that "free action" and "hold
 * life" are no longer considered to be "immunities".
 *
 * Note that "flags3" contains everything else (including eight good flags,
 * seven unused flags, four bad flags, four damage ignoring flags, six weird
 * flags, and three cursed flags).

 * Kills need to come right after slays for the randart code to work right
 */

#define TR1_STR             0x00000001L /* STR += "pval" */
#define TR1_DEX             0x00000002L /* DEX += "pval" */
#define TR1_CON             0x00000004L /* CON += "pval" */
#define TR1_GRA             0x00000008L /* GRA += "pval" */
#define TR1_NEG_STR         0x00000010L /* STR -= "pval" */
#define TR1_NEG_DEX         0x00000020L /* DEX -= "pval" */
#define TR1_NEG_CON         0x00000040L /* CON -= "pval" */
#define TR1_NEG_GRA         0x00000080L /* GRA -= "pval" */
#define TR1_MEL             0x00000100L /* MEL += "pval" */
#define TR1_ARC             0x00000200L /* ARC += "pval" */
#define TR1_STL		        0x00000400L /* STL += "pval" */
#define TR1_PER             0x00000800L /* PER += "pval" */
#define TR1_WIL             0x00001000L /* WIL += "pval" */
#define TR1_SMT             0x00002000L /* SMT += "pval" */
#define TR1_SNG             0x00004000L /* SNG += "pval" */
#define TR1_DAMAGE_DICE     0x00008000L /* damage dice += "pval" */
#define TR1_DAMAGE_SIDES	0x00010000L /* damage sides += "pval" */
#define TR1_TUNNEL          0x00020000L /* Tunnel += "pval" */
#define TR1_SHARPNESS       0x00040000L /* Weapon ignores half of protection */
#define TR1_SHARPNESS2      0x00080000L /* Weapon ignores all protection */
#define TR1_VAMPIRIC        0x00100000L /* Weapon drains life */
#define TR1_SLAY_ORC        0x00200000L /* Weapon slays orcs */
#define TR1_SLAY_TROLL      0x00400000L /* Weapon slays trolls */
#define TR1_SLAY_WOLF       0x00800000L /* Weapon slays wolves */
#define TR1_SLAY_SPIDER     0x01000000L /* Weapon slays spiders */
#define TR1_SLAY_UNDEAD     0x02000000L /* Weapon slays undead */
#define TR1_SLAY_RAUKO      0x04000000L /* Weapon slays raukar */
#define TR1_SLAY_DRAGON     0x08000000L /* Weapon slays dragon */
#define TR1_BRAND_COLD      0x10000000L /* Weapon has cold brand */
#define TR1_BRAND_FIRE      0x20000000L /* Weapon has fire brand */
#define TR1_BRAND_ELEC      0x40000000L /* Weapon has elec brand */
#define TR1_BRAND_POIS      0x80000000L /* Weapon has poison brand */


/*TR1 Uber-Flags*/
#define TR1_ALL_STATS	(TR1_STR | TR1_DEX | TR1_CON | TR1_GRA)



#define TR2_SUST_STR        0x00000001L /* Sustain STR */
#define TR2_SUST_DEX        0x00000002L /* Sustain DEX */
#define TR2_SUST_CON        0x00000004L /* Sustain CON */
#define TR2_SUST_GRA        0x00000008L /* Sustain GRA */
#define TR2_RES_COLD        0x00000010L /* Resist cold */
#define TR2_RES_FIRE        0x00000020L /* Resist fire */
#define TR2_RES_ELEC        0x00000040L /* Resist elec */
#define TR2_RES_POIS        0x00000080L /* Resist poison */
#define TR2_RES_DARK        0x00000100L /* Resist dark */
#define TR2_RES_FEAR        0x00000200L /* Resist fear */
#define TR2_RES_BLIND       0x00000400L /* Resist blind */
#define TR2_RES_CONFU       0x00000800L /* Resist confusion */
#define TR2_RES_STUN        0x00001000L /* Resist stunning */
#define TR2_RES_HALLU       0x00002000L /* Resist hallucination */
#define TR2_RADIANCE        0x00004000L /* Arrows trail light */
#define TR2_SLOW_DIGEST     0x00008000L /* Slow digest */
#define TR2_LIGHT           0x00010000L /* Sheds light */
#define TR2_REGEN           0x00020000L /* Regeneration */
#define TR2_SEE_INVIS       0x00040000L /* See Invis */
#define TR2_FREE_ACT        0x00080000L /* Free action */
#define TR2_TELEPATHY       0x00100000L /* Telepathy */
#define TR2_SPEED           0x00200000L /* Speed += 1 */
#define TR2_LIFE_SAVING     0x00400000L /* Saves your life */
#define TR2_HUNGER          0x00800000L /* Hunger */
#define TR2_DARKNESS        0x01000000L /* Darkness */
#define TR2_SLOWNESS        0x02000000L /* Slowness */
#define TR2_DANGER          0x04000000L	/* Danger (+1 level monster generation) */
#define TR2_AGGRAVATE       0x08000000L /* Enrage monsters */
#define TR2_TR2XXX16        0x10000000L /* (reserved) */
#define TR2_TR2XXX17        0x20000000L /* (reserved) */
#define TR2_TR2XXX18        0x40000000L /* (reserved) */
#define TR2_TR2XXX19        0x80000000L /* (reserved) */

/*TR2 Uber-Flags*/
#define TR2_SUST_STATS	(TR2_SUST_STR | TR2_SUST_DEX | TR2_SUST_CON | TR2_SUST_GRA)
#define TR2_RESISTANCE  (TR2_RES_COLD | TR2_RES_FIRE | TR2_RES_ELEC)


#define TR3_TR3XXX1         0x00000001L /* xxx */
#define TR3_TR3XXX2         0x00000002L /* xxx */
#define TR3_TR3XXX3         0x00000004L /* xxx */
#define TR3_TR3XXX4         0x00000008L /* xxx */
#define TR3_DETECT_ORC      0x00000010L /* Detects Orcs */
#define TR3_TR3XXX13        0x00000020L /* xxx */
#define TR3_TR3XXX5         0x00000040L /* xxx */
#define TR3_TR3XXX6			0x00000080L	/* xxx */
#define TR3_TR3XXX7         0x00000100L /* xxx */
#define TR3_TR3XXX8			0x00000200L	/* xxx */
#define TR3_TR3XXX9         0x00000400L /* xxx */
#define TR3_INDESTRUCTIBLE	0x00000800L	/* Item cannot be destroyed by earthquakes etc */
#define TR3_NO_SMITHING     0x00001000L /* Item cannot be made with smithing */
#define TR3_MITHRIL			0x00002000L	/* Item made out of mithril */
#define TR3_AXE				0x00004000L /* Item counts as an axe */
#define TR3_POLEARM			0x00008000L	/* Item counts as a polearm */
#define TR3_IGNORE_ACID     0x00010000L /* Item ignores Acid Damage */
#define TR3_IGNORE_ELEC     0x00020000L /* Item ignores Elec Damage */
#define TR3_IGNORE_FIRE     0x00040000L /* Item ignores Fire Damage */
#define TR3_IGNORE_COLD     0x00080000L /* Item ignores Cold Damage */
#define TR3_THROWING        0x00100000L /* Made for throwing (doesn't get -5 to hit) */
#define TR3_TR3XXX10	    0x00200000L /* xxx  */
#define TR3_ACTIVATE        0x00400000L /* Item can be activated */
#define TR3_INSTA_ART       0x00800000L /* Item makes an artefact */
#define TR3_EASY_KNOW       0x01000000L /* Item is known if aware */
#define TR3_TR3XXX11        0x02000000L /* xxx */
#define TR3_TR3XXX12        0x04000000L /* xxx */
#define TR3_HAND_AND_A_HALF 0x08000000L /* Item is a hand and a half weapon */
#define TR3_TWO_HANDED      0x10000000L /* Item is a two handed weapon */
#define TR3_LIGHT_CURSE     0x20000000L /* Item has Light Curse */
#define TR3_HEAVY_CURSE     0x40000000L /* Item has Heavy Curse */
#define TR3_PERMA_CURSE     0x80000000L /* Item has Perma Curse */

/*TR3 Uber-Flags*/
#define TR3_IGNORE_ALL (TR3_IGNORE_ACID | TR3_IGNORE_ELEC | TR3_IGNORE_FIRE | TR3_IGNORE_COLD)



/*
 * Hack -- flag set 1 -- mask for "pval-dependant" flags.
 * Note that all "pval" dependant flags must be in "flags1".
 */
#define TR1_PVAL_MASK \
	(TR1_STR | TR1_DEX | TR1_CON | TR1_GRA | \
	 TR1_NEG_STR | TR1_NEG_DEX | TR1_NEG_CON | TR1_NEG_GRA | \
	 TR1_DAMAGE_DICE | TR1_DAMAGE_SIDES | \
	 TR1_MEL | TR1_ARC | TR1_STL | \
	 TR1_PER | TR1_WIL | \
	 TR1_SMT | TR1_SNG | TR1_TUNNEL)

/*
 * Flag set 3 -- mask for "ignore element" flags.
 */
#define TR3_IGNORE_MASK \
	(TR3_IGNORE_ACID | TR3_IGNORE_ELEC | TR3_IGNORE_FIRE | \
	 TR3_IGNORE_COLD )

/*
 * Stat sustain flags
 */
#define TR1_STAT_MOD_MASK \
	(0L)

#define TR2_STAT_MOD_MASK \
	(TR2_SUST_STR | TR2_SUST_DEX | TR2_SUST_CON | TR2_SUST_GRA)

#define TR3_STAT_MOD_MASK \
	(0L)

/*
 * Stat add flags
 */
#define TR1_STAT_SUST_MASK \
	(TR1_STR | TR1_DEX | TR1_CON | TR1_GRA | TR1_NEG_STR | TR1_NEG_DEX | TR1_NEG_CON | TR1_NEG_GRA )

#define TR2_STAT_SUST_MASK \
	(0L)

#define TR3_STAT_SUST_MASK \
	(0L)

/*
 * Low Resist flags
 */
#define TR1_LOW_RESIST_MASK \
	(0L)

#define TR2_LOW_RESIST_MASK \
	(TR2_RES_ELEC | TR2_RES_FIRE | TR2_RES_COLD | TR2_RES_DARK | TR2_RES_POIS)

#define TR3_LOW_RESIST_MASK \
	(0L)

/*
 * High Resist flags
 */
#define TR1_HIGH_RESIST_MASK \
	(0L)

#define TR2_HIGH_RESIST_MASK \
	(TR2_RES_FEAR| TR2_RES_BLIND | TR2_RES_CONFU | TR2_RES_STUN)

#define TR3_HIGH_RESIST_MASK \
	(0L)

/*
 * All Resist flags
 */
#define TR1_RESISTANCES_MASK \
	(TR1_LOW_RESIST_MASK | TR1_HIGH_RESIST_MASK)

#define TR2_RESISTANCES_MASK \
	(TR2_LOW_RESIST_MASK | TR2_HIGH_RESIST_MASK)

#define TR3_RESISTANCES_MASK \
	(TR3_LOW_RESIST_MASK | TR3_HIGH_RESIST_MASK)

/*low level abilities*/

#define TR1_LOW_ABILITIES_MASK \
	(0L)

#define TR2_LOW_ABILITIES_MASK \
	(TR2_SLOW_DIGEST | TR2_LIGHT)

#define TR3_LOW_ABILITIES_MASK \
	(0L)

/*high level abilities*/

#define TR1_HIGH_ABILITIES_MASK \
	(0L)

#define TR2_HIGH_ABILITIES_MASK \
	(TR2_REGEN | TR2_SEE_INVIS | TR2_FREE_ACT | TR2_TELEPATHY)

#define TR3_HIGH_ABILITIES_MASK \
	(0L)


/*all abilities*/

#define TR1_ABILITIES_MASK \
	(TR1_LOW_ABILITIES_MASK | TR1_HIGH_ABILITIES_MASK)

#define TR2_ABILITIES_MASK \
	(TR2_LOW_ABILITIES_MASK | TR2_HIGH_ABILITIES_MASK)

#define TR3_ABILITIES_MASK \
	(TR3_LOW_ABILITIES_MASK | TR3_HIGH_ABILITIES_MASK)


/*Slay weapon types*/

#define TR1_SLAY_MASK \
	(TR1_SLAY_SPIDER | TR1_SLAY_UNDEAD | TR1_SLAY_RAUKO | TR1_SLAY_ORC | TR1_SLAY_TROLL | \
         TR1_SLAY_WOLF | TR1_SLAY_DRAGON)

#define TR2_SLAY_MASK \
	(0L)

#define TR3_SLAY_MASK \
	(0L)

/* Elemental Brand weapon types*/

#define TR1_BRAND_MASK \
	(TR1_BRAND_POIS | TR1_BRAND_ELEC | TR1_BRAND_FIRE | TR1_BRAND_COLD)

#define TR2_BRAND_MASK \
	(0L)

#define TR3_BRAND_MASK \
	(0L)

/* All weapon Multipliars*/

#define TR1_ALL_WEAPON_EGO_MASK \
	(TR1_SLAY_MASK | TR1_BRAND_MASK)

#define TR2_ALL_WEAPON_EGO_MASK \
	(TR2_SLAY_MASK | TR2_BRAND_MASK)

#define TR3_ALL_WEAPON_EGO_MASK \
	(TR3_SLAY_MASK | TR3_BRAND_MASK)



/*
 * Hack -- special "xtra" object flag info (type)
 */
#define OBJECT_XTRA_STAT_SUSTAIN		1
#define OBJECT_XTRA_TYPE_HIGH_RESIST	2
#define OBJECT_XTRA_TYPE_POWER			3
#define OBJECT_XTRA_TYPE_STAT_ADD		4
#define OBJECT_XTRA_TYPE_SLAY			5 /*Weapons Only*/
#define OBJECT_XTRA_TYPE_BRAND			6 /*Weapons Only*/
#define OBJECT_XTRA_TYPE_LOW_RESIST		7 /*Weapons Only*/

/*
 * Hack -- special "xtra" object flag info (base flag value)
 */
#define OBJECT_XTRA_BASE_SUSTAIN		TR2_SUST_STR
#define OBJECT_XTRA_BASE_HIGH_RESIST	TR2_RES_FEAR
#define OBJECT_XTRA_BASE_POWER			TR2_SLOW_DIGEST
#define OBJECT_XTRA_BASE_STAT_ADD		TR1_STR
#define OBJECT_XTRA_BASE_SLAY			TR1_SLAY_ORC
#define OBJECT_XTRA_BASE_BRAND			TR1_BRAND_COLD
#define OBJECT_XTRA_BASE_LOW_RESIST		TR2_RES_COLD

/*
 * Hack -- special "xtra" object flag info (number of flags)
 */
#define OBJECT_XTRA_SIZE_SUSTAIN		4
#define OBJECT_XTRA_SIZE_HIGH_RESIST	4
#define OBJECT_XTRA_SIZE_POWER			6
#define OBJECT_XTRA_SIZE_STAT_ADD		4
#define OBJECT_XTRA_SIZE_SLAY			7
#define OBJECT_XTRA_SIZE_BRAND			4
#define OBJECT_XTRA_SIZE_LOW_RESIST		5

/*Chance of adding additional flags after the first one*/
#define EXTRA_FLAG_CHANCE			20

#define EGO_AMMO_FLAME		99
#define EGO_AMMO_FROST		100
#define EGO_AMMO_VENOM		97

#define EGO_ELVENKIND_ARMOR		2
#define EGO_ELVENKIND_SHIELD	11
#define EGO_ELVENKIND_BOOTS		110
#define EGO_HOLY_AVENGER		35
#define EGO_FURY				36
#define EGO_BRAND_ELEMENTS		41
#define BRAND_OFFSET_FLAME		2
#define BRAND_OFFSET_FROST		3
#define BRAND_OFFSET_VENOM		4

#define EGO_SHATTERED	143
#define EGO_BLASTED		144


/*** Race/House flags ***/

#define RHF_BLADE_PROFICIENCY	0x00000001L	/* +1 bonus with bladed weapons */
#define RHF_AXE_PROFICIENCY		0x00000002L	/* +1 bonus with axes */
#define RHF_MEL_AFFINITY		0x00000004L	/* +1 bonus to melee and one free melee ability */
#define RHF_MEL_PENALTY			0x00000008L	/* -1 penalty to melee and all abilities cost 500 more */
#define RHF_ARC_AFFINITY		0x00000010L /* ... */
#define RHF_ARC_PENALTY			0x00000020L
#define RHF_EVN_AFFINITY		0x00000040L 
#define RHF_EVN_PENALTY			0x00000080L 
#define RHF_STL_AFFINITY		0x00000100L	
#define RHF_STL_PENALTY			0x00000200L 
#define RHF_PER_AFFINITY		0x00000400L 
#define RHF_PER_PENALTY			0x00000800L 
#define RHF_WIL_AFFINITY		0x00001000L
#define RHF_WIL_PENALTY			0x00002000L
#define RHF_SMT_AFFINITY		0x00004000L
#define RHF_SMT_PENALTY			0x00008000L
#define RHF_SNG_AFFINITY		0x00010000L
#define RHF_SNG_PENALTY			0x00020000L
#define RHF_RHFXXX19			0x00040000L
#define RHF_RHFXXX20			0x00080000L
#define RHF_RHFXXX21			0x00100000L
#define RHF_RHFXXX22			0x00200000L
#define RHF_RHFXXX23			0x00400000L
#define RHF_RHFXXX24			0x00800000L
#define RHF_RHFXXX25			0x01000000L
#define RHF_RHFXXX26			0x02000000L
#define RHF_RHFXXX27			0x04000000L
#define RHF_RHFXXX28			0x08000000L
#define RHF_RHFXXX29			0x10000000L
#define RHF_RHFXXX30			0x20000000L
#define RHF_RHFXXX31			0x40000000L
#define RHF_RHFXXX32			0x80000000L



#define MONSTER_BLOW_MAX 4

/*used to populate the mon_power_ave table*/
#define CREATURE_NON_UNIQUE	0
#define CREATURE_UNIQUE 	1
#define CREATURE_TYPE_MAX	2


/*columns for the spell cost or damage flags*/
#define COL_SPELL_MANA_COST		0
#define COL_SPELL_SIDES			1
#define COL_SPELL_BEST_RANGE	2


/*** Monster blow constants ***/

#define RBM_HIT           1
#define RBM_TOUCH         2
#define RBM_PUNCH         3
#define RBM_KICK          4
#define RBM_CLAW          5
#define RBM_BITE          6
#define RBM_STING         7
#define RBM_PECK          8
#define RBM_WHIP          9
#define RBM_BUTT         10
#define RBM_CRUSH        11
#define RBM_ENGULF       12
#define RBM_CRAWL        13
#define RBM_DROOL        14
#define RBM_SPIT         15
#define RBM_SLIME        16
#define RBM_GAZE         17
#define RBM_WAIL         18
#define RBM_SPORE        19
#define RBM_XXX4         20
#define RBM_BEG          21
#define RBM_INSULT       22
#define RBM_XXX5         23
#define RBM_XXX6         24

#define RBE_HURT       1
#define RBE_WOUND      2
#define RBE_BATTER     3
#define RBE_SHATTER    4

#define RBE_UN_BONUS   5
#define RBE_UN_POWER   6
#define RBE_LOSE_MANA  7
#define RBE_SLOW       8
#define RBE_EAT_ITEM   9
#define RBE_EAT_FOOD  10
#define RBE_DARK      11
#define RBE_HUNGER    12

#define RBE_POISON    13
#define RBE_ACID      14
#define RBE_ELEC      15
#define RBE_FIRE      16
#define RBE_COLD      17

#define RBE_BLIND     18
#define RBE_CONFUSE   19
#define RBE_TERRIFY   20
#define RBE_PARALYZE  21
#define RBE_HALLU     22
#define RBE_DISEASE   23

#define RBE_LOSE_STR      24
#define RBE_LOSE_DEX      25
#define RBE_LOSE_CON      26
#define RBE_LOSE_GRA      27
#define RBE_LOSE_STR_CON  28
#define RBE_LOSE_ALL      29

#define RBE_DISARM        30


/*
 * Levels of alertness: asleep, unwary, alert, aggressive
 */

#define ALERTNESS_MIN			-20
#define ALERTNESS_UNWARY		-10
#define ALERTNESS_ALERT			  0
#define ALERTNESS_QUITE_ALERT	  5
#define ALERTNESS_VERY_ALERT	 10
#define ALERTNESS_MAX			 20


/*** Monster flags ***/


/*
 * Special Monster Flags
 */
#define MFLAG_VIEW          0x00000001  /* Monster is in line of sight */
#define MFLAG_DLIM		    0x00000002	/* Knowledge of monster is limited */
#define MFLAG_MIMIC         0x00000004  /* A mimic detected as an object */
#define MFLAG_ACTV          0x00000008  /* Monster is in active mode */
#define MFLAG_MFLAGXXXX5    0x00000010  /* previously: Monster has moved */
#define MFLAG_MFLAGXXXX6	0x00000800L /* previously: Monster is using "townsman" AI */
#define MFLAG_SHOW	        0x00000040	/* Monster is recently memorized */
#define MFLAG_MARK	        0x00000080	/* Monster is currently memorized */
#define MFLAG_MFLAGXXXX7	0x00000100  /* previously: Monster is wary */
#define MFLAG_MFLAGXXXX8    0x00000200  /* previously: Monster is temporarily marked */
#define MFLAG_MFLAGXXXX9    0x00000400  /* previously: Monster has full required visibility */
#define MFLAG_PUSHED		0x00000800  /* Monster was pushed since its last turn */
#define MFLAG_MFLAGXXX10    0x00001000	/* previously: Monster is slightly slower than normal */
#define MFLAG_MFLAGXXX11    0x00002000  /* previously: Monster is slightly faster than normal */
#define MFLAG_ALWAYS_CAST	0x00004000  /* Monster will cast a spell first opportunity */
#define MFLAG_MFLAGXXX12	0x00008000  /* previously: Monster has been sneakily attacked */
#define MFLAG_AGGRESSIVE	0x00010000  /* Monster will be Aggressive instead of Confident */
#define MFLAG_HIT_BY_RANGED	0x00020000  /* Monster has been hit with a spell */
#define MFLAG_HIT_BY_MELEE	0x00040000	/* Monster was just meleed by player last turn */


/*
 * New monster race bit flags
 */
#define RF1_UNIQUE			0x00000001	/* Unique Monster */
#define RF1_QUESTOR			0x00000002	/* Quest Monster */
#define RF1_MALE			0x00000004	/* Male gender */
#define RF1_FEMALE			0x00000008	/* Female gender */
#define RF1_CHAR_CLEAR		0x00000010	/* Absorbs symbol */
#define RF1_CHAR_MIMIC		0x00000020	/* Monster can mimic a symbol */
#define RF1_ATTR_CLEAR		0x00000040	/* Absorbs color */
#define RF1_ATTR_MULTI		0x00000080	/* Changes color */
#define RF1_FORCE_DEPTH		0x00000100	/* Start at "correct" depth */
#define RF1_RF1XXX1			0x00000200	/* Unused */
#define RF1_FRIEND			0x00000400	/* Arrive with 0-1 friends*/
#define RF1_FRIENDS			0x00000800	/* Arrive with 1-3 friends */
#define RF1_ESCORT			0x00001000	/* Arrive with 4-7 escorts  */
#define RF1_ESCORTS			0x00002000	/* Arrive with 8-16 large escorts  */
#define RF1_UNIQUE_FRIEND	0x00004000	/* Only found with another unique (who also has this flag) */
#define RF1_NEVER_BLOW		0x00008000	/* Never make physical blow */
#define RF1_NEVER_MOVE		0x00010000	/* Never make physical move */
#define RF1_HIDDEN_MOVE		0x00020000	/* Only moves when out of player's view */
#define RF1_RAND_25			0x00040000	/* Moves randomly (25%) */
#define RF1_RAND_50			0x00080000	/* Moves randomly (50%) */
#define RF1_NO_CRIT			0x00100000	/* Immune to critical hits */
#define RF1_RES_CRIT		0x00200000	/* Resistant to critical hits */
#define RF1_DROP_33			0x00400000	/* Drop an item (33%) */
#define RF1_DROP_100		0x00800000	/* Drop an item (100%) */
#define RF1_DROP_1D2		0x01000000	/* Drop 1d2 items */
#define RF1_DROP_2D2		0x02000000	/* Drop 2d2 items */
#define RF1_DROP_3D2		0x04000000	/* Drop 3d2 items */
#define RF1_DROP_4D2		0x08000000	/* Drop 4d2 items */
#define RF1_DROP_GOOD		0x10000000	/* Drop good items -- i.e. guaranteed fine or special */
#define RF1_DROP_GREAT		0x20000000	/* Drop great items */
#define RF1_DROP_CHEST		0x40000000	/* Drop "useful" items */
#define RF1_DROP_CHOSEN		0x80000000	/* Drop "chosen" items */

/*TR1 uber-flags to cover multiple items*/
#define RF1_DROP_UP_TO_10	(RF1_DROP_2D2 | RF1_DROP_3D2)
#define RF1_DROP_UP_TO_12	(RF1_DROP_1D2 | RF1_DROP_2D2 | RF1_DROP_3D2)
#define RF1_DROP_UP_TO_14	(RF1_DROP_4D2 | RF1_DROP_1D2 | RF1_DROP_2D2)
#define RF1_DROP_UP_TO_16	(RF1_DROP_4D2 | RF1_DROP_3D2 | RF1_DROP_1D2)
#define RF1_DROP_UP_TO_18	(RF1_DROP_4D2 | RF1_DROP_3D2 | RF1_DROP_2D2)
#define RF1_DROP_UP_TO_20	(RF1_DROP_4D2 | RF1_DROP_3D2 | RF1_DROP_2D2 | RF1_DROP_1D2)

/*
 * New monster race bit flags
 */
#define RF2_MINDLESS		0x00000001	/* Monster is mindless */
#define RF2_SMART			0x00000002	/* Monster has roughly human-level intelligence smart */
#define RF2_TERRITORIAL     0x00000004  /* Monster doesn't pursue when around corners */
#define RF2_SHORT_SIGHTED	0x00000008	/* Monster is inactive unless player is within 2 squares */
#define RF2_INVISIBLE		0x00000010	/* Monster avoids vision */
#define RF2_GLOW			0x00000020	/* Monster's own square is lit */
#define RF2_RF2XXX1			0x00000040	/* (?) */
#define RF2_RF2XXX2			0x00000080	/* (?) */
#define RF2_MULTIPLY		0x00000100	/* Monster reproduces */
#define RF2_REGENERATE		0x00000200	/* Monster regenerates especially quickly */
#define RF2_RF2XXX3			0x00000400	/* (?) */
#define RF2_EVASIVE			0x00000800	/* Monster often avoids blows */
#define RF2_CLOUD_SURROUND	0x00001000	/* Surrounded by gas/spores/darkness */
#define RF2_RF2XXX5			0x00002000	/* (?) */
#define RF2_RF2XXX6			0x00004000	/* (?) */
#define RF2_UNLOCK_DOOR		0x00008000	/* Monster can unlock doors */
#define RF2_OPEN_DOOR		0x00010000	/* Monster can open doors */
#define RF2_BASH_DOOR		0x00020000	/* Monster can bash doors */
#define RF2_PASS_WALL		0x00040000	/* Monster can pass walls */
#define RF2_KILL_WALL		0x00080000	/* Monster can destroy walls */
#define RF2_RF2XXX7			0x00100000	/* (?) */
#define RF2_KILL_BODY		0x00200000	/* Monster can kill monsters */
#define RF2_TAKE_ITEM		0x00400000	/* Monster can pick up items */
#define RF2_KILL_ITEM		0x00800000	/* Monster can crush items */
#define RF2_BRAIN_1			0x01000000  /* (?) */
#define RF2_LOW_MANA_RUN    0x02000000  /* Runs away/teleports when low on mana */
#define RF2_BRAIN_2         0x04000000  /* (?) */
#define RF2_POWERFUL        0x08000000  /* Breath loses less power with distance */
#define RF2_RF2XXX8         0x10000000  /* Unused */
#define RF2_RF2XXX9		    0x20000000  /* Unused */
#define RF2_RF2XX10      	0x40000000  /* Unused */
#define RF2_BRAIN_3			0x80000000  /* (?) */


/*
 * New monster race bit flags
 */
#define RF3_ORC				0x00000001	/* Orc */
#define RF3_TROLL			0x00000002	/* Troll */
#define RF3_SERPENT			0x00000004	/* Serpent */
#define RF3_DRAGON			0x00000008	/* Dragon */
#define RF3_RAUKO			0x00000010	/* Rauko */
#define RF3_UNDEAD			0x00000020	/* Undead */
#define RF3_SPIDER			0x00000040	/* Spider */
#define RF3_WOLF			0x00000080	/* Wolf */
#define RF3_RF3XXX1			0x00000100	/* (?) */
#define RF3_RF3XXX2			0x00000200	/* (?) */
#define RF3_RF3XXX3			0x00000400	/* Non-Vocal (?) */
#define RF3_RF3XXX4			0x00000800	/* Non-Living (?) */
#define RF3_HURT_LITE		0x00001000	/* Hurt by lite */
#define RF3_STONE			0x00002000	/* Made of stone */
#define RF3_HURT_FIRE		0x00004000	/* Hurt badly by fire */
#define RF3_HURT_COLD		0x00008000	/* Hurt badly by cold */
#define RF3_RF3XXX5			0x00010000	/* (?) */
#define RF3_RES_ELEC		0x00020000	/* Resist elec */
#define RF3_RES_FIRE		0x00040000	/* Resist fire */
#define RF3_RES_COLD		0x00080000	/* Resist cold */
#define RF3_RES_POIS		0x00100000	/* Resist poison */
#define RF3_RF3XXX6			0x00200000	/* (?) */
#define RF3_RES_NETHR		0x00400000	/* Resist nether a lot */
#define RF3_RES_WATER		0x00800000	/* Resist water, move fast in water  */
#define RF3_RES_PLAS		0x01000000	/* Resist plasma */
#define RF3_RES_NEXUS		0x02000000	/* Resist nexus */
#define RF3_RES_DISEN		0x04000000	/* Resist disenchantment */
#define RF3_NO_SLOW			0x08000000	/* Cannot be slowed */
#define RF3_NO_FEAR			0x10000000	/* Cannot be scared */
#define RF3_NO_STUN			0x20000000	/* Cannot be stunned */
#define RF3_NO_CONF			0x40000000	/* Cannot be confused */
#define RF3_NO_SLEEP		0x80000000	/* Cannot be slept */

/*TR3 uber-flags to cover multiple items*/
#define RF3_RES_ELEM	(RF3_RES_ELEC | RF3_RES_FIRE | RF3_RES_COLD | RF3_RES_POIS)
#define RF3_RES_ALL		(RF3_RES_ELEM | RF3_RES_PLAS| RF3_RES_NETHR | RF3_RES_NEXUS | \
						 RF3_RES_DISEN | RF3_RES_WATER)
#define RF3_NO_CHARM (RF3_NO_FEAR | RF3_NO_STUN | RF3_NO_CONF | RF3_NO_SLEEP | RF3_NO_SLOW)

/*
 * Monster racial flags - 'spells'
 */
#define RF4_ARROW1         0x00000001  /* Fire arrows from a shortbow (1d7) */
#define RF4_ARROW2         0x00000002  /* Fire arrows from a longbow (1d11) */
#define RF4_BOULDER        0x00000004  /* Throw a boulder (Xd4) */
#define RF4_BRTH_FIRE      0x00000008  /* Breathe Fire (Xd4) */
#define RF4_BRTH_COLD      0x00000010  /* Breathe Cold (Xd4) */
#define RF4_BRTH_POIS      0x00000020  /* Breathe Poison (Xd4) */
#define RF4_BRTH_DARK      0x00000040  /* Breathe Darkness (Xd4) */
#define RF4_EARTHQUAKE     0x00000080  /* Create a small earthquake */
#define RF4_SHRIEK         0x00000100  /* Call for help */
#define RF4_SCREECH        0x00000200  /* Make a lot of noise and stun the player */
#define RF4_DARKNESS       0x00000400  /* Create darkness around the player */
#define RF4_FORGET         0x00000800  /* Cause the player to forget the map */
#define RF4_SCARE          0x00001000  /* Cause fear */
#define RF4_CONF           0x00002000  /* Cause confusion */
#define RF4_HOLD           0x00004000  /* Entrance the player */
#define RF4_RF4XXX16       0x00008000  /*  */
#define RF4_RF4XXX17       0x00010000  /*  */
#define RF4_RF4XXX18       0x00020000  /*  */
#define RF4_RF4XXX19       0x00040000  /*  */
#define RF4_RF4XXX20       0x00080000  /*  */
#define RF4_RF4XXX21       0x00100000  /*  */
#define RF4_RF4XXX22       0x00200000  /*  */
#define RF4_RF4XXX23       0x00400000  /*  */
#define RF4_RF4XXX24       0x00800000  /*  */
#define RF4_RF4XXX25       0x01000000  /*  */
#define RF4_RF4XXX26       0x02000000  /*  */
#define RF4_RF4XXX27       0x04000000  /*  */
#define RF4_RF4XXX28       0x08000000  /*  */
#define RF4_RF4XXX29       0x10000000  /*  */
#define RF4_RF4XXX30       0x20000000  /*  */
#define RF4_RF4XXX31       0x40000000  /*  */
#define RF4_RF4XXX32       0x80000000  /*  */


 /*
  * Some flags are obvious
  */

#define RF1_OBVIOUS_MASK \
	(RF1_UNIQUE | RF1_QUESTOR | RF1_MALE | RF1_FEMALE | \
	 RF1_FRIEND | RF1_FRIENDS | RF1_ESCORT | RF1_ESCORTS | RF1_NO_CRIT | RF1_RES_CRIT)

/*
 * "race" flags
 */

#define RF3_RACE_MASK \
	(RF3_ORC | RF3_TROLL | RF3_SERPENT | RF3_DRAGON | \
	 RF3_RAUKO | RF3_UNDEAD | RF3_SPIDER | RF3_WOLF)


/*
 * Archery attacks
 * Need special treatment in AI.
  */
#define RF4_ARCHERY_MASK \
        (RF4_ARROW1 | RF4_ARROW2 | RF4_BOULDER)


/*
 * Breath attacks.
 * Need special treatment in movement AI.
 */

#define RF4_BREATH_MASK \
        (RF4_BRTH_FIRE | RF4_BRTH_COLD | RF4_BRTH_POIS | RF4_BRTH_DARK)


 /*
  * Attack spells.
  * Need special treatment in movement AI.
  */
#define RF4_ATTACK_MASK \
        (RF4_ARCHERY_MASK)


/*
 * Harassment (not direct damage) attacks.
 * Need special treatment in AI.
 */
#define RF4_HARASS_MASK \
        (RF4_EARTHQUAKE | RF4_SHRIEK | RF4_SCREECH | RF4_DARKNESS | \
		 RF4_FORGET | RF4_SCARE | RF4_CONF | RF4_HOLD)


/* Spell Desire Table Columns */
#define D_BASE     0
#define D_RANGE    1


/*
 * Monsters will run up to 40 grids away
 */
#define FLEE_RANGE      MAX_SIGHT + 20

/*
 * Distance monsters will look for a hiding spot when fleeing.
 * Note that it is expensive to increase this too much.
 */
#define HIDE_RANGE      15


/*
 * Morale-based stances that a monster could be in
 */
#define STANCE_FLEEING			1
#define STANCE_CONFIDENT		2
#define STANCE_AGGRESSIVE		3


#define LEV_THEME_HEAD				11
#define LEV_THEME_CREEPING_COIN		0   /*creeping coins*/
#define LEV_THEME_ORC				1   /*orc*/
#define LEV_THEME_TROLL				2	/*troll*/
#define LEV_THEME_OGRE				3 	/*ogre*/
#define LEV_THEME_HOUND				4	/*hound*/
#define LEV_THEME_HYDRA				5	/*hydra*/
#define LEV_THEME_GIANT				6	/*giant*/
#define LEV_THEME_DRAGON_YOUNG		7	/*young dragon*/
#define LEV_THEME_DRAGON_ACID		8	/*acid dragon*/
#define LEV_THEME_DRAGON_FIRE		9	/*fire dragon*/
#define LEV_THEME_DRAGON_ELEC		10	/*electric dragon*/
#define LEV_THEME_DRAGON_COLD		11	/*cold dragon*/
#define LEV_THEME_DRAGON_POIS		12	/*poison dragon*/
#define LEV_THEME_DRAGON_CHROMATIC	13	/*chromatic dragon*/
#define LEV_THEME_DRAGON_MISC		14	/*dragon*/
#define LEV_THEME_DRAGON_ANCIENT	15	/*ancient dragon*/
#define LEV_THEME_JELLY				16	/*jelly*/
#define LEV_THEME_ORC_NAGA_YEEK_KOBOLD	17 /*kobold, yeek, ork, and naga*/
#define LEV_THEME_WOLF				18	/*wolf*/
#define LEV_THEME_HUMANOID			19	/*humanoid*/
#define LEV_THEME_DEMON_MINOR		20	/*minor demon*/
#define LEV_THEME_DEMON_ALL			21	/*demon*/
#define LEV_THEME_DEMON_MAJOR		22	/*major demon*/
#define LEV_THEME_CAVE_DWELLER		23	/*cave dweller*/
#define LEV_THEME_UNDEAD			24	/*undead*/
#define LEV_THEME_TAIL				25

#define PIT_LEVEL_BOOST				6
#define NEST_LEVEL_BOOST			5


/*** Option Definitions ***/

/*
 * Option indexes (offsets)
 *
 * These values are hard-coded by savefiles (and various pieces of code).
 */
#define OPT_USER_INTERFACE			0
#define OPT_DISTURBANCE			    16
#define OPT_GAME_PLAY			    32
#define OPT_EFFICIENCY			    48
#define OPT_BIRTH					128
#define OPT_CHEAT					160
#define OPT_ADULT					192
#define OPT_SCORE					224
#define OPT_NONE					255
#define OPT_MAX						256


/*
 * Option indexes (normal)
 *
 * These values are hard-coded by savefiles.
 */
#define OPT_hjkl_movement			0
#define OPT_quick_messages			1
#define OPT_angband_keyset			2
#define OPT_carry_query				3
#define OPT_stop_singing_on_rest	4
#define OPT_always_pickup			5
#define OPT_delay_factor			10
#define OPT_hitpoint_warning		11
// xxx always_repeat
// xxx depth_in_feet
// xxx stack_force_notes
// xxx stack_force_costs
// xxx show_labels	
// xxx show_weights	
// xxx show_choices		
// xxx show_details	
#define OPT_system_beep				14
// xxx show_flavors	
#define OPT_run_ignore_stairs		16
#define OPT_run_ignore_doors		17
// xxx run_cut_corners
// xxx run_use_corners
// xxx disturb_move	
// xxx disturb_near
// xxx disturb_panel
// xxx disturb_state
// xxx disturb_minor
// xxx disturb_wakeup
// xxx alert_hitpoint
// xxx alert_failure
// xxx verify_destroy
// xxx verify_special
// xxx allow_quantity	
// xxx
// xxx auto_haggle
// xxx auto_scum
// xxx allow_themed_levels
// xxx testing_carry
// xxx expand_look
// xxx expand_list
// xxx view_perma_grids
// xxx view_torch_grids
// xxx dungeon_align
// xxx dungeon_stair
// xxx track_follow
// xxx track_target
// xxx smart_cheat
// xxx view_reduce_lite
// xxx hidden_player
// xxx avoid_abort				
// xxx avoid_other				
// xxx flush_failure
// xxx flush_disturb
// xxx
// xxx fresh_before
// xxx fresh_after
// xxx
// xxx compress_savefile
#define OPT_hilite_player			59
#define OPT_hilite_target			60
#define OPT_hilite_unwary			61
#define OPT_solid_walls				62
#define OPT_hybrid_walls			63
// xxx easy_open
// xxx easy_alter
// xxx easy_floor
#define OPT_instant_run				67
#define OPT_center_player			68
#define OPT_run_avoid_center		69
// xxx scroll_target
// xxx auto_more
// xxx toggle_xp
#define OPT_auto_display_lists		73
// xxx hp_changes_color
// xxx verify_leave_quest
#define OPT_mark_squelch_items		76
#define OPT_display_hits			77
// xxx
// xxx 
// xxx 
// xxx 
// xxx birth_point_based
// xxx birth_auto_roller
// xxx birth_maximize
// xxx birth_preserve
#define OPT_birth_discon_stair		(OPT_BIRTH+3)
#define OPT_birth_ironman			(OPT_BIRTH+4)
// xxx birth_no_stores
#define OPT_birth_no_artefacts		(OPT_BIRTH+6)
// xxx birth_rand_artefacts
// xxx birth_no_stacking
// xxx birth_take_notes	
// xxx birth_force_small_lev
// xxx birth_retain_squelch
// xxx birth_no_quests
// xxx birth_no_player_ghosts
// xxx birth_no_store_services
// xxx birth_no_xtra_artefacts

/* xxx xxx */
#define OPT_cheat_peek				(OPT_CHEAT+0)
#define OPT_cheat_hear				(OPT_CHEAT+1)
#define OPT_cheat_room				(OPT_CHEAT+2)
#define OPT_cheat_xtra				(OPT_CHEAT+3)
#define OPT_cheat_know				(OPT_CHEAT+4)
#define OPT_cheat_live				(OPT_CHEAT+5)
#define OPT_cheat_monsters			(OPT_CHEAT+6)
#define OPT_cheat_noise				(OPT_CHEAT+7)
#define OPT_cheat_scent				(OPT_CHEAT+8)
#define OPT_cheat_light				(OPT_CHEAT+9)
#define OPT_cheat_skill_rolls		(OPT_CHEAT+10)
#define OPT_cheat_timestop			(OPT_CHEAT+11)
/* xxx xxx */
// xxx adult_point_based
// xxx adult_auto_roller
// xxx adult_maximize
// xxx adult_preserve
#define OPT_adult_discon_stair		(OPT_ADULT+3)
#define OPT_adult_ironman			(OPT_ADULT+4)
// xxx adult_no_stores
#define OPT_adult_no_artefacts		(OPT_ADULT+6)
// xxx adult_rand_artefacts
// xxx adult_no_stacking
// xxx adult_take_notes
// xxx adult_force_small_lev
// xxx adult_retain_squelch
// xxx adult_no_quests
// xxx OPT_adult_no_player_ghosts
// xxx OPT_adult_no_store_services
// xxx OPT_adult_no_xtra_artefacts
/* xxx xxx */
#define OPT_score_peek				(OPT_SCORE+0)
#define OPT_score_hear				(OPT_SCORE+1)
#define OPT_score_room				(OPT_SCORE+2)
#define OPT_score_xtra				(OPT_SCORE+3)
#define OPT_score_know				(OPT_SCORE+4)
#define OPT_score_live				(OPT_SCORE+5)
/* xxx xxx */


/*
 * Hack -- Option symbols
 */

#define show_weights			TRUE // Sil: we might want to change this for a handheld version
 
#define hjkl_movement			op_ptr->opt[OPT_hjkl_movement]
#define quick_messages			op_ptr->opt[OPT_quick_messages]
#define angband_keyset			op_ptr->opt[OPT_angband_keyset]
#define carry_query				op_ptr->opt[OPT_carry_query]
#define stop_singing_on_rest	op_ptr->opt[OPT_stop_singing_on_rest]
#define always_pickup			op_ptr->opt[OPT_always_pickup]
// xxx always_repeat 
#define depth_in_feet			op_ptr->opt[OPT_depth_in_feet]
// xxx stack_force_notes
// xxx stack_force_costs
// xxx show_labels	
// xxx show_choices
#define show_details			op_ptr->opt[OPT_show_details]
#define system_beep				op_ptr->opt[OPT_system_beep]
#define show_flavors			op_ptr->opt[OPT_show_flavors]
#define run_ignore_stairs		op_ptr->opt[OPT_run_ignore_stairs]
#define run_ignore_doors		op_ptr->opt[OPT_run_ignore_doors]
// xxx run_cut_corners
// xxx run_use_corners
// xxx disturb_move	
// xxx disturb_near		
// xxx disturb_panel	
// xxx disturb_state	
// xxx disturb_minor	
// xxx disturb_wakeup	
// xxx
// xxx alert_failure
// xxx verify_destroy
// xxx verify_special
// xxx allow_quantity
// xxx
// xxx auto_haggle
// xxx auto_scum
// xxx allow_themed_levels
// xxx testing_stack
// xxx testing_carry
// xxx expand_look
// xxx expand_list
// xxx view_perma_grids
// xxx view_torch_grids
// xxx dungeon_align
// xxx dungeon_stair
// xxx track_follow
// xxx track_target
// xxx smart_cheat
// xxx view_reduce_lite
// xxx hidden_player
// xxx avoid_abort	
// xxx avoid_other	
// xxx flush_failure	
// xxx flush_disturb	
// xxx
// xxx fresh_before	
// xxx fresh_after
#define fresh_after				FALSE // Sil: there is some chance I'll use this in the future
// xxx
// xxx compress_savefile
#define hilite_player			op_ptr->opt[OPT_hilite_player]
#define hilite_target			op_ptr->opt[OPT_hilite_target]
#define hilite_unwary			op_ptr->opt[OPT_hilite_unwary]
#define solid_walls				op_ptr->opt[OPT_solid_walls]
#define hybrid_walls			op_ptr->opt[OPT_hybrid_walls]
// xxx easy_open
// xxx easy_alter
// xxx easy_floor
#define instant_run				op_ptr->opt[OPT_instant_run]
#define center_player			op_ptr->opt[OPT_center_player]
#define run_avoid_center		op_ptr->opt[OPT_run_avoid_center]
// xxx scroll_target
// xxx auto_more	
// xxx toggle_xp
#define auto_display_lists		op_ptr->opt[OPT_auto_display_lists]
#define display_hits			op_ptr->opt[OPT_display_hits]
// xxx
// xxx
// xxx
// xxx
// xxx
// xxx birth_point_based
// xxx birth_auto_roller
// xxx birth_maximize
// xxx birth_preserve
#define birth_discon_stair		op_ptr->opt[OPT_birth_discon_stair]
#define birth_ironman			op_ptr->opt[OPT_birth_ironman]
// xxx birth_no_stores
#define birth_no_artefacts		op_ptr->opt[OPT_birth_no_artefacts]
// xxx birth_rand_artefacts

// xxx birth_no_stacking
// xxx birth_take_notes
// xxx birth_force_small_lev
// xxx birth_retain_squelch
// xxx birth_no_quests
// xxx birth_no_player ghosts
// xxx birth_no_store_services

// Sil: set directly to true at the moment, as they are currently incompatible with Sil
#define birth_no_xtra_artefacts	TRUE


// xxx
#define cheat_peek				op_ptr->opt[OPT_cheat_peek]
#define cheat_hear				op_ptr->opt[OPT_cheat_hear]
#define cheat_room				op_ptr->opt[OPT_cheat_room]
#define cheat_xtra				op_ptr->opt[OPT_cheat_xtra]
#define cheat_know				op_ptr->opt[OPT_cheat_know]
#define cheat_live				op_ptr->opt[OPT_cheat_live]
#define cheat_monsters			op_ptr->opt[OPT_cheat_monsters]
#define cheat_noise				op_ptr->opt[OPT_cheat_noise]
#define cheat_scent				op_ptr->opt[OPT_cheat_scent]
#define cheat_light				op_ptr->opt[OPT_cheat_light]
#define cheat_skill_rolls		op_ptr->opt[OPT_cheat_skill_rolls]
#define cheat_timestop			op_ptr->opt[OPT_cheat_timestop]
// xxx
// xxx adult_point_based
// xxx adult_auto_roller
// xxx adult_maximize
// xxx adult_preserve
#define adult_discon_stair	op_ptr->opt[OPT_adult_discon_stair]
#define adult_ironman				op_ptr->opt[OPT_adult_ironman]
// xxx adult_no_stores
#define adult_no_artefacts			op_ptr->opt[OPT_adult_no_artefacts]

// Sil: set directly to false at the moment, as they are currently incompatible with Sil
#define adult_rand_artefacts	FALSE

// xxx adult_no_stacking
// xxx adult_take_notes
// xxx adult_force_small_lev
// xxx adult_retain_squelch
// xxx adult_no_quests
// xxx adult_no_player_ghosts
// xxx adult_no_store_services

// Sil: set directly to true at the moment, as they are currently incompatible with Sil
#define adult_no_xtra_artefacts		TRUE

// xxx hp_changes_color
// xxx verify_leave_quest
// xxx mark_squelch_items
#define score_peek				op_ptr->opt[OPT_score_peek]
#define score_hear				op_ptr->opt[OPT_score_hear]
#define score_room				op_ptr->opt[OPT_score_room]
#define score_xtra				op_ptr->opt[OPT_score_xtra]
#define score_know				op_ptr->opt[OPT_score_know]
#define score_live				op_ptr->opt[OPT_score_live]
// xxx

// Sil: preserve mode is now the default, but I've put this here so that
// if I switch back, I just need to change this to a 0
#define PRESERVE_MODE 1

/*
 * Information for "do_cmd_options()".
 */
#define OPT_PAGE_MAX				7
#define OPT_PAGE_PER				20

/*
 *  Break things into pages
 */
#define INTERFACE_PAGE 0
#define VISUAL_PAGE    4
#define CHALLENGE_PAGE 5
#define DEBUG_PAGE     6


/*** Macro Definitions ***/

#define debug(X) {msg_format(X);msg_format(X);msg_format(X);msg_format(X);}

/*
 * Hack -- The main "screen"
 */
#define term_screen	(angband_term[0])

/*
 * Monster macros
 */

/*
 * Determine if a given monster is "non-living"
 *
 * Neither raukar, undead, or stone creatures are alive, nor are blades.
 */
#define monster_nonliving(M) \
	(((M)->flags3 & (RF3_RAUKO))  || \
	 ((M)->flags3 & (RF3_UNDEAD)) || \
	 ((M)->flags3 & (RF3_STONE)) || \
	 (strchr("|", (M)->d_char)))


/*
 * Determine if the monster is fully visible.
 */
#define mon_fully_visible(M) \
(((M)->ml) && !((M)->mflag & (MFLAG_MIMIC | MFLAG_DLIM)))



/*
 * Determine if a given inventory item is "aware"
 */
#define object_aware_p(T) \
	(k_info[(T)->k_idx].aware)

/*
 * Determine if a given inventory item is "tried"
 */
#define object_tried_p(T) \
	(k_info[(T)->k_idx].tried)


/*
 * Determine if a given inventory item is "known"
 * Test One -- Check for special "known" tag
 * Test Two -- Check for "Easy Know" + "Aware"
 */
#define object_known_p(T) \
	(((T)->ident & (IDENT_KNOWN)) || \
	 ((k_info[(T)->k_idx].flags3 & (TR3_EASY_KNOW)) && \
	  k_info[(T)->k_idx].aware))


/*
 * Return the "attr" for a given item.
 * Use "flavor" if available.
 * Default to user definitions.
 *
 */
#define object_attr(T) \
	((p_ptr->image) ? \
	 ((k_info[(T)->image_k_idx].flavor) ? \
	  (flavor_info[k_info[(T)->image_k_idx].flavor].x_attr) : \
	  (k_info[(T)->image_k_idx].x_attr)) : \
	 ((k_info[(T)->k_idx].flavor) ? \
	  (flavor_info[k_info[(T)->k_idx].flavor].x_attr) : \
	  ((weapon_glows(T)) ? \
	   (TERM_L_BLUE) : \
	   (((T)->name1 && a_info[(T)->name1].d_attr) ? \
	    (a_info[(T)->name1].d_attr) : \
	    (k_info[(T)->k_idx].x_attr)))))

/*
#define object_attr(T) \
    ((p_ptr->image) ? \
     ((k_info[(T)->image_k_idx].flavor) ? \
      (flavor_info[k_info[(T)->image_k_idx].flavor].x_attr) : \
      (k_info[(T)->image_k_idx].x_attr)) : \
     ((k_info[(T)->k_idx].flavor) ? \
      (flavor_info[k_info[(T)->k_idx].flavor].x_attr) : \
      (((T)->name1 && a_info[(T)->name1].d_attr) ? \
       (a_info[(T)->name1].d_attr) : \
       (k_info[(T)->k_idx].x_attr))))
*/

/*
#define object_attr(T) \
	((k_info[(T)->k_idx].flavor) ? \
	(flavor_info[k_info[(T)->k_idx].flavor].x_attr) : \
	 (((T)->name1 && a_info[(T)->name1].d_attr) ? \
	  (a_info[(T)->name1].d_attr) : \
	  (k_info[(T)->k_idx].x_attr)))
*/

/*
 * Return the "attr" for a k_idx.
 * Use "flavor" if available.
 * Default to user definitions.
 */
#define object_type_attr(T) \
	((k_info[T].flavor) ? \
	 (flavor_info[k_info[T].flavor].x_attr) : \
	 (k_info[T].x_attr))

/*
 * Return the "char" for a given item.
 * Use "flavor" if available.
 * Default to user definitions.
 */
#define object_char(T) \
	((p_ptr->image) ? \
	 ((k_info[(T)->image_k_idx].flavor) ? \
	  (flavor_info[k_info[(T)->image_k_idx].flavor].x_char) : \
	   (k_info[(T)->image_k_idx].x_char)) : \
	 ((k_info[(T)->k_idx].flavor) ? \
	  (flavor_info[k_info[(T)->k_idx].flavor].x_char) : \
	  (((T)->name1 && a_info[(T)->name1].d_char) ? \
	   (a_info[(T)->name1].d_char) : \
	   (k_info[(T)->k_idx].x_char))))

/*
#define object_char(T) \
	 ((k_info[(T)->k_idx].flavor) ? \
	  (flavor_info[k_info[(T)->k_idx].flavor].x_char) : \
	  (((T)->name1 && a_info[(T)->name1].d_char) ? \
	   (a_info[(T)->name1].d_char) : \
	   (k_info[(T)->k_idx].x_char)))
*/

/*
 * Return the "attr" for a given item.
 * Use "flavor" if available.
 * Use default definitions.
 */
#define object_attr_default(T) \
	((k_info[(T)->k_idx].flavor) ? \
	 (flavor_info[k_info[(T)->k_idx].flavor].d_attr) : \
	 (((T)->name1 && a_info[(T)->name1].d_attr) ? \
	  (a_info[(T)->name1].d_attr) : \
	  (k_info[(T)->k_idx].d_attr)))

/*
 * Return the "char" for a given item.
 * Use "flavor" if available.
 * Use default definitions.
 */
#define object_char_default(T) \
	((k_info[(T)->k_idx].flavor) ? \
	 (flavor_info[k_info[(T)->k_idx].flavor].d_char) : \
	 (((T)->name1 && a_info[(T)->name1].d_char) ? \
	  (a_info[(T)->name1].d_char) : \
	  (k_info[(T)->k_idx].d_char)))

/*
 * Return the "char" for a k_idx.
 * Use "flavor" if available.
 * Default to user definitions.
 */
#define object_type_char(T) \
	((k_info[T].flavor) ? \
	 (flavor_info[k_info[T].flavor].x_char) : \
	 (k_info[T].x_char))


/*
 * Artefacts use the "name1" field
 */
#define artefact_p(T) \
	((T)->name1 ? TRUE : FALSE)

/*
 * Ego-Items use the "name2" field
 */
#define ego_item_p(T) \
	((T)->name2 ? TRUE : FALSE)


/*
 * Pseduo identified as {artefact}
 */
#define artefact_pseudo_p(T) \
	((((T)->discount == INSCRIP_TERRIBLE) || ((T)->discount == INSCRIP_SPECIAL)) ? TRUE : FALSE)

/*
 * Pseduo identified as {special}
 */
#define special_pseudo_p(T) \
	((((T)->discount == INSCRIP_WORTHLESS) || ((T)->discount == INSCRIP_EXCELLENT)) ? TRUE : FALSE)


/*
 * Broken items.
 */
#define broken_p(T) \
	((T)->ident & (IDENT_BROKEN))

/*
 * Cursed items.
 */
#define cursed_p(T) \
	((T)->ident & (IDENT_CURSED))


/*
 * Convert an "attr"/"char" pair into a "pict" (P)
 */
#define PICT(A,C) \
	((((u16b)(A)) << 8) | ((byte)(C)))

/*
 * Convert a "pict" (P) into an "attr" (A)
 */
#define PICT_A(P) \
	((byte)((P) >> 8))

/*
 * Convert a "pict" (P) into an "char" (C)
 */
#define PICT_C(P) \
	((char)((byte)(P)))


/*
 * Convert a "location" (Y,X) into a "grid" (G)
 */
#define GRID(Y,X) \
	(256 * (Y) + (X))

/*
 * Convert a "grid" (G) into a "location" (Y)
 */
#define GRID_Y(G) \
	((int)((G) / 256U))

/*
 * Convert a "grid" (G) into a "location" (X)
 */
#define GRID_X(G) \
	((int)((G) % 256U))


/*
 * Determines if a map location is "meaningful"
 */
#define in_bounds(Y,X) \
	(((unsigned)(Y) < (unsigned)(p_ptr->cur_map_hgt)) && \
	 ((unsigned)(X) < (unsigned)(p_ptr->cur_map_wid)))

/*
 * Determines if a map location is fully inside the outer walls
 * This is more than twice as expensive as "in_bounds()", but
 * often we need to exclude the outer walls from calculations.
 */
#define in_bounds_fully(Y,X) \
	(((Y) > 0) && ((Y) < p_ptr->cur_map_hgt-1) && \
	 ((X) > 0) && ((X) < p_ptr->cur_map_wid-1))


/*
 * Determines if a map location is currently "on screen"
 * Note that "panel_contains(Y,X)" always implies "in_bounds(Y,X)".
 * Pre-storing this into a cave_info flag would be nice.  XXX XXX
 */
#define panel_contains(Y,X) \
	(((unsigned)((Y) - p_ptr->wy) < (unsigned)(SCREEN_HGT)) && \
	 ((unsigned)((X) - p_ptr->wx) < (unsigned)(SCREEN_WID)))



/*
 * Determine if a "legal" grid is a "floor" grid
 *
 * Line 1 -- forbid doors, rubble, seams, walls
 *
 * Note the use of the new "CAVE_WALL" flag.
 */
#define cave_floor_bold(Y,X) \
	(!(cave_info[Y][X] & (CAVE_WALL)))


/*
 * Determine if a "legal" grid is a "clean" floor grid
 *
 * Line 1 -- forbid non-floors
 * Line 2 -- forbid normal objects
 */
#define cave_clean_bold(Y,X) \
	((cave_feat[Y][X] == FEAT_FLOOR) && \
	 (cave_o_idx[Y][X] == 0))

/*
 * Determine if a "legal" grid is an "empty" floor grid
 *
 * Line 1 -- forbid doors, rubble, seams, walls
 * Line 2 -- forbid player/monsters
 */
#define cave_empty_bold(Y,X) \
	(cave_floor_bold(Y,X) && \
	 (cave_m_idx[Y][X] == 0))

/*
 * Determine if a "legal" grid is an "naked" floor grid
 *
 * Line 1 -- forbid non-floors
 * Line 2 -- forbid normal objects
 * Line 3 -- forbid player/monsters
 */
#define cave_naked_bold(Y,X) \
	((cave_feat[Y][X] == FEAT_FLOOR) && \
	 (cave_o_idx[Y][X] == 0) && \
	 (cave_m_idx[Y][X] == 0))

/*
 * Determine if a "legal" grid looks like a normal floor grid
 * (includes floors and hidden traps)
 */
#define cave_floorlike_bold(Y,X) \
	((cave_feat[Y][X] == FEAT_FLOOR) || \
	 ((cave_feat[Y][X] >= FEAT_TRAP_HEAD) && \
	  (cave_feat[Y][X] <= FEAT_TRAP_TAIL) && \
	  (cave_info[Y][X] & (CAVE_HIDDEN))))

/*
 * Determine if a "legal" grid is a "trap" grid
 */
#define cave_trap_bold(Y,X) \
	 ((cave_feat[Y][X] >= FEAT_TRAP_HEAD) && \
	  (cave_feat[Y][X] <= FEAT_TRAP_TAIL))

/*
 * Determine if a "legal" grid is a "forge" grid
 */
#define cave_forge_bold(Y,X) \
	 ((cave_feat[Y][X] >= FEAT_FORGE_HEAD) && \
	  (cave_feat[Y][X] <= FEAT_FORGE_TAIL))

/*
 * Determine if a "legal" grid is a "wall" grid
 */
#define cave_wall_bold(Y,X) \
	 ((cave_feat[Y][X] >= FEAT_WALL_HEAD) && \
	  (cave_feat[Y][X] <= FEAT_WALL_TAIL))


/*
 * Determine if a "legal" grid is an up stairs.
 */
#define cave_up_stairs(Y,X) \
   ((cave_feat[Y][X] == FEAT_LESS_SHAFT) || \
    (cave_feat[Y][X] == FEAT_LESS))

/*
 * Determine if a "legal" grid is a down stairs.
 */
#define cave_down_stairs(Y,X) \
   ((cave_feat[Y][X] == FEAT_MORE_SHAFT) || \
    (cave_feat[Y][X] == FEAT_MORE))

/*
 * Determine if a "legal" grid is a "stair" grid
 */
#define cave_stair_bold(Y,X) \
	 ((cave_feat[Y][X] >= FEAT_STAIR_HEAD) && \
	  (cave_feat[Y][X] <= FEAT_STAIR_TAIL))

/*
 * Determine if a "legal" grid is a pit.
 */
#define cave_pit(Y,X) \
   ((cave_feat[Y][X] == FEAT_TRAP_PIT) || \
    (cave_feat[Y][X] == FEAT_TRAP_SPIKED_PIT))

/*
 * Determine if a "legal" grid is "permanent"
 *
 * Line 1-2 -- perma-walls
 * Line 3 -- stairs
 * Line 4 -- forges
 */
#define cave_perma_bold(Y,X) \
	(((cave_feat[Y][X] >= FEAT_PERM_EXTRA) && \
	  (cave_feat[Y][X] <= FEAT_PERM_SOLID)) || \
	  (cave_stair_bold(Y,X)) || \
	  (cave_forge_bold(Y,X)))

/*
 * Determine if a "legal" grid is a closed door but not secret.
 * Open or broken doors don't count.
 */
#define cave_known_door(Y,X) \
    ((cave_feat[Y][X] >= FEAT_DOOR_HEAD) && \
     (cave_feat[Y][X] <= FEAT_DOOR_TAIL))

/*
 * Determine if a "legal" grid is a closed door.
 * Open or broken doors don't count.
 */
#define cave_closed_door(Y,X) \
   (((cave_feat[Y][X] >= FEAT_DOOR_HEAD) && \
     (cave_feat[Y][X] <= FEAT_DOOR_TAIL)) || \
     (cave_feat[Y][X] == FEAT_SECRET))



/*
 * Determine if a "legal" grid is within "los" of the player
 *
 * Note the use of comparison to zero to force a "boolean" result
 */
#define player_has_los_bold(Y,X) \
	((cave_info[Y][X] & (CAVE_VIEW)) != 0)


/*
 * Determine if a "legal" grid can be "seen" by the player
 *
 * Note the use of comparison to zero to force a "boolean" result
 */
#define player_can_see_bold(Y,X) \
	((cave_info[Y][X] & (CAVE_SEEN)) != 0)

/*
 * Determine if a "legal" grid is within "line of fire" of the player
 *
 * Note the use of comparison to zero to force a "boolean" result
 *
 * (Sil-y: actually I note that it isn't doing a comparison here -- bug?)
 */
#define player_can_fire_bold(Y,X) \
	(cave_info[Y][X] & (CAVE_FIRE))


/*** Color constants ***/


/*
 * Angband "attributes" (with symbols, and base (R,G,B) codes)
 *
 * The "(R,G,B)" codes are given in "fourths" of the "maximal" value,
 * and should "gamma corrected" on most (non-Macintosh) machines.
 */
#define TERM_DARK		0	/* 'd' */	/* 0,0,0 */
#define TERM_WHITE		1	/* 'w' */	/* 4,4,4 */
#define TERM_SLATE		2	/* 's' */	/* 2,2,2 */
#define TERM_ORANGE		3	/* 'o' */	/* 4,2,0 */
#define TERM_RED		4	/* 'r' */	/* 3,0,0 */
#define TERM_GREEN		5	/* 'g' */	/* 0,2,1 */
#define TERM_BLUE		6	/* 'b' */	/* 0,0,4 */
#define TERM_UMBER		7	/* 'u' */	/* 2,1,0 */
#define TERM_L_DARK		8	/* 'D' */	/* 1,1,1 */
#define TERM_L_WHITE	9	/* 'W' */	/* 3,3,3 */
#define TERM_VIOLET		10	/* 'v' */	/* 4,0,4 */
#define TERM_YELLOW		11	/* 'y' */	/* 4,4,0 */
#define TERM_L_RED		12	/* 'R' */	/* 4,0,0 */
#define TERM_L_GREEN	13	/* 'G' */	/* 0,4,0 */
#define TERM_L_BLUE		14	/* 'B' */	/* 0,4,4 */
#define TERM_L_UMBER	15	/* 'U' */	/* 3,2,1 */

#define TERM_SHADE		16	// added onto a colour N times to produce shade N

#define MSG_GENERIC          0
#define MSG_HIT              1
#define MSG_MISS             2
#define MSG_FLEE             3
#define MSG_DROP             4
#define MSG_KILL             5
#define MSG_LEVEL            6
#define MSG_DEATH            7
/* xxx old study message */
#define MSG_TELEPORT         9
#define MSG_SHOOT           10
#define MSG_QUAFF           11
#define MSG_ZAP             12
#define MSG_WALK            13
#define MSG_TPOTHER         14
#define MSG_HITWALL         15
#define MSG_EAT             16
/* xxx old store message */
/* xxx old store message */
/* xxx old store message */
/* xxx old store message */
#define MSG_DIG             21
#define MSG_OPENDOOR        22
#define MSG_SHUTDOOR        23
#define MSG_TPLEVEL         24
#define MSG_BELL            25
#define MSG_NOTHING_TO_OPEN 26
#define MSG_LOCKPICK_FAIL   27
#define MSG_STAIRS          28
#define MSG_HITPOINT_WARN   29
#define MSG_MAX             30


/*** Sound constants ***/


/*
 * Mega-Hack -- some primitive sound support (see "main-win.c")
 *
 * Some "sound" constants for "Term_xtra(TERM_XTRA_SOUND, val)"
 */
#define SOUND_HIT	    1
#define SOUND_MISS	    2
#define SOUND_FLEE	    3
#define SOUND_DROP	    4
#define SOUND_KILL	    5
#define SOUND_LEVEL	    6
#define SOUND_DEATH	    7
/* xxx old study sound  */
#define SOUND_TELEPORT  9
#define SOUND_SHOOT     10
#define SOUND_QUAFF     11
#define SOUND_ZAP       12
#define SOUND_WALK      13
#define SOUND_TPOTHER   14
#define SOUND_HITWALL   15
#define SOUND_EAT       16
/* xxx old store sound  */
/* xxx old store sound  */
/* xxx old store sound  */
/* xxx old store sound  */
#define SOUND_DIG       21
#define SOUND_OPENDOOR  22
#define SOUND_SHUTDOOR  23
#define SOUND_TPLEVEL   24

/*
 * Mega-Hack -- maximum known sounds
 *
 * Should be the same as MSG_MAX for compatibility reasons.
 */
#define SOUND_MAX MSG_MAX

/*
 * Maximum number of macro trigger names
 */
#define MAX_MACRO_TRIGGER 200
#define MAX_MACRO_MOD 12



/*** Hack ***/


/*
 * Hack -- attempt to reduce various values
 */
#ifdef ANGBAND_LITE
# undef MACRO_MAX
# define MACRO_MAX	128
# undef QUARK_MAX
# define QUARK_MAX	128
# undef MESSAGE_MAX
# define MESSAGE_MAX	128
# undef MESSAGE_BUF
# define MESSAGE_BUF	4096
#endif


/*
 * Available graphic modes
 */
#define GRAPHICS_NONE           0
#define GRAPHICS_ORIGINAL       1
#define GRAPHICS_ADAM_BOLT      2
#define GRAPHICS_DAVID_GERVAIS  3
#define GRAPHICS_PSEUDO         4


/*
 * List of commands that will be auto-repeated
 *
 * ToDo: This string should be user-configurable.
 */
#define AUTO_REPEAT_COMMANDS "TBDoc+"

/*
 * Health levels
 */
 
#define HEALTH_DEAD				0	//   0%
#define HEALTH_ALMOST_DEAD		1	//   1% - 25%
#define HEALTH_BADLY_WOUNDED	2	//  26% - 50%
#define HEALTH_WOUNDED			3	//  51% - 75%
#define HEALTH_SOMEWHAT_WOUNDED	4	//  76% - 99%
#define HEALTH_UNHURT			5	// 100%


/*
 * Artefact activation index
 */
#define ACT_ILLUMINATION        0
#define ACT_MAGIC_MAP           1
#define ACT_CLAIRVOYANCE        2
#define ACT_PROT_EVIL           3
#define ACT_DISP_EVIL           4
#define ACT_HEAL1               5
#define ACT_HEAL2               6
#define ACT_CURE_WOUNDS         7
#define ACT_HASTE1              8
#define ACT_HASTE2              9
#define ACT_FIRE1               10
#define ACT_FIRE2               11
#define ACT_FIRE3               12
#define ACT_FROST1              13
#define ACT_FROST2              14
#define ACT_FROST3              15
#define ACT_FROST4              16
#define ACT_FROST5              17
#define ACT_ACID1               18
#define ACT_RECHARGE1           19
#define ACT_SLEEP               20
#define ACT_LIGHTNING_BOLT      21
#define ACT_ELEC2               22
#define ACT_BANISHMENT          23
#define ACT_MASS_BANISHMENT     24
#define ACT_IDENTIFY            25
#define ACT_DRAIN_LIFE1         26
#define ACT_DRAIN_LIFE2         27
#define ACT_BIZZARE             28
#define ACT_STAR_BALL           29
#define ACT_RAGE_BLESS_RESIST   30
#define ACT_PHASE               31
#define ACT_TRAP_DOOR_DEST      32
#define ACT_DETECT              33
#define ACT_RESIST              34
#define ACT_TELEPORT            35
#define ACT_RESTORE_VOICE       36
#define ACT_MISSILE             37
#define ACT_ARROW               38
#define ACT_REM_FEAR_POIS       39
#define ACT_STINKING_CLOUD      40
#define ACT_STONE_TO_MUD        41
#define ACT_TELE_AWAY           42
#define ACT_WOR                 43
#define ACT_CONFUSE             44
#define ACT_PROBE               45
#define ACT_FIREBRAND           46
#define ACT_STARLIGHT           47
#define ACT_MANA_BOLT           48
#define ACT_BERSERKER           49
#define ACT_RES_ACID			50
#define ACT_RES_ELEC			51
#define ACT_RES_FIRE			52
#define ACT_RES_COLD			53
#define ACT_RES_POIS			54

#define ACT_MAX                 55

/*
 * HACK - define if the source contains the cleanup_angband() function.
 */
#define HAS_CLEANUP


/*
 * Given an array, determine how many elements are in the array.
 */
#define N_ELEMENTS(a) (sizeof(a) / sizeof((a)[0]))

/*
 * Special note used to mark the end of the notes section in the savefile
 */
#define NOTES_MARK "@@@@@@@ No more notes @@@@@@@"

/* Returns TRUE if T is a torch or a lantern */
#define fuelable_light_p(T) (((T)->tval == TV_LIGHT) && (((T)->sval == SV_LIGHT_LANTERN) || ((T)->sval == SV_LIGHT_TORCH)))

/*
 * Returns the current length of the text in the buffer.
 */
#define EDITING_BUFFER_LEN(T) \
((T)->max_size - (T)->gap_size)

/*
 * Returns a character in the buffer. Use it instead of direct access.
 */
#define EDITING_BUFFER_GET(T,i) \
(((i) < (T)->pos) ? (T)->buf[(i)]: (T)->buf[(i) + (T)->gap_size])

/*
 * Get the index of a shaded color in angband_color_table.
 * base_color must be between 0 and 15. These are the TERM_* constants.
 * shade must be between 0 and 7 (8 shades supported, 0 is the base color).
 * 16 shades could be supported but the values returned are in the range 0-127
 * to avoid clashes with graphic or big_tile modes (bit 0x80 is reserved)
 * All shades will look like the base color in 16 color ports.
 */
#define MAKE_EXTENDED_COLOR(base_color, shade) \
((((shade) << 4) | ((base_color) & 0x0F)) & 0x7F)

/*
 * Get the base color of a given extended color (shade).
 * Values returned are in the range 0-15 (TERM_*). See above.
 */
#define GET_BASE_COLOR(ext_color) ((ext_color) & 0x0F)

/*
 * Get the shade number of a given extended color.
 * Values returned are in the range 0-7. See above.
 */
#define GET_SHADE(ext_color) (((ext_color) >> 4) & 0x07)

/*
 * Number of base colors. These are the TERM_* constants
 */
#define MAX_BASE_COLORS 16

/*
 * Number of shades, including the shade 0 (base colors)
 */
#define MAX_SHADES 8

/*
 * These are the return values of squelch_itemp()
 */
#define SQUELCH_FAILED -1
#define SQUELCH_NO      0
#define SQUELCH_YES     1
