#ifndef MONTHDATA_H
#define MONTHDATA_H

#include <QString>
#include <QObject>
#include <QVector>
#include <QStandardItemModel>
#include <QDate>
#include <QDebug>
#include "expensesgraphmodel.h"
#include "expense.h"
#include "global.h"
#include "account.h"

class MonthData : public ExpensesGraphModel
{
        Q_OBJECT
 public:
        MonthData(QDate date,
                  Account *account,
                  QObject *parent = 0);
        ~MonthData();

        int year();
        int month();
        int days();
        Account* account();
        double budget();
        void setBudget(double budget);
        void addExpense(Expense *e);
        double maxExpense();
        double totalExpense();
        QStandardItemModel* expenses();
        double value(int i);
        QDate next();
        QDate previous();
        bool isCurrent();
        QDate date();
        void clear();
        int xDivisions();
        int label(int i);
        double reference(int i);
        double maxBudget();

 signals:

 private:

        QDate _date;
        double _budget;
        Account *_account;
        QVector<double> _summary;
        QStandardItemModel *_expenses;
        double _maxExpense;
        double _totalExpense;
        double _dailyExpense;
};

#endif
