#include "confirmationdialogmaemo.h"
#include <QHBoxLayout>
#include <QDialogButtonBox>
#include <QPushButton>
#include <QLabel>

bool ConfirmationDialogMaemo::dialogAccepted = false;

ConfirmationDialogMaemo::ConfirmationDialogMaemo(const QString &message,
                                                 QWidget *parent,
                                                 Qt::WindowFlags f)
        : QDialog (parent, f)
{
        setWindowTitle(tr("Confirm action"));

        QHBoxLayout *layout = new QHBoxLayout (this);

        QLabel *label = new QLabel(message);
        label->setWordWrap(true);
        layout->addWidget(label, 1);

        QDialogButtonBox *box = new QDialogButtonBox(Qt::Vertical);
        box->addButton(new QPushButton(tr("Yes")), QDialogButtonBox::YesRole);
        box->addButton(new QPushButton(tr("No")), QDialogButtonBox::NoRole);
        layout->addWidget (box, 0, Qt::AlignBottom);

        connect(box, SIGNAL(accepted()), this, SLOT(confirmationAccepted()));
        connect(box, SIGNAL(rejected()), this, SLOT(confirmationRejected()));
}

ConfirmationDialogMaemo::~ConfirmationDialogMaemo()
{
}

void ConfirmationDialogMaemo::confirmationAccepted()
{
        ConfirmationDialogMaemo::dialogAccepted = true;
        accept();
}

void ConfirmationDialogMaemo::confirmationRejected()
{
        ConfirmationDialogMaemo::dialogAccepted = false;
        reject();
}

bool ConfirmationDialogMaemo::askConfirmation(const QString &message,
                                              QWidget *parent)
{
        dialogAccepted = false;
        ConfirmationDialogMaemo dialog(message, parent);
        dialog.exec();
        return dialogAccepted;
}
