#include "conceptdetailsdialogmaemo.h"
#include "confirmationdialogmaemo.h"
#include <QHBoxLayout>
#include <QFormLayout>
#include <QVBoxLayout>
#include <QDialogButtonBox>
#include <QDebug>
#include <QPushButton>
#include <QMaemo5InformationBox>

ConceptDetailsDialogMaemo::ConceptDetailsDialogMaemo(QStandardItemModel *concepts,
                                                     int row,
                                                     QWidget *parent,
                                                     Qt::WindowFlags f)
        : ConceptDetailsDialog (parent, f)
{
        _row = row;
        setWindowTitle(tr("Item details"));

        QHBoxLayout *layout = new QHBoxLayout (this);

        QVBoxLayout *vBox = new QVBoxLayout();
        layout->addLayout (vBox, 1);
        vBox->addStretch(1);

        QFormLayout *form = new QFormLayout ();
        form->setHorizontalSpacing(50);
        vBox->addLayout (form, 1);

        QLabel *name = new QLabel();
        form->addRow (new QLabel(tr("Name")), name);
        _price = new QLineEdit();
        conceptName = concepts->item(row, 0)->text();
        name->setText(conceptName);
        _price->setText(concepts->item(row, 1)->text());
        form->addRow (new QLabel(tr("Price")), _price);

        box = new QDialogButtonBox (QDialogButtonBox::Cancel, Qt::Vertical);
        QPushButton *saveButton = new QPushButton(tr("Save"));
        box->addButton(saveButton, QDialogButtonBox::ActionRole);
        QPushButton *deleteButton = new QPushButton(tr("Delete"));
        box->addButton(deleteButton, QDialogButtonBox::ActionRole);

        layout->addWidget (box, 0, Qt::AlignBottom);

        connect(box, SIGNAL(rejected()), this, SLOT(reject()));
        connect(saveButton, SIGNAL(clicked()), this, SLOT(saveClicked()));
        connect(deleteButton, SIGNAL(clicked()), this, SLOT(deleteClicked()));
}

ConceptDetailsDialogMaemo::ConceptDetailsDialogMaemo(QWidget *parent,
                                                     Qt::WindowFlags f)
        : ConceptDetailsDialog (parent, f)
{
        setWindowTitle(tr("Create new item"));

        QHBoxLayout *layout = new QHBoxLayout (this);

        QVBoxLayout *vBox = new QVBoxLayout();
        layout->addLayout (vBox, 1);
        vBox->addStretch(1);

        QFormLayout *form = new QFormLayout ();
        form->setHorizontalSpacing(50);
        vBox->addLayout (form, 1);

        _name = new QLineEdit();
        form->addRow (new QLabel(tr("Name")), _name);
        _price = new QLineEdit();
        form->addRow (new QLabel(tr("Price")), _price);

        box = new QDialogButtonBox (QDialogButtonBox::Cancel, Qt::Vertical);
        QPushButton *saveButton = new QPushButton(tr("Save"));
        box->addButton(saveButton, QDialogButtonBox::ActionRole);
        layout->addWidget (box, 0, Qt::AlignBottom);

        connect(box, SIGNAL(rejected()), this, SLOT(reject()));
        connect(saveButton, SIGNAL(clicked()), this, SLOT(newClicked()));
}

void ConceptDetailsDialogMaemo::saveClicked()
{
        if (_price->text() == "") {
                QMaemo5InformationBox::information(this, tr("Price field cannot be empty"));
                return;
        }

        double price = _price->text().toDouble();

        if (price <= 0) {
                QMaemo5InformationBox::information(this, tr("Invalid price format"));
                return;
        }

        accept();
        emit updateConceptConfirmed(new Concept(conceptName, price));
}

void ConceptDetailsDialogMaemo::deleteClicked()
{
        QString message(tr("When deleting a concept, all the expenses associated to it "
                           "will be assigned an empty concept instead.\n\n"
                           "Are you sure you want to delete the concept?"));

        if (ConfirmationDialogMaemo::askConfirmation(message, this)) {
                accept();
                emit deleteConceptConfirmed(new Concept(conceptName,0));
        }
}

void ConceptDetailsDialogMaemo::newClicked()
{
        if (_name->text() == "") {
                QMaemo5InformationBox::information(this, tr("Name field cannot be empty"));
                return;
        }

        if (_price->text() == "") {
                QMaemo5InformationBox::information(this, tr("Price field cannot be empty"));
                return;
        }

        double price = _price->text().toDouble();

        if (price <= 0) {
                QMaemo5InformationBox::information(this, tr("Invalid price format"));
                return;
        }

        accept();
        emit newConceptConfirmed(new Concept(_name->text(), price));
}
