#include <QHBoxLayout>
#include <QFormLayout>
#include <QDialogButtonBox>
#include <QLabel>
#include <QMaemo5InformationBox>
#include <QPushButton>
#include "budgetdialogmaemo.h"

BudgetDialogMaemo::BudgetDialogMaemo(double current,
                                     QWidget *parent,
                                     Qt::WindowFlags f)
        : BudgetDialog (parent, f)
{

        setWindowTitle(tr("Modify month budget"));

        QHBoxLayout *layout = new QHBoxLayout (this);

        QFormLayout *form = new QFormLayout ();
        form->setHorizontalSpacing(50);
        layout->addLayout (form, 1);

        _budget = new QLineEdit(QString("%1").arg(current));
        form->addRow (new QLabel(tr("Month budget")), _budget);

        QDialogButtonBox *box = new QDialogButtonBox (QDialogButtonBox::Cancel);
        QPushButton *saveButton = new QPushButton(tr("Save"));
        box->addButton(saveButton, QDialogButtonBox::ActionRole);
        layout->addWidget (box, 0, Qt::AlignBottom);

        connect(saveButton, SIGNAL(clicked()), this, SLOT(saveClicked()));
        connect(box, SIGNAL(rejected()), this, SLOT(reject()));
}

void BudgetDialogMaemo::saveClicked()
{
        double newBudget = _budget->text().toDouble();

        if (_budget->text() != "" && newBudget == 0) {
                QMaemo5InformationBox::information(this, tr("Invalid amount format"));
                return;
        }

        accept();
        emit changeBudget(newBudget);
}

