#include "scheduledlistdesktop.h"
#include <QVBoxLayout>
#include <QDialogButtonBox>
#include <QDebug>
#include <QTreeView>
#include <QPushButton>
#include <QLabel>
#include <QIcon>
#include "global.h"

ScheduledListDesktop::ScheduledListDesktop(QStandardItemModel *scheduled,
                                           QWidget *parent)
        : ScheduledList (parent)
{
        setWindowTitle(tr("Scheduled Expenses"));
        setAttribute(Qt::WA_DeleteOnClose);
        setWindowFlags(windowFlags() | Qt::Window);

        QVBoxLayout *layout = new QVBoxLayout (this);

        QTreeView *tree = new QTreeView();
        tree->setModel(scheduled);
        tree->setColumnHidden(SCHEDULED_ID, true);
        tree->setColumnHidden(SCHEDULED_DAY, true);
        tree->setColumnHidden(SCHEDULED_DESCRIPTION, true);
        tree->setColumnHidden(SCHEDULED_MONTH, true);
        tree->setColumnWidth(SCHEDULED_DAY_AS_STRING, 100);
        tree->setColumnWidth(SCHEDULED_AMOUNT, 70);
        tree->setColumnWidth(SCHEDULED_CONCEPT, 150);
        tree->setColumnWidth(SCHEDULED_MONTH_AS_STRING, 200);
        layout->addWidget(tree, 1);

        connect (tree, SIGNAL(activated(const QModelIndex&)),
                 this, SIGNAL(scheduledDetailsSelected(QModelIndex)));

        QPushButton *newButton = new QPushButton(tr("New"));
        newButton->setIcon(QIcon(GENERAL_ADD_ICON));
        layout->addWidget(newButton, 0, Qt::AlignRight | Qt::AlignVCenter);
        connect(newButton, SIGNAL(clicked()), this, SIGNAL(newScheduledSelected()));
}

ScheduledListDesktop::~ScheduledListDesktop()
{
}

QSize ScheduledListDesktop::minimumSizeHint() const
{
        return QSize(600, 200);
}

QSize ScheduledListDesktop::sizeHint() const
{
        return QSize(600, 200);
}
