#ifndef ACCOUNTDETAILSDIALOGDESKTOP_H
#define ACCOUNTDETAILSDIALOGDESKTOP_H

#include <QStandardItemModel>
#include <QLabel>
#include <QLineEdit>
#include <QDialogButtonBox>
#include "account.h"
#include "accountdetailsdialog.h"

class AccountDetailsDialogDesktop : public AccountDetailsDialog
{
        Q_OBJECT
 public:
        AccountDetailsDialogDesktop(QStandardItemModel *accounts,
                                    int row,
                                    Account *activeAccount,
                                    QWidget *parent = 0,
                                    Qt::WindowFlags f = 0);
        AccountDetailsDialogDesktop(QWidget *parent = 0,
                                    Qt::WindowFlags f = 0);
        QSize minimumSizeHint() const;
        QSize sizeHint() const;

 private slots:
        void saveClicked();
        void deleteClicked();
        void newClicked();
        void activateClicked();

 private:
        QLineEdit *_name;
        QLineEdit *_budget;
        QDialogButtonBox *box;
        int _row;
        double accountBudget;
        QString accountName;
        int accountId;
};
#endif
