#include "monthdata.h"
#include <QListIterator>

MonthData::MonthData(QDate date,
                     Account *account,
                     QObject *parent)
        : QObject(parent)
{
        _date = date;
        _account = account;
        _budget = account->budget();
        _maxExpense = 0;
        _totalExpense = 0;
        _summary.resize(_date.daysInMonth() + 1);
        _summary.fill(0);
        _expenses = new QStandardItemModel(0,5);
}

MonthData::~MonthData()
{
        delete _expenses;
}
int MonthData::year()
{
        return _date.year();
}

Account* MonthData::account()
{
        return _account;
}

int MonthData::month()
{
        return _date.month();
}

int MonthData::days()
{
        return _date.daysInMonth();
}

double MonthData::budget()
{
        return _budget;
}

void MonthData::setBudget(double budget)
{
        _budget = budget;
        emit budgetChanged();
}

void MonthData::addExpense(Expense *e)
{
        _summary[e->day()] += e->amount();
        _totalExpense += e->amount();
        if (_summary[e->day()] > _maxExpense) {
                _maxExpense = _summary[e->day()];
        }

        QStandardItem *item;
        QList<QStandardItem*> row;
        item = new QStandardItem (QString("%1").arg(e->id()));
        item->setTextAlignment(Qt::AlignCenter);
        item->setEditable(false);
        row.append(item);
        item = new QStandardItem (QString("%1").arg(e->day()));
        item->setTextAlignment(Qt::AlignCenter);
        item->setEditable(false);
        row.append(item);
        item = new QStandardItem (QString("%1").arg(e->amount()));
        item->setTextAlignment(Qt::AlignCenter);
        item->setEditable(false);
        row.append(item);
        item = new QStandardItem (e->concept());
        item->setTextAlignment(Qt::AlignLeft | Qt::AlignVCenter);
        item->setEditable(false);
        row.append(item);
        item = new QStandardItem (e->description());
        item->setTextAlignment(Qt::AlignLeft | Qt::AlignVCenter);
        item->setEditable(false);
        row.append(item);
        _expenses->appendRow(row);

        delete e;

        emit expensesChanged();
}

QStandardItemModel* MonthData::expenses()
{
        return _expenses;
}

double MonthData::maxExpense()
{
        return _maxExpense;
}

double MonthData::totalExpense()
{
        return _totalExpense;
}

QDate MonthData::next()
{
        return(_date.addMonths(1));
}

QDate MonthData::previous()
{
        return(_date.addMonths(-1));
}

bool MonthData::isCurrent()
{
        return (_date.year() == QDate::currentDate().year()
                && _date.month() == QDate::currentDate().month());
}

QDate MonthData::date()
{
        return _date;
}

const QVector<double>& MonthData::summary()
{
        return _summary;
}

void MonthData::clear()
{
        _summary.fill(0);
        _expenses->removeRows(0, _expenses->rowCount());
        _maxExpense = 0;
        _totalExpense = 0;

        emit expensesChanged();
}
