#ifndef SUMMARYDATA_H
#define SUMMARYDATA_H

#include <QObject>
#include <QList>
#include "concept.h"

class SummaryData : public QObject
{
        Q_OBJECT
 public:
        SummaryData(int startYear,
                    int startMonth,
                    int endYear,
                    int endMonth);
        ~SummaryData();

        int startYear();
        int startMonth();
        int endYear();
        int endMonth();

        double totalBudget();
        double totalExpense();
        double totalSaved();
        double maxExpense();
        double minExpense();
        double maxSaved();
        double minSaved();
        double averageExpense();
        double averageSaved();

        void addMonthData(double budget, double expense);
        void addConcept(Concept *c);

        const QList<Concept*>& concepts();

 private:
        int _startYear;
        int _startMonth;
        int _endYear;
        int _endMonth;

        double _totalBudget;
        double _totalExpense;
        double _totalSaved;

        double _maxExpense;
        double _minExpense;
        double _minSaved;
        double _maxSaved;

        int _monthCount;

        QList<Concept*> _concepts;
};

#endif
