#ifndef SCHEDULEDDETAILSDIALOG_H
#define SCHEDULEDDETAILSDIALOG_H

#include <QDialog>
#include <QLineEdit>
#include <QList>
#include <QDate>
#include "expense.h"
#include "concept.h"
#include <QMaemo5ValueButton>
#include <QStandardItemModel>
#include <QListView>
#include <QDialog>
#include <QItemSelectionModel>
#include <QDialogButtonBox>
#include <QMaemo5ListPickSelector>

class ScheduledDetailsDialog : public QDialog
{
        Q_OBJECT
 public:
        ScheduledDetailsDialog(QStandardItemModel *concepts,
                               QWidget *parent = 0,
                               Qt::WindowFlags f = 0);

        ScheduledDetailsDialog(QStandardItemModel *concepts,
                               QStandardItemModel *scheduled,
                               int row,
                               QWidget *parent = 0,
                               Qt::WindowFlags f = 0);

        ~ScheduledDetailsDialog();

 signals:
        void newScheduledConfirmed(Expense *e);
        void deleteScheduledConfirmed(Expense *e);
        void updateScheduledConfirmed(Expense *e);

 private slots:
        void conceptSelected(const QString &value);
        void checkValues();
        void deleteClicked();
        void launchMonthDialog();
        void saveMonthSelection();
        void closeMonthDialog();

 private:
        void buildUI (QStandardItemModel *concepts);

        QMaemo5ValueButton *day;
        QMaemo5ListPickSelector *daySelector;
        QMaemo5ValueButton *month;
        QLineEdit *amount;
        QMaemo5ValueButton *concept;
        QMaemo5ListPickSelector *conceptSelector;
        QLineEdit *description;
        int scheduledId;
        int monthSelectionAsInt;

        QDialog *monthDialog;
        QStandardItemModel *monthModel;
        QListView *monthList;
        QItemSelectionModel *monthSelection;

        QDialogButtonBox *box;

        bool newScheduled;
};
#endif
