#ifndef MONTHDATA_H
#define MONTHDATA_H

#include <QString>
#include <QObject>
#include <QVector>
#include <QStandardItemModel>
#include <QDate>
#include <QDebug>
#include "expense.h"
#include "global.h"
#include "account.h"

class MonthData : public QObject
{
        Q_OBJECT
 public:
        MonthData(QDate date,
                  Account *account,
                  QObject *parent = 0);
        ~MonthData();

        int year();
        int month();
        int days();
        Account* account();
        double budget();
        void setBudget(double budget);
        void addExpense(Expense *e);
        double maxExpense();
        double totalExpense();
        QStandardItemModel* expenses();
        const QVector<double>& summary();
        QDate next();
        QDate previous();
        bool isCurrent();
        QDate date();
        void clear();

 signals:
        void expensesChanged();
        void budgetChanged();

 private:

        QDate _date;
        double _budget;
        Account *_account;
        QVector<double> _summary;
        QStandardItemModel *_expenses;
        double _maxExpense;
        double _totalExpense;
};

#endif
