#ifndef DATECHOOSERDIALOG_H
#define DATECHOOSERDIALOG_H

#include <QDialog>
#include <QObject>
#include <QListView>

class DateChooserDialog : public QDialog
{
        Q_OBJECT
 public:
        DateChooserDialog(int minYear,
                          int minMonth,
                          int maxYear,
                          int maxMonth,
                          int selectedYear,
                          int selectedMonth,
                          QWidget *parent = 0,
                          Qt::WindowFlags f = 0);
        ~DateChooserDialog();

        static bool askDate(int minYear,
                            int minMonth,
                            int maxYear,
                            int MaxMonth,
                            int &selectedYear,
                            int &selectecMonth);
 signals:

 private slots:
        void dateSelected();
        void dateCancelled();

 private:
        static int year;
        static int month;
        static bool dialogAccepted;
        int _minYear;
        int _minMonth;
        int _maxYear;
        int _maxMonth;
        QListView *monthList;
        QListView *yearList;
};
#endif
