#ifndef SUMMARYWINDOW_H
#define SUMMARYWINDOW_H

#include <QWidget>
#include <QPushButton>
#include <QLabel>
#include "periodwindow.h"
#include "summarydata.h"
#include "conceptschart.h"
#include <QAction>
#include <QFrame>

class SummaryWindow : public PeriodWindow
{
        Q_OBJECT
 public:
        SummaryWindow(int minYear,
                      int minMonth,
                      int maxYear,
                      int maxMonth,
                      QWidget *parent = 0);
        ~SummaryWindow();
        void setSummaryData(SummaryData *data);

 private slots:
        void statisticsSelected();
        void itemsSelected();

 private:
        QAction *statistics;
        QAction *items;

        /* statistics stuff */
        QFrame *statsBox;
        QLabel *totalBudget;
        QLabel *totalExpense;
        QLabel *totalSaved;
        QLabel *minExpense;
        QLabel *maxExpense;
        QLabel *averageExpense;
        QLabel *minSaved;
        QLabel *maxSaved;
        QLabel *averageSaved;

        /* items stuff */
        ConceptsChart *chart;

        SummaryData *summaryData;

};
#endif
