#ifndef MONTHDATA_H
#define MONTHDATA_H

#include <QString>
#include <QObject>
#include <QVector>
#include <QStandardItemModel>
#include <QDate>
#include <QDebug>
#include "expense.h"
#include "global.h"

class MonthData : public QObject
{
        Q_OBJECT
 public:
        MonthData(QDate date,
                  double budget = DEFAULT_BUDGET);
        ~MonthData();

        int year();
        int month();
        int days();
        double budget();
        void setBudget(double budget);
        void addExpense(Expense *e);
        double maxExpense();
        double totalExpense();
        QStandardItemModel* expenses();
        const QVector<double>& summary();
        QDate next();
        QDate previous();
        bool isCurrent();
        QDate date();
        void clear();

 signals:
        void expensesChanged();
        void budgetChanged();

 private:

        QDate _date;
        double _budget;
        QVector<double> _summary;
        QStandardItemModel *_expenses;
        double _maxExpense;
        double _totalExpense;
};

#endif
