TEMPLATE = app
TARGET = siggy
DEPENDPATH += .
INCLUDEPATH += .
#OBJECTS_DIR = src
#MOC_DIR = src
#DESTDIR = src

# Input
HEADERS += global.h                   \
           dbmanager.h                \
           expense.h                  \
           concept.h                  \
           monthdata.h                \
           controller.h               \
           expensesgraph.h            \
           expensedetailsdialog.h     \
           budgetdialog.h             \
           conceptsdialog.h           \
           conceptdetailsdialog.h     \
           expenseslist.h             \
           scheduledlist.h            \
           scheduleddetailsdialog.h   \
           confirmationdialog.h       \
           mainwindow.h

SOURCES += dbmanager.cpp              \
           expense.cpp                \
           concept.cpp                \
           monthdata.cpp              \
           controller.cpp             \
           mainwindow.cpp             \
           expensesgraph.cpp          \
           expensedetailsdialog.cpp   \
           budgetdialog.cpp           \
           conceptsdialog.cpp         \
           conceptdetailsdialog.cpp   \
           expenseslist.cpp           \
           scheduledlist.cpp          \
           scheduleddetailsdialog.cpp \
           confirmationdialog.cpp     \
           main.cpp

QT+= sql maemo5

unix {
   #VARIABLES
   isEmpty(PREFIX) {
   PREFIX = /usr
}

BINDIR = $$PREFIX/bin
DATADIR =$$PREFIX/share
BACKUPDIR = /etc/osso-backup/applications

DEFINES += DATADIR=\"$$DATADIR\" PKGDATADIR=\"$$PKGDATADIR\"

#MAKE INSTALL

INSTALLS += target desktop backup i18n iconxpm icon26 icon48 icon64

  target.path =$$BINDIR

  desktop.path = $$DATADIR/applications/hildon
  desktop.files += ../data/desktop/$${TARGET}.desktop

  backup.path = $$BACKUPDIR
  backup.files += ../data/backup/$${TARGET}.conf

  i18n.path = $$DATADIR/$${TARGET}
  i18n.files += ../i18n/*.qm

  iconxpm.path = $$DATADIR/pixmaps
  iconxpm.files += ../data/icons/$${TARGET}.xpm

  icon26.path = $$DATADIR/icons/hicolor/26x26/apps
  icon26.files += ../data/icons/26x26/$${TARGET}.png

  icon48.path = $$DATADIR/icons/hicolor/48x48/apps
  icon48.files += ../data/icons/48x48/$${TARGET}.png

  icon64.path = $$DATADIR/icons/hicolor/64x64/apps
  icon64.files += ../data/icons/64x64/$${TARGET}.png
}
