#ifndef EXPENSEDETAILSDIALOG_H
#define EXPENSEDETAILSDIALOG_H

#include <QDialog>
#include <QLineEdit>
#include <QList>
#include <QDate>
#include "expense.h"
#include "concept.h"
#include <QDialogButtonBox>
#include <QMaemo5ValueButton>
#include <QStandardItemModel>
#include <QMaemo5ListPickSelector>

class ExpenseDetailsDialog : public QDialog
{
        Q_OBJECT
 public:
        ExpenseDetailsDialog(const QDate &date,
                             QStandardItemModel *concepts,
                             QWidget *parent = 0,
                             Qt::WindowFlags f = 0);

        ExpenseDetailsDialog(const QDate &date,
                             QStandardItemModel *concepts,
                             QStandardItemModel *expenses,
                             int row,
                             QWidget *parent = 0,
                             Qt::WindowFlags f = 0);

        ~ExpenseDetailsDialog();

 signals:
        void newExpenseConfirmed(Expense *e);
        void deleteExpenseConfirmed(Expense *e);
        void updateExpenseConfirmed(Expense *e);

 private slots:
        void conceptSelected(const QString &value);
        void checkValues();
        void deleteClicked();

 private:
        void buildUI (const QDate &date,
                      QStandardItemModel *concepts);

        QMaemo5ValueButton *day;
        QMaemo5ListPickSelector *daySelector;
        QLineEdit *amount;
        QMaemo5ValueButton *concept;
        QMaemo5ListPickSelector *conceptSelector;
        QLineEdit *description;
        int expenseId;
        QDialogButtonBox *box;
        bool newExpense;
};
#endif
