#ifndef DBMANAGER_H
#define DBMANAGER_H

#include <QObject>
#include <QSqlDatabase>
#include <QSqlError>
#include <QFile>
#include <QDir>
#include <QStandardItemModel>
#include "expense.h"
#include "concept.h"
#include "monthdata.h"

class DBManager : public QObject
{

 public:
        DBManager();
        ~DBManager();

        bool create(MonthData *month);
        bool load(MonthData *month, bool expensesOnly);
        bool exists(MonthData *month);
        bool updateBudget(int year, int month, double budget);

        bool create(int year, int month, Expense *e);
        bool update(Expense *e);
        bool remove(Expense *e);

        bool create(Concept *c);
        bool loadConcepts(QStandardItemModel *concepts);
        bool update(Concept *c);
        bool remove(Concept *c);
        bool exists(Concept *c);

        bool createScheduled(Expense *e);
        bool removeScheduled(Expense *e);
        bool loadScheduled(QStandardItemModel *scheduled);
        bool updateScheduled(Expense *e);

 private:
        bool createTables();
        void initDB();
        bool openDB();
        void closeDB();

        QSqlDatabase db;
};

#endif
