#ifndef CONTROLLER_H
#define CONTROLLER_H

#include <QObject>
#include <QDate>
#include <QList>
#include <QSettings>
#include "expense.h"
#include "monthdata.h"
#include "mainwindow.h"
#include "dbmanager.h"
#include "concept.h"

class Controller : public QObject
{
        Q_OBJECT
 public:
        Controller();
        ~Controller();

        void runApp();

 public slots:
        void previousMonth();
        void nextMonth();

        void newExpenseSelected();
        void newExpenseConfirmed(Expense *e);
        void expensesSelected();
        void expenseDetailsSelected(QModelIndex index);
        void deleteExpenseConfirmed(Expense *e);
        void updateExpenseConfirmed(Expense *e);

        void budgetSelected();
        void changeBudgetConfirmed(double budget, bool setDefault);

        void conceptsSelected();
        void newConceptSelected();
        void conceptDetailsSelected(const QModelIndex &index);
        void newConceptConfirmed(Concept *c);
        void deleteConceptConfirmed(Concept *c);
        void updateConceptConfirmed(Concept *c);

        void scheduledSelected();
        void newScheduledSelected();
        void newScheduledConfirmed(Expense *e);
        void scheduledDetailsSelected(QModelIndex index);
        void deleteScheduledConfirmed(Expense *e);
        void updateScheduledConfirmed(Expense *e);

 private:
        void loadMonth(bool reload = false);
        void loadConcepts();
        void loadScheduled();

        MonthData *month;
        QDate date;
        MainWindow mainWindow;
        DBManager db;
        QStandardItemModel *concepts;
        QStandardItemModel *scheduled;
        QSettings *settings;
};

#endif
