#include "conceptdetailsdialog.h"
#include <QHBoxLayout>
#include <QFormLayout>
#include <QDialogButtonBox>
#include <QDebug>
#include <QPushButton>
#include <QMaemo5InformationBox>

ConceptDetailsDialog::ConceptDetailsDialog(QStandardItemModel *concepts,
                                           int row,
                                           QWidget *parent,
                                           Qt::WindowFlags f)
        : QDialog (parent, f)
{
        _row = row;
        setWindowTitle(tr("Item details"));

        QHBoxLayout *layout = new QHBoxLayout (this);
        QFormLayout *form = new QFormLayout ();
        form->setHorizontalSpacing(50);
        layout->addLayout (form, 1);


        QLabel *name = new QLabel();
        form->addRow (new QLabel(tr("Name")), name);
        _price = new QLineEdit();
        conceptName = concepts->item(row, 0)->text();
        name->setText(conceptName);
        _price->setText(concepts->item(row, 1)->text());
        form->addRow (new QLabel(tr("Price")), _price);

        box = new QDialogButtonBox (QDialogButtonBox::Cancel, Qt::Vertical);
        QPushButton *saveButton = new QPushButton(tr("Save"));
        box->addButton(saveButton, QDialogButtonBox::ActionRole);
        QPushButton *deleteButton = new QPushButton(tr("Delete"));
        box->addButton(deleteButton, QDialogButtonBox::ActionRole);

        layout->addWidget (box, 0, Qt::AlignBottom);

        connect(box, SIGNAL(rejected()), this, SLOT(reject()));
        connect(saveButton, SIGNAL(clicked()), this, SLOT(saveClicked()));
        connect(deleteButton, SIGNAL(clicked()), this, SLOT(deleteClicked()));
}

ConceptDetailsDialog::ConceptDetailsDialog(QWidget *parent,
                                           Qt::WindowFlags f)
        : QDialog (parent, f)
{
        setWindowTitle(tr("Create new item"));

        QHBoxLayout *layout = new QHBoxLayout (this);
        QFormLayout *form = new QFormLayout ();
        form->setHorizontalSpacing(50);
        layout->addLayout (form, 1);

        _name = new QLineEdit();
        form->addRow (new QLabel(tr("Name")), _name);
        _price = new QLineEdit();
        form->addRow (new QLabel(tr("Price")), _price);

        box = new QDialogButtonBox (QDialogButtonBox::Cancel, Qt::Vertical);
        QPushButton *saveButton = new QPushButton(tr("Save"));
        box->addButton(saveButton, QDialogButtonBox::ActionRole);
        layout->addWidget (box, 0, Qt::AlignBottom);

        connect(box, SIGNAL(rejected()), this, SLOT(reject()));
        connect(saveButton, SIGNAL(clicked()), this, SLOT(newClicked()));
}

void ConceptDetailsDialog::saveClicked()
{
        if (_price->text() == "") {
                QMaemo5InformationBox::information(this, tr("Price field cannot be empty"));
                return;
        }

        double price = _price->text().toDouble();

        if (price <= 0) {
                QMaemo5InformationBox::information(this, tr("Invalid price format"));
                return;
        }

        emit updateConceptConfirmed(new Concept(conceptName, price));

        accept();
}

void ConceptDetailsDialog::deleteClicked()
{
        accept();
        emit deleteConceptConfirmed(new Concept(conceptName,0));
}

void ConceptDetailsDialog::newClicked()
{
        if (_name->text() == "") {
                QMaemo5InformationBox::information(this, tr("Name field cannot be empty"));
                return;
        }

        if (_price->text() == "") {
                QMaemo5InformationBox::information(this, tr("Price field cannot be empty"));
                return;
        }

        double price = _price->text().toDouble();

        if (price <= 0) {
                QMaemo5InformationBox::information(this, tr("Invalid price format"));
                return;
        }

        emit newConceptConfirmed(new Concept(_name->text(), price));

        accept();
}
