/*
 * Settings.h
 *
 *  Created on: Nov 2, 2009
 *      Author: oli
 */

#ifndef SETTINGS_H_
#define SETTINGS_H_

#include <QtCore/qobject.h>
#include <QSettings>

const QString COMPANY( "sibplayer" );
const QString PRODUCTNAME( "SiBPlayer" );
const QString PREFIX_SEARCHFOLDERS( "Folders" );
const QString PREFIX_FILES( "Files" );
const QString KEY_INIT( "initialized" );
const QString KEY_ZOOMENABLED( "zoom" );
const QString KEY_STRETCHENABLED( "stretch" );
const QString KEY_FRAMEDROPENABLED( "framedrop" );
const QString KEY_FOLDER( "folder" );
const QString KEY_FILENAME( "file" );
const QString KEY_FILEPOS( "resume" );
const QString DEFAULT_SEARCHFOLDER( "/home/user/MyDocs/.videos" );

class Settings : public QObject {
    Q_OBJECT

public:
    Settings( QObject* parent );
	virtual ~Settings();
	const QList<QString>& searchFolders();
    void addFolder( QString folder );
    void removeFolder( QString folder );
    void setZoomEnabled( bool enabled );
    bool zoomEnabled();
    void setStretchEnabled( bool enabled );
    bool stretchEnabled();
    void setFrameDropEnabled( bool enabled );
    bool frameDropEnabled();

private:

    void saveSettings();
    void loadSettings();

private:
        QList<QString> m_searchFolders;
        QSettings* m_settings;

        /// Flag that indicates if settings were stored before
        bool m_initialized;

        /// indicates if mplayer zoom is enabled
        bool m_zoomEnabled;

        /// indicates if mplayer stretch is enabled
        bool m_stretchEnabled;

        /// indicates if mplayer frame drop is enabled
        bool m_frameDropEnabled;
};

#endif /* SETTINGS_H_ */
