#include "settingsdlg.h"
#include <QFileDialog>
#include "SiBApplication.h"
#include "Settings.h"

SettingsDlg::SettingsDlg( QWidget *parent )
    : QDialog(parent)
{
    ui.setupUi(this);

    connect( ui.addFolderButton, SIGNAL( clicked() ),
        this, SLOT( addFolderButtonClicked() ) );
    connect( ui.removeFolderButton, SIGNAL( clicked() ),
        this, SLOT( removeFolderButtonClicked() ) );
    connect( ui.folderList, SIGNAL( cellClicked( int,int ) ),
        this, SLOT( cellClicked() ) );
    connect( ui.zoomCheckBox, SIGNAL( toggled( bool ) ),
        this, SLOT( zoomEnabled( bool ) ) );
    connect( ui.frameDropCheckBox, SIGNAL( toggled( bool ) ),
        this, SLOT( frameDropEnabled( bool ) ) );

    ui.zoomCheckBox->setChecked( SiBApplication::instance()->settings().zoomEnabled() );
    ui.frameDropCheckBox->setChecked( SiBApplication::instance()->settings().frameDropEnabled() );

    setupFolderList();
}

SettingsDlg::~SettingsDlg()
{

}

void SettingsDlg::addFolderButtonClicked()
{
    QString directory = QFileDialog::getExistingDirectory( this, tr( "Select Folder" ), QDir::currentPath() );
    if ( !directory.isEmpty() ) {
        SiBApplication::instance()->settings().addFolder( directory );
        setupFolderList();
    }
}

void SettingsDlg::removeFolderButtonClicked() {
    if ( ui.folderList->currentRow() >= 0 ) {
        SiBApplication::instance()->settings().removeFolder( ui.folderList->currentItem()->text() );
        setupFolderList();
        ui.removeFolderButton->setEnabled( false );
    }
}

void SettingsDlg::cellClicked()
{
    if ( ui.folderList->currentRow() >= 0 ) {
        ui.removeFolderButton->setEnabled( true );
    } else {
        ui.removeFolderButton->setEnabled( false );
    }
}

void SettingsDlg::zoomEnabled( bool enabled )
{
    SiBApplication::instance()->settings().setZoomEnabled( enabled );
}

void SettingsDlg::frameDropEnabled( bool enabled )
{
    SiBApplication::instance()->settings().setFrameDropEnabled( enabled );
}

void SettingsDlg::setupFolderList()
{
    ui.folderList->setRowCount( 0 );
    for ( int i = 0; i < SiBApplication::instance()->settings().searchFolders().count(); i++ ) {
        QTableWidgetItem* folderIdem = new QTableWidgetItem( tr("%1")
            .arg( SiBApplication::instance()->settings().searchFolders()[i] ) );
        folderIdem->setFlags( folderIdem->flags() ^ Qt::ItemIsEditable );

        int row = ui.folderList->rowCount();
        ui.folderList->insertRow( row );
        ui.folderList->setItem( row, 0, folderIdem );
    }
}

