/*
 * SiBApplication.cpp
 *
 *  Created on: Nov 2, 2009
 *      Author: oli
 */

#include "SiBApplication.h"
#include "filelist.h"
#include "videofile.h"
#include "playerfacade.h"
#include "filesearchdialog.h"

SiBApplication* SiBApplication::m_instance = NULL;

SiBApplication* SiBApplication::instance()
{
    if ( !m_instance )
    {
        m_instance = new SiBApplication();
    }
    return m_instance;
}

void SiBApplication::release()
{
    delete m_instance;
    m_instance = NULL;
}

SiBApplication::SiBApplication() {
    m_settings = new Settings( this );
    m_mainWindow = new MainWindow();
    m_fileList = new FileList( this );
    m_player = new PlayerFacade( this );
    connect( m_player, SIGNAL( playerStart() ), m_mainWindow, SLOT( playerStart() ) );
    connect( m_player, SIGNAL( playerStop() ), m_mainWindow, SLOT( playerStop() ) );

    m_mainWindow->setWindowTitle( tr( "SiB" ) );
}

SiBApplication::~SiBApplication() {
}

void SiBApplication::start() {
    m_mainWindow->show();
    updateFileList();
}


// ------------------------------------------------------------------------------
// Updates the list model.
// ------------------------------------------------------------------------------
//
void SiBApplication::updateFileList()
{
    FileSearchDialog progressDialog( m_mainWindow );
    progressDialog.show();

    m_fileList->searchFiles( m_settings->searchFolders(), progressDialog );

    // update UI
    refreshFileList();
}

// ------------------------------------------------------------------------------
// Refreshes the list model (only updating screen info/no folder scanning).
// ------------------------------------------------------------------------------
//
void SiBApplication::refreshFileList()
{
    m_mainWindow->updateFileList( m_fileList->files() );
}

// ------------------------------------------------------------------------------
// Sorts the list model.
// ------------------------------------------------------------------------------
//
void SiBApplication::sortFileList( FileList::SortCriteria criteria, Qt::SortOrder order )
{
    m_fileList->sortFileList( criteria, order );
    refreshFileList();
}

void SiBApplication::playFile( int idx )
{
    m_mainWindow->setFocus(); // prevents that lists or buttons in mainview grab key events
    m_player->playFile( m_fileList->file( idx ) );
}

void SiBApplication::restartFile( int idx )
{
    m_fileList->file( idx )->setResumePos( 0 );
    playFile( idx );
}

void SiBApplication::stopPlayer()
{
    m_player->stop();
}

bool SiBApplication::hasFileResumePos( int idx )
{
    if ( idx < 0 ) {
        return false;
    }
    return m_fileList->file( idx )->resumePos() / 10 != 0;
}

Settings& SiBApplication::settings()
{
    return *m_settings;
}

void SiBApplication::handleKeyEvent( QKeyEvent* event )
{
	if ( m_player->isPlayerRunning() ) {
		m_player->forwardKeyEvent( event );
	}
}

bool SiBApplication::isPlayerRunning()
{
	return m_player->isPlayerRunning();
}
