#include "filesearchdialog.h"
#include "ui_filesearchdialog.h"

FileSearchDialog::FileSearchDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::FileSearchDialog),
    m_canceled( false )
{
    ui->setupUi(this);
}

FileSearchDialog::~FileSearchDialog()
{
    delete ui;
}

void FileSearchDialog::setMaximum( int value )
{
    ui->progressBar->setMaximum( value );
}

int FileSearchDialog::maximum()
{
    return ui->progressBar->maximum();
}

void FileSearchDialog::setValue( int value )
{
    ui->progressBar->setValue( value );
}

int FileSearchDialog::value()
{
    return ui->progressBar->value();
}

bool FileSearchDialog::wasCanceled()
{
    return m_canceled;
}

void FileSearchDialog::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void FileSearchDialog::closeEvent ( QCloseEvent * e )
{
    QDialog::closeEvent( e );
    m_canceled = true;
}
