#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui>
#include <QPushButton>
#include <iostream>
#include <videofile.h>

using namespace std;

class Settings;
class QListWidget;

class MainWindow : public QWidget {
    Q_OBJECT;

    public:
        MainWindow();
        ~MainWindow();

        /**
         * Called on key events. Derived from QWidget.
         */
        void keyPressEvent ( QKeyEvent* event );

    public:
        void updateFileList( const QList<VideoFile*>& files );

    private slots:
        void playButtonPressed();
        void resumeButtonPressed();
        void settingsButtonPressed();
        void helpButtonPressed();
        void fileSelected( int row, int column );
        void cellClicked( int row, int column );
        void playerStart();
        void playerStop();

    private:
        QString toHHMMSS( unsigned int tenthOfASec );

    private:
        QTableWidget* m_fileList;
        QPushButton* m_playbutton;
        QPushButton* m_resumebutton;
};

#endif // MAINWINDOW_H
