#ifndef FILELIST_H
#define FILELIST_H

#include <QObject>
#include <QStringList>

class VideoFile;
class QDir;
class QFileInfo;
typedef QList<QFileInfo> QFileInfoList;

class FileList : public QObject
{
	Q_OBJECT;

public:
    FileList( QObject* parent );
    ~FileList();

public:
    void searchFiles( const QList<QString>& searchFolders );
    const QList<VideoFile*>& files();
    VideoFile* file( int idx );

private:

    void updateFileList( const QFileInfoList& files );

    /**
     * Searches files recursively in given dir.
     */
    void getFilesInDir( const QDir& dir, QFileInfoList& fileList );

    void loadFileList();
    void saveFileList();

private:
    QList<VideoFile*> m_files;
    QStringList m_knownExtensions;
};

#endif // FILELIST_H
