#!/bin/sh
# python2.5 /usr/lib/hildon-desktop/shutter.py

APP_TITLE = "Shutter"
APP_VERSION = "1.1"

import gobject
import gtk
import hildondesktop
import hildon
import os
import cairo
import osso
import string
import time 
import gconf
import dbus

import subprocess
import datetime

APP_NAME = APP_TITLE.lower()
LOGO = '/opt/tomch.com/shutter/%s.png' % APP_NAME
GCONFPATH = "/apps/Maemo/tomch.com/%s" % APP_NAME


class ShutterHomePlugin(hildondesktop.HomePluginItem):
  defaultCAMERA = "Nikon"
  
  def __init__(self):
    hildondesktop.HomePluginItem.__init__(self)
    self.set_settings(True)
    self.connect("show-settings", self.show_options)

    self.isStopped = True 
    self.update_info()
    self.transparency = 0.0

    #Load the settings using GConf
    conf_client = gconf.client_get_default()
    conf_client.add_dir(GCONFPATH, gconf.CLIENT_PRELOAD_NONE)
    self.CAMERA=conf_client.get_string(GCONFPATH+"/camera")

    #Fallback to default on first launch
    if not self.CAMERA:
      self.CAMERA=self.defaultCAMERA     
   

  def update_info(self, widget=None):

    self.osso_context = osso.Context("com.tomch.shutter", str(APP_VERSION), False)
    self.osso_rpc = osso.Rpc(self.osso_context)
   
    self.hbox = gtk.HBox()
    self.vbox = gtk.VBox()
    self.e_eventbox = gtk.EventBox()
    self.e_eventbox.set_size_request(64, 72) 
    self.e_eventbox.set_events(gtk.gdk.BUTTON_PRESS_MASK)
    self.e_eventbox.connect("button-release-event", self.on_toggle)
    self.hbox.pack_start(self.e_eventbox, True, True, 10)
    self.hbox.show_all()
    self.add(self.hbox)
    
  def do_expose_event(self, event):
    cr = self.window.cairo_create()
    cr.set_source_rgba(1.0, 1.0, 1.0, self.transparency) # Transparent
    cr.set_operator(cairo.OPERATOR_SOURCE)
    cr.paint()   

    # Paint icon for eventbox
    self.draw_e("shutter.png")

    # draw rounded rect
    width, height = self.allocation[2], self.allocation[3]
    
    x0 = 0
    y0 = 0
    radius = min(15, width/2, height/2)  #/*< and an approximate curvature radius */
    x1 = x0 + width
    y1 = y0 + height 
    
    cr.move_to  (x0, y0 + radius)
    cr.arc (x0 + radius, y0 + radius, radius, 3.14, 1.5 * 3.14)
    cr.line_to (x1 - radius, y0)
    cr.arc (x1 - radius, y0 + radius, radius, 1.5 * 3.14, 0.0)
    cr.line_to (x1 , y1 - radius)
    cr.arc (x1 - radius, y1 - radius, radius, 0.0, 0.5 * 3.14)
    cr.line_to (x0 + radius, y1)
    cr.arc (x0 + radius, y1 - radius, radius, 0.5 * 3.14, 3.14)
    cr.close_path ()

    cr.set_source_rgba (0.0, 0.0, 0.0, self.transparency)
    cr.fill_preserve ()
    return False

  def draw_e(self,icon):
    cr_e = self.e_eventbox.window.cairo_create()
    cr_e.set_source_rgba(0.0, 0.0, 0.0, self.transparency) # Transparent
    cr_e.set_operator(cairo.OPERATOR_SOURCE)
    cr_e.paint()
    
    cr_e.set_operator(cairo.OPERATOR_OVER)
    image = cairo.ImageSurface.create_from_png("/opt/tomch.com/shutter/" + icon)
    cr_e.set_source_surface(image, 0, 7)
    cr_e.paint()
    self.cr_e = cr_e
    while gtk.events_pending():
      gtk.main_iteration()
          
  def do_realize(self):
    screen = self.get_screen()
    colormap = screen.get_rgba_colormap()
    self.set_colormap(colormap)
    hildondesktop.HomePluginItem.do_realize(self) 

  def on_toggle(self, button, data=None):
    self.draw_e("shutter-grey.png")     

    #DO LIRC
    remote = "NikonDSLR"   #<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< Configure the name of your remote here (check available remotes with: irsend list "" ""
    code = "shutter"    #<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< Configure the name of your remote command here (available commands: look into the whateveryourremote.
    if self.CAMERA == 'Canon':
      remote = "CANON-RC1/RC5"   #<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< Configure the name of your remote here (check available remotes with: irsend list "" ""
      code = "S"    #<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< Configure the name of your remote command here (available commands: look into the whateveryourremote.
    elif self.CAMERA == 'Olympus':
      remote = "Olympus_RM-2"   #<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< Configure the name of your remote here (check available remotes with: irsend list "" ""
      code = "CAPTURE"    #<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< Configure the name of your remote command here (available commands: look into the whateveryourremote.
    elif self.CAMERA == 'Pentax':
      remote = "Pentax_RC-F"   #<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< Configure the name of your remote here (check available remotes with: irsend list "" ""
      code = "CAPTURE"    #<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< Configure the name of your remote command here (available commands: look into the whateveryourremote.
    #elif self.CAMERA == 'Sony':
    #  remote = "NikonDSLR"   #<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< Configure the name of your remote here (check available remotes with: irsend list "" ""
    #  code = "shutter"    #<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< Configure the name of your remote command here (available commands: look into the whateveryourremote.
          
    start = time.time()
    print "\n___" + datetime.datetime.now().strftime("%H:%M:%S") + "____________________________________"
    print "Running as User " + os.getenv("LOGNAME")
    
    #Check if Lircd runs
    #print subprocess.Popen(["pgrep", "lircd"], stdout=subprocess.PIPE).communicate()[0]
    lircdPID = subprocess.Popen(["pgrep", "lircd"], stdout=subprocess.PIPE).communicate()[0]
    if lircdPID == "":
      lircdPID = 0
      
    stopLircdOnEnd = True
    #print "Lircd process ID: " + str(lircdPID)
    if lircdPID > 0:
        message = "LIRCD already started: PID %d\n" % int(lircdPID) 
        print message  
        stopLircdOnEnd = False
    else:
        #Start if it doesn't
        message = "LIRCD started for " + os.getenv("LOGNAME")
        print message
        arg = []
        if os.getenv("LOGNAME") == "root": #For remote debugging through SSH as root
          arg = ["/etc/init.d/lirc", "start"]
        else:
          arg = ["sudo", "/etc/init.d/lirc", "start"]
        lircdstart = subprocess.Popen(arg)
        lircdstart.wait()
              
    # lircd is now started, so try and transmit
    start = time.time()
    print "Sending",remote,code 
    
    #Patch suggestion from Access(jfors). Unused here, as I fixed something in the postinstall instead (lirc restart instead of reload)
    #irsend = subprocess.Popen(('/usr/bin/irsend', '-a', 'localhost:8765', 'send_once', remote, code),
    irsend = subprocess.Popen(('/usr/bin/irsend', 'send_once', remote, code),
                              stdin = subprocess.PIPE)
    irsend.stdin.close()
    irsend.wait()
    if irsend.returncode != 0:
        message = "IRsend failed: %d (Please reboot and try again)" % irsend.returncode
    else:
        message = "IRsend took %d seconds (%s:%s)" %( (time.time() - start) , remote, code)
    print message
    
    if stopLircdOnEnd == True:
      #We launched it, so we need to stop it again
      if os.getenv("LOGNAME") == "root": #For remote debugging through SSH as root
        lircdstop = subprocess.Popen(["/etc/init.d/lirc", "stop"])
      else:
        lircdstop = subprocess.Popen(["sudo", "/etc/init.d/lirc", "stop"]) 
      lircdstop.wait()  
      print "LIRCD stopped."

    banner = hildon.hildon_banner_show_information(self, '', APP_TITLE+': ' + message)
    banner.set_timeout(2000)

    #banner = hildon.hildon_banner_show_information(self, '', APP_TITLE+': ' + self.CAMERA)
    #banner.set_timeout(2000)
    #time.sleep(0.5)
    self.draw_e("shutter.png")

  
  #Setup the main options/settings dialogue (the one accessible through the tool icon when in Hildon Desktop Edit mode)
  def show_options(self, widget):
      dialog = gtk.Dialog("%s Options" % APP_TITLE, None, gtk.DIALOG_DESTROY_WITH_PARENT)

      settings_button = hildon.Button(gtk.HILDON_SIZE_HALFSCREEN_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
      settings_button.set_text("Settings", "Change the camera type")
      settings_button.set_alignment(0,0,0,0)
      settings_button.connect('clicked', self.show_settings)
              
      help_button = hildon.Button(gtk.HILDON_SIZE_HALFSCREEN_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
      help_button.set_text("Help", "Get help on how to use %s" % APP_TITLE)
      help_button.set_alignment(0,0,0,0)
      help_button.connect('clicked', self.open_help) 
      
      about_button = hildon.Button(gtk.HILDON_SIZE_HALFSCREEN_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
      about_button.set_text("About", "More about Author, Copyright and License")
      about_button.set_alignment(0,0,0,0)
      about_button.connect("clicked", self.show_about)

      donate_button = hildon.Button(gtk.HILDON_SIZE_HALFSCREEN_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
      donate_button.set_text("Donate", "Like the software? Support the effort :-)")
      donate_button.set_alignment(0,0,0,0)
      donate_button.connect('clicked', self.open_donate)

      line1 = gtk.HBox()
      line2 = gtk.HBox()        
      line1.pack_start(settings_button, True, True, 0)
      line1.pack_start(help_button, True, True, 0)
      line2.pack_start(about_button, True, True, 0)
      line2.pack_start(donate_button, True, True, 0)
      dialog.vbox.pack_start(line1, True, True, 0)  
      dialog.vbox.pack_start(line2, True, True, 0)  
       
      dialog.show_all()
      dialog.run()
      dialog.destroy()
  
  #Link to a help page on the maemo wiki    
  def open_help(self, widget): 
      self.osso_rpc.rpc_run_with_defaults("osso_browser", "open_new_window", ("http://wiki.maemo.org/"+APP_TITLE,))

  #Link to a donation page using PayPal    
  def open_donate(self, widget):
      self.osso_rpc.rpc_run_with_defaults("osso_browser", "open_new_window", ("https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=NJ4HVUZKB2CZY",))                
  
  #Setup the settings UI , store changed parameters  
  def show_settings(self, widget):
      dialog = gtk.Dialog("Settings", None, gtk.DIALOG_DESTROY_WITH_PARENT | gtk.DIALOG_NO_SEPARATOR)
      btnSave = dialog.add_button(gtk.STOCK_SAVE, gtk.RESPONSE_OK)
      
      main_vbox = gtk.VBox()
      ts = hildon.TouchSelector()
      ts.add(main_vbox)
      
      btnNikon = hildon.GtkRadioButton(gtk.HILDON_SIZE_HALFSCREEN_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, None)
      btnNikon.set_label("Nikon")
      btnNikon.set_mode(False)
      btnCanon = hildon.GtkRadioButton(gtk.HILDON_SIZE_HALFSCREEN_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, btnNikon)
      btnCanon.set_label("Canon")
      btnCanon.set_mode(False)
      btnOlympus = hildon.GtkRadioButton(gtk.HILDON_SIZE_HALFSCREEN_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, btnNikon)
      btnOlympus.set_label("Olympus")
      btnOlympus.set_mode(False)
      btnPentax = hildon.GtkRadioButton(gtk.HILDON_SIZE_HALFSCREEN_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, btnNikon)
      btnPentax.set_label("Pentax")
      btnPentax.set_mode(False)
      #btnSony = hildon.GtkRadioButton(gtk.HILDON_SIZE_HALFSCREEN_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, btnNikon)
      #btnSony.set_label("Sony")
      #btnSony.set_mode(False)
      
      if self.CAMERA == 'Nikon':
         btnNikon.set_active(True)
      elif self.CAMERA == 'Canon':
         btnCanon.set_active(True)
      elif self.CAMERA == 'Olympus':
         btnOlympus.set_active(True)
      elif self.CAMERA == 'Pentax':
         btnPentax.set_active(True)
      #elif self.CAMERA == 'Sony':
      #   btnSony.set_active(True)
      else:
         btnNikon.set_active(True)  #Fallback
         
      hBoxLayout = gtk.HBox()
      hBoxLayout.pack_start(btnCanon, True, True, 0)
      hBoxLayout.pack_start(btnNikon, True, True, 0)
      hBoxLayout.pack_start(btnOlympus, True, True, 0)
      hBoxLayout.pack_start(btnPentax, True, True, 0)
      #hBoxLayout.pack_end(btnSony, True, True, 0)
      main_vbox.pack_start(hBoxLayout, True, True, 10)

      dialog.vbox.add(ts)
      dialog.show_all()
      response = dialog.run()
             
      #Parse the updated settings        
      if response == gtk.RESPONSE_OK:
         camera_buttons = btnNikon.get_group()
         for button in camera_buttons:
            selected = button.get_active()
            if selected == True:
               self.CAMERA = button.get_label()
               break
               
         #Store the updated settings
         conf_client = gconf.client_get_default()
         conf_client.add_dir(GCONFPATH, gconf.CLIENT_PRELOAD_NONE)
         try:
           conf_client.set_string(GCONFPATH+"/camera", self.CAMERA)
         except Exception:
           self.log('Unable to save settings in GConf.')
      
      dialog.destroy()
  
  #Show the about dialog    
  def show_about(self, widget):
      dialog = gtk.AboutDialog()
      dialog.set_title("About")
      dialog.set_name(APP_TITLE)
      dialog.set_version(APP_VERSION)
      dialog.set_copyright("Copyright 2010 Tom Waelti")
      dialog.set_authors(["Tom Waelti <twaelti@gmail.com>",""])
      dialog.set_logo(gtk.gdk.pixbuf_new_from_file(LOGO))
      dialog.set_comments("All logos and trademarks are property of their respective owners and are used for informational purposes only.")
      #dialog.set_license("GPL 3")
      dialog.set_license("""This program is free software: you can redistribute it and/or
modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

You should have received a copy of the GNU General Public 
License along with this program.  If not, see
<http://www.gnu.org/licenses/>.""")
      dialog.set_wrap_license(True)
      dialog.show_all()
      dialog.run()
      dialog.destroy() 

  #Log and/or display banner     
  def log(self, message, *args, **kwargs):
      print time.strftime('%H:%M:%S'), '- '+APP_TITLE+':', message % args
      #if kwargs.get('show_banner', False) or self.SHOWBANNER:
      #if self.SHOWBANNER:
      #    banner = hildon.hildon_banner_show_information(self, '', APP_TITLE+': ' + message%args)
      #    banner.set_timeout(2000)

            
hd_plugin_type = ShutterHomePlugin

if __name__ == "__main__":
    gobject.type_register(hd_plugin_type)
    obj = gobject.new(hd_plugin_type, plugin_id="plugin_id")
    obj.show_all()
    gtk.main()
