#TODO: make sure that lircd is running, else start it!
#sudo /etc/init.d/lirc restart

#Run it manually:
# cd /usr/lib/hildon-desktop
# python2.5 shutter.py

# TODO POSTINSTALL
# Add the config line entry to lirc.config 
# echo "include \"/etc/lirc/ML-L3+\"" >> /etc/lircd.conf
# Reload lircd to make sure the new config is known
# /etc/init.d/lirc reload

import gtk
import pygtk
import hildon
import hildondesktop
import subprocess
import datetime
import time
import os

def on_button_press_event(widget, button):
   
    #Install QTirreco, then use it to download the desired remote and browse for the command to be issued by the shutter widget
    #For the Nikon shutters, I installed http://lirc.sourceforge.net/remotes/nikon/ML-L3 
    remote = "NikonDSLR"   #<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< Configure the name of your remote here (check available remotes with: irsend list "" ""
    code = "shutter"    #<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< Configure the name of your remote command here (available commands: look into the whateveryourremote.

    start = time.time()
    print "\n___" + datetime.datetime.now().strftime("%H:%M:%S") + "____________________________________"
    print "Running as User " + os.getenv("LOGNAME")
    
    #Check if Lircd runs
    #print subprocess.Popen(["pgrep", "lircd"], stdout=subprocess.PIPE).communicate()[0]
    lircdPID = subprocess.Popen(["pgrep", "lircd"], stdout=subprocess.PIPE).communicate()[0]
    if lircdPID == "":
      lircdPID = 0
      
    stopLircdOnEnd = True
    #print "Lircd process ID: " + str(lircdPID)
    if lircdPID > 0:
        message = "LIRCD already started: PID %d\n" % int(lircdPID) 
        print message  
        stopLircdOnEnd = False
    else:
        #Start if it doesn't
        message = "LIRCD started for " + os.getenv("LOGNAME")
        print message
        arg = []
        if os.getenv("LOGNAME") == "root": #For remote debugging through SSH as root
          arg = ["/etc/init.d/lirc", "start"]
        else:
          arg = ["sudo", "/etc/init.d/lirc", "start"]
        lircdstart = subprocess.Popen(arg)
        lircdstart.wait()
  
              
    # lircd is now started, so try and transmit
    start = time.time()
    irsend = subprocess.Popen(('/usr/bin/irsend', 'send_once', remote, code),
                              stdin = subprocess.PIPE)
    irsend.stdin.close()
    irsend.wait()
    if irsend.returncode != 0:
        message = "IRsend failed: %d\n" % irsend.returncode
    else:
        message = "IRsend took %d seconds (%s:%s)\n" %( (time.time() - start) , remote, code)
    print message
   
    
    if stopLircdOnEnd == True:
      #We launched it, so we need to stop it again
      if os.getenv("LOGNAME") == "root": #For remote debugging through SSH as root
        lircdstop = subprocess.Popen(["/etc/init.d/lirc", "stop"])
      else:
        lircdstop = subprocess.Popen(["sudo", "/etc/init.d/lirc", "stop"]) 
      lircdstop.wait()  
      print "LIRCD stopped."
      
    banner = hildon.hildon_banner_show_information(widget, "", "shutter: " + message)
    banner.set_timeout(2000)

    
class ShutterHomePlugin(hildondesktop.HomePluginItem):
  def __init__(self):
    hildondesktop.HomePluginItem.__init__(self)

    #Draw the widget button
    button = gtk.Button()
 
    box = gtk.HBox(False, 0)
    box.set_border_width(0)
    image = gtk.Image()
    image.set_from_file("/usr/share/icons/hicolor/48x48/hildon/shutter.png")
    box.pack_start(image, False, False, 3)
    image.show()
    button.add(box)
    box.show()

    button.connect("button-press-event", on_button_press_event)

    button.show_all()
    self.set_opacity(0.5)
    self.add(button)

        
hd_plugin_type = ShutterHomePlugin

# The code below is just for testing purposes.
# It allows to run the widget as a standalone process.
if __name__ == "__main__":
    import gobject
    gobject.type_register(hd_plugin_type)
    obj = gobject.new(hd_plugin_type, plugin_id="plugin_id")
    obj.show_all()
    gtk.main()

    