#include <QObject>
#include <QMaemo5InformationBox>
#include <QFile>
#include <QDir>
#include <QDebug>
#include <QProcess>
#include <QTextStream>

#include "datadownloader.h"
#include "zafiles.h"

ZAFiles::ZAFiles(QObject *parent) : DataDownloader(parent, "/opt/showtime/data/za/"), HELPERPATH("/opt/showtime/helper/")
{
	_settingsFile = new QFile(QString(DATAPATH) + ".za");
	_channelFile = QString(DATAPATH) + ".za_channel_list";
	initSettings();
}

void ZAFiles::initSettings()
{
	// just call the parent init settings
	// nothing specific to ZA
	DataDownloader::initSettings();
}

QUrl ZAFiles::getUrl()
{
	QUrl url;

	QString requestChannelCode = _channelCodeMap[_requestChannel];

	if ( !_useLocal )
		url.setUrl(QString("http://zaxmltv.flash.za.org/schedule/ZA-XMLTV.xml.gz?APP=SHOWTIME") );
	else
		url.setPath(QString(""));

	return url;
}

ZAFiles::~ZAFiles()
{
}

QString ZAFiles::finishedDownload(QString channel, QIODevice *source)
{
	channel = "dummy";
	QString filename = saveZipFile(channel, source);

	// this method will split the huge single xml file per channel
	// be patient this takes time
	splitXMLTVFile(filename);

	return filename;
}

void ZAFiles::setInput(DownloadInput d)
{
	DataDownloader::setInput(d);
}

void ZAFiles::sendRecordMsg(QStringList data)
{
}

void ZAFiles::sentRecordMsg(int exitCode, QProcess::ExitStatus exitStatus)
{
}
