#include <QObject>
#include <QMaemo5InformationBox>
#include <QFile>
#include <QDir>
#include <QDebug>
#include <QProcess>
#include <QTextStream>
#include <QDesktopServices>

#include "datadownloader.h"
#include "ukfiles.h"

UKFiles::UKFiles(QObject *parent) : DataDownloader(parent, "/opt/showtime/data/uk/"), HELPERPATH("/opt/showtime/helper/")
{
	_settingsFile = new QFile(QString(DATAPATH) + ".uk");
	_channelFile = QString(DATAPATH) + QString(".uk_channel_list");
	initSettings();
}

void UKFiles::initSettings()
{
	// just call the parent init settings
	// nothing specific to UK
	DataDownloader::initSettings();
}

QUrl UKFiles::getUrl()
{
	QUrl url;

	QString requestChannelCode = _channelCodeMap[_requestChannel];

	if ( !_useLocal )
		url.setUrl(QString("http://www.xmltvepg.nl/rytecxmltvuk.gz?APP=SHOWTIME") );
	else
		url.setPath(QString(""));

	return url;
}

UKFiles::~UKFiles()
{
}

QString UKFiles::finishedDownload(QString channel, QIODevice *source)
{
	channel = "dummy";
	QString filename = saveZipFile(channel, source); // file will be saved as uk--<currentDate>--.xml

	// this method will split the huge single xml file per channel
	// be patient this takes time
	splitXMLTVFile(filename);

	return filename;
}

void UKFiles::setInput(DownloadInput d)
{
	DataDownloader::setInput(d);
}

void UKFiles::sendRecordMsg(QStringList data)
{
	QDesktopServices::openUrl(QUrl("sms:61759?body=" + data[0]));
	sleep(1);
	QDesktopServices::openUrl(QUrl("sms:61759?body=" + data[0]));
}

void UKFiles::sentRecordMsg(int exitCode, QProcess::ExitStatus exitStatus)
{
}
