#include <QObject>
#include <QMaemo5InformationBox>
#include <QFile>
#include <QDir>
#include <QDebug>
#include <QProcess>
#include <QTextStream>

#include "datadownloader.h"
#include "skfiles.h"

SKFiles::SKFiles(QObject *parent) : DataDownloader(parent, "/opt/showtime/data/sk/"), HELPERPATH("/opt/showtime/helper/")
{
	_settingsFile = new QFile(QString(DATAPATH) + ".sk");
	_channelFile = QString(DATAPATH) + ".sk_channel_list";
	initSettings();
}

void SKFiles::initSettings()
{
	// just call the parent init settings
	// nothing specific to SK(germany)
	DataDownloader::initSettings();
}

QUrl SKFiles::getUrl()
{
	QUrl url;

	QString requestChannelCode = _channelCodeMap[_requestChannel];

	if ( !_useLocal )
		url.setUrl(QString("http://frantisheq.sk/xmltv/sk/CET_sk.xmltv?APP=SHOWTIME") );
	else
		url.setPath(QString(""));

	return url;
}

SKFiles::~SKFiles()
{
}

QString SKFiles::finishedDownload(QString channel, QIODevice *source)
{
	channel = "dummy";
	QString filename = saveFile(channel, source); 

	// this method will split the huge single xml file per channel
	// be patient this takes time
	splitXMLTVFile(filename);

	return filename;
}

void SKFiles::setInput(DownloadInput d)
{
	DataDownloader::setInput(d);
}

void SKFiles::sendRecordMsg(QStringList data)
{
}

void SKFiles::sentRecordMsg(int exitCode, QProcess::ExitStatus exitStatus)
{
}
