#ifndef SEFILES_H
#define SEFILES_H

#include <QObject>
#include <QStringList>
#include <QSet>
#include <QUrl>
#include <QMap>
#include <QProcess>

class QIODevice;

#include "datadownloader.h"

class SEFiles : public DataDownloader
{
    Q_OBJECT

public:
    SEFiles( QObject *parent );
    virtual ~SEFiles();
	virtual QUrl getUrl();
	void initSettings();
	virtual void setInput(DownloadInput d);
	virtual QString finishedDownload(QString channel, QIODevice *source);
	void sendRecordMsg(QStringList data);
	virtual bool isSingleXMLTVFile() { return false; }

signals:

public slots:

private slots:
	void sentRecordMsg(int exitCode, QProcess::ExitStatus exitStatus);

protected:
	void updateDownloadIndexes();

private:
	const char* HELPERPATH;
};

#endif // SEFILES_H
