#include <QObject>
#include <QMaemo5InformationBox>
#include <QFile>
#include <QDir>
#include <QDebug>
#include <QProcess>
#include <QTextStream>

#include "datadownloader.h"
#include "sefiles.h"

SEFiles::SEFiles(QObject *parent) : DataDownloader(parent, "/opt/showtime/data/se/"), HELPERPATH("/opt/showtime/helper/")
{
	_settingsFile = new QFile(QString(DATAPATH) + ".se");
	_channelFile = QString(DATAPATH) + ".se_channel_list";
	initSettings();
}

void SEFiles::initSettings()
{
	// just call the parent init settings
	// nothing specific to se
	DataDownloader::initSettings();
}

QUrl SEFiles::getUrl()
{
	QUrl url;

	QString requestChannelCode = _channelCodeMap[_requestChannel];

	if ( !_useLocal )
		url.setUrl(QString("http://xmltv.tvsajten.com/xmltv/%1_%2.xml.gz?APP=SHOWTIME")
                                                            .arg(requestChannelCode).arg(_requestDate.toString("yyyy-MM-dd")) );
	else
		url.setPath(QString(""));

	return url;
}

SEFiles::~SEFiles()
{
}

QString SEFiles::finishedDownload(QString channel, QIODevice *source)
{
	QString filename = saveFile(channel, source);
	return filename;
}

void SEFiles::setInput(DownloadInput d)
{
	DataDownloader::setInput(d);
}

void SEFiles::sendRecordMsg(QStringList data)
{
}

void SEFiles::sentRecordMsg(int exitCode, QProcess::ExitStatus exitStatus)
{

}
