#include <QObject>
#include <QMaemo5InformationBox>
#include <QFile>
#include <QDir>
#include <QDebug>
#include <QProcess>
#include <QTextStream>

#include "datadownloader.h"
#include "rufiles.h"

RUFiles::RUFiles(QObject *parent) : DataDownloader(parent, "/opt/showtime/data/ru/"), HELPERPATH("/opt/showtime/helper/")
{
	_settingsFile = new QFile(QString(DATAPATH) + ".ru");
	_channelFile = QString(DATAPATH) + ".ru_channel_list";
	initSettings();
}

void RUFiles::initSettings()
{
	// just call the parent init settings
	// nothing specific to RU
	DataDownloader::initSettings();
}

QUrl RUFiles::getUrl()
{
	QUrl url;

	QString requestChannelCode = _channelCodeMap[_requestChannel];

	if ( !_useLocal )
		url.setUrl(QString("http://www.teleguide.info/download/new3/xmltv.xml.gz?APP=SHOWTIME") );
	else
		url.setPath(QString(""));

	return url;
}

RUFiles::~RUFiles()
{
}

QString RUFiles::finishedDownload(QString channel, QIODevice *source)
{
	channel = "dummy";
	QString filename = saveFile(channel, source); 

	// this method will split the huge single xml file per channel
	// be patient this takes time
	splitXMLTVFile(filename);

	return filename;
}

void RUFiles::setInput(DownloadInput d)
{
	DataDownloader::setInput(d);
}

void RUFiles::sendRecordMsg(QStringList data)
{
}

void RUFiles::sentRecordMsg(int exitCode, QProcess::ExitStatus exitStatus)
{
}
