#ifndef INFOACCESS_H
#define INFOACCESS_H

#include <QObject>
#include <QStringList>
#include <QSet>
#include <QMap>
#include <QUrl>
#include "datadownloader.h"

class QNetworkReply;
class DataDownloader;

// struct to hold data for each programme of the channel
struct ChannelData
{
    QString channelId;
    QString date;
    QString sdate;
    QString stime;
    QString edate;
    QString etime;
	QString title;
    QString type;
    QString desc;
};

struct ChannelMetaData
{
	QString minDate;           // min date for which data is available
	QString maxDate;           // max date for which data is available
	QString downloadedDate;    // date on which data was downloaded
	QSet<QString> availableDates; // list of dates available for per day channels
};

class InfoAccess : public QObject
{
    Q_OBJECT

public:
    InfoAccess( QObject *parent, QString region="UK");
	void clear();
    virtual ~InfoAccess();
	void setUrl(QUrl url);
    QMap<QString, QList<ChannelData> > results() const;
    QMap<QString, ChannelMetaData> metadata() const;
	QStringList getChannelList();
	void sendRecordMsg(QStringList input);
    bool processXMLTV( QString filename );
	bool isSingleXMLTVFile();
	void clearRegionData() { dataDownloader->clearRegionData(); }
	QDate getDownloadDate();

signals:
    void finished( bool success );

public slots:
    bool getChannelInfo(DownloadInput& input);

private slots:
	void finishedDownload( QNetworkReply *reply );

private:
    bool processXMLTV();
    void downloadXMLTV();

    struct InfoAccessPrivate *d;
	DataDownloader *dataDownloader;

	QString	_currentChannel;

	QString _region;
};

#endif // INFOACCESS_H
