#ifndef IEFILES_H
#define IEFILES_H

#include <QObject>
#include <QStringList>
#include <QSet>
#include <QUrl>
#include <QMap>
#include <QProcess>

class QIODevice;

#include "datadownloader.h"

class IEFiles : public DataDownloader
{
    Q_OBJECT

public:
    IEFiles( QObject *parent );
    virtual ~IEFiles();
	virtual QUrl getUrl();
	void initSettings();
	virtual void setInput(DownloadInput d);
	virtual QString finishedDownload(QString channel, QIODevice *source);
	void sendRecordMsg(QStringList data);
	virtual int timeZoneOffset() { return -1; } // return -1 since data is generated in belgium which is 1 hr ahead of IE

signals:

public slots:

private slots:
	void sentRecordMsg(int exitCode, QProcess::ExitStatus exitStatus);

protected:
	void updateDownloadIndexes();

private:
	const char* HELPERPATH;
};

#endif // IEFILES_H
