#include <QObject>
#include <QMaemo5InformationBox>
#include <QFile>
#include <QDir>
#include <QDebug>
#include <QProcess>
#include <QTextStream>

#include "datadownloader.h"
#include "fifiles.h"

FIFiles::FIFiles(QObject *parent) : DataDownloader(parent, "/opt/showtime/data/fi/"), HELPERPATH("/opt/showtime/helper/")
{
	_settingsFile = new QFile(QString(DATAPATH) + ".fi");
	_channelFile = QString(DATAPATH) + ".fi_channel_list";
	initSettings();
}

void FIFiles::initSettings()
{
	// just call the parent init settings
	// nothing specific to FI
	DataDownloader::initSettings();
}

QUrl FIFiles::getUrl()
{
	QUrl url;

	QString requestChannelCode = _channelCodeMap[_requestChannel];

	if ( !_useLocal )
		url.setUrl(QString("http://www.xmltvepg.nl/rytecxmltvnordic.gz?APP=SHOWTIME"));
	else
		url.setPath(QString(""));

	return url;
}

FIFiles::~FIFiles()
{
}

QString FIFiles::finishedDownload(QString channel, QIODevice *source)
{
	channel = "dummy";
	QString filename = saveZipFile(channel, source); 

	// this method will split the huge single xml file per channel
	// fi patient this takes time
	splitXMLTVFile(filename);

	return filename;
}

void FIFiles::setInput(DownloadInput d)
{
	DataDownloader::setInput(d);
}

void FIFiles::sendRecordMsg(QStringList data)
{
}

void FIFiles::sentRecordMsg(int exitCode, QProcess::ExitStatus exitStatus)
{
}
