#include <QObject>
#include <QMaemo5InformationBox>
#include <QFile>
#include <QDir>
#include <QDebug>
#include <QProcess>
#include <QTextStream>

#include "datadownloader.h"
#include "defiles.h"

DEFiles::DEFiles(QObject *parent) : DataDownloader(parent, "/opt/showtime/data/de/"), HELPERPATH("/opt/showtime/helper/")
{
	_settingsFile = new QFile(QString(DATAPATH) + ".de");
	_channelFile = QString(DATAPATH) + ".de_channel_list";
	initSettings();
}

void DEFiles::initSettings()
{
	// just call the parent init settings
	// nothing specific to DE(germany)
	DataDownloader::initSettings();
}

QUrl DEFiles::getUrl()
{
	QUrl url;

	QString requestChannelCode = _channelCodeMap[_requestChannel];

	if ( !_useLocal )
		url.setUrl(QString("http://www.xmltvepg.nl/rytecxmltvskyde.gz?APP=SHOWTIME") );
	else
		url.setPath(QString(""));

	return url;
}

DEFiles::~DEFiles()
{
}

QString DEFiles::finishedDownload(QString channel, QIODevice *source)
{
	channel = "dummy";
	QString filename = saveZipFile(channel, source); // file will be saved as dummy--<currentDate>--.xml

	// this method will split the huge single xml file per channel
	// be patient this takes time
	splitXMLTVFile(filename);

	return filename;
}

void DEFiles::setInput(DownloadInput d)
{
	DataDownloader::setInput(d);
}

void DEFiles::sendRecordMsg(QStringList data)
{
}

void DEFiles::sentRecordMsg(int exitCode, QProcess::ExitStatus exitStatus)
{
}
