#include <QObject>
#include <QMaemo5InformationBox>
#include <QFile>
#include <QDir>
#include <QDebug>
#include <QProcess>
#include <QTextStream>

#include "datadownloader.h"
#include "sifiles.h"

SIFiles::SIFiles(QObject *parent) : DataDownloader(parent, "/opt/showtime/data/si/"), HELPERPATH("/opt/showtime/helper/")
{
	_settingsFile = new QFile(QString(DATAPATH) + ".si");
	_channelFile = QString(DATAPATH) + ".si_channel_list";
	initSettings();
}

void SIFiles::initSettings()
{
	// just call the parent init settings
	// nothing specific to SI
	DataDownloader::initSettings();
}

QUrl SIFiles::getUrl()
{
	QUrl url;

	QString requestChannelCode = _channelCodeMap[_requestChannel];

	if ( !_useLocal )
		url.setUrl(QString("http://tvprofil.net/xmltv/data/%2/%1_%2_tvprofil.net.xml?APP=SHOWTIME")
                                                            .arg(_requestDate.toString("yyyy-MM-dd")).arg(requestChannelCode) );
	else
		url.setPath(QString(""));

	return url;
}

SIFiles::~SIFiles()
{
}

QString SIFiles::finishedDownload(QString channel, QIODevice *source)
{
	QString filename = saveFile(channel, source);
	return filename;
}

void SIFiles::setInput(DownloadInput d)
{
	DataDownloader::setInput(d);
}

void SIFiles::sendRecordMsg(QStringList data)
{
}

void SIFiles::sentRecordMsg(int exitCode, QProcess::ExitStatus exitStatus)
{
}
