#include <QObject>
#include <QMaemo5InformationBox>
#include <QFile>
#include <QDir>
#include <QDebug>
#include <QProcess>
#include <QTextStream>

#include "datadownloader.h"
#include "dkfiles.h"

DKFiles::DKFiles(QObject *parent) : DataDownloader(parent, "/opt/showtime/data/dk/"), HELPERPATH("/opt/showtime/helper/")
{
	_settingsFile = new QFile(QString(DATAPATH) + ".dk");
	_channelFile = QString(DATAPATH) + ".dk_channel_list";
	initSettings();
}

void DKFiles::initSettings()
{
	// just call the parent init settings
	// nothing specific to DK
	DataDownloader::initSettings();
}

QUrl DKFiles::getUrl()
{
	QUrl url;

	QString requestChannelCode = _channelCodeMap[_requestChannel];

	if ( !_useLocal )
		url.setUrl(QString("http://www.xmltvepg.nl/rytecxmltvnordic.gz?APP=SHOWTIME"));
	else
		url.setPath(QString(""));

	return url;
}

DKFiles::~DKFiles()
{
}

QString DKFiles::finishedDownload(QString channel, QIODevice *source)
{
	channel = "dummy";
	QString filename = saveZipFile(channel, source); 

	// this method will split the huge single xml file per channel
	// be patient this takes time
	splitXMLTVFile(filename);

	return filename;
}

void DKFiles::setInput(DownloadInput d)
{
	DataDownloader::setInput(d);
}

void DKFiles::sendRecordMsg(QStringList data)
{
}

void DKFiles::sentRecordMsg(int exitCode, QProcess::ExitStatus exitStatus)
{
}
