#include <QObject>
#include <QMaemo5InformationBox>
#include <QFile>
#include <QDir>
#include <QDebug>
#include <QProcess>
#include <QTextStream>

#include "datadownloader.h"
#include "aufiles.h"

AUFiles::AUFiles(QObject *parent) : DataDownloader(parent, "/opt/showtime/data/au/"), HELPERPATH("/opt/showtime/data/helper/")
{
	_settingsFile = new QFile(QString(DATAPATH) + ".au");
	_channelFile = QString(DATAPATH) + ".au_channel_list";
	initSettings();
}

void AUFiles::initSettings()
{
	// just call the parent init settings
	// nothing specific to au
	DataDownloader::initSettings();
}

QUrl AUFiles::getUrl()
{
	QUrl url;
	if ( !_useLocal )
		url.setUrl(QString("http://xml.oztivo.net/xmltv/%1_%2.xml.gz?APP=SHOWTIME").arg(_requestChannel).arg(_requestDate.toString("yyyy-MM-dd")) );
	else
		url.setPath(QString(""));

	return url;
}

AUFiles::~AUFiles()
{
}

QString AUFiles::finishedDownload(QString channel, QIODevice *source)
{
	QString filename = saveFile(channel, source);
	return filename;
}

void AUFiles::setInput(DownloadInput d)
{
	DataDownloader::setInput(d);
}

void AUFiles::sendRecordMsg(QStringList data)
{
}

void AUFiles::sentRecordMsg(int exitCode, QProcess::ExitStatus exitStatus)
{

}
