#ifndef REMINDER_H
#define REMINDER_H
#include <QObject>
#include <QDateTime>

class CCalendar;
class CMulticalendar;
class CComponent;

class Reminder : public QObject
{
	Q_OBJECT
	public:
		Reminder();
		~Reminder();
	public:
		bool addCalendar(const QString& calendarName);

		bool removeCalendar(const QString& calendarName);

		void addEvent(const QString& calendarName, const QDateTime& sdate, const QDateTime& edate, 
										const QString& eventName, const QString& description, int type = 1);

		bool checkCalendarNameExists (const QString& calendarName);  	

		void addAlarmEvent(const QString& calendarName, const QDateTime& event_time, const QString& title, const QDateTime& dateStart, 
													const QDateTime& dateEnd, const QString& description);

	private:
		CMulticalendar* multiCalendar;
};
#endif // REMINDER_H
